/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.render.html.renderers;

import com.dragome.guia.GuiaServiceLocator;
import com.dragome.guia.components.interfaces.VisualComponent;
import com.dragome.guia.components.interfaces.VisualLabel;
import com.dragome.helpers.DragomeEntityManager;
import com.dragome.model.interfaces.Renderer;
import com.dragome.model.interfaces.ValueChangeEvent;
import com.dragome.model.interfaces.ValueChangeHandler;
import com.dragome.render.canvas.interfaces.Canvas;
import com.dragome.render.html.renderers.AbstractHTMLComponentRenderer;
import com.dragome.render.html.renderers.MergeableElement;
import org.w3c.dom.Element;

public class HTMLLabelRenderer
extends AbstractHTMLComponentRenderer<VisualLabel<Object>> {
    public Canvas<Element> render(final VisualLabel<Object> visualLabel) {
        Canvas canvas = GuiaServiceLocator.getInstance().getTemplateManager().getCanvasFactory().createCanvas();
        canvas.setContent((Object)new MergeableElement(){
            private String originalAttribute;

            @Override
            public void mergeWith(final Element labelElement) {
                String id = DragomeEntityManager.add((Object)visualLabel);
                this.setInnerText((VisualLabel<Object>)visualLabel, labelElement);
                visualLabel.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Object>(){

                    public void onValueChange(ValueChangeEvent<Object> event) {
                        this.setInnerText((VisualLabel<Object>)visualLabel, labelElement);
                    }
                });
                HTMLLabelRenderer.this.addListeners((VisualComponent)visualLabel, labelElement);
            }

            private void setInnerText(VisualLabel<Object> visualLabel2, Element label1) {
                Renderer renderer = visualLabel2.getRenderer();
                String aText = renderer.render(visualLabel2.getValue());
                String attribute = label1.getAttribute("data-attribute-name");
                if (attribute != null && attribute.length() > 0) {
                    String template = label1.getAttribute("data-attribute-template-" + attribute);
                    if (this.originalAttribute == null) {
                        this.originalAttribute = template;
                    }
                    String replaceAll = this.originalAttribute.replaceAll("\\$\\{template:[^\\}]+}", aText);
                    label1.setAttribute(attribute, replaceAll);
                } else if (aText != null && !aText.trim().isEmpty()) {
                    AbstractHTMLComponentRenderer.setElementInnerHTML(label1, aText == null ? "null" : aText);
                }
            }
        });
        return canvas;
    }
}

