/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.render.html.renderers;

import com.dragome.commons.javascript.ScriptHelper;
import com.dragome.guia.GuiaServiceLocator;
import com.dragome.guia.components.interfaces.VisualComponent;
import com.dragome.guia.components.interfaces.VisualListBox;
import com.dragome.guia.events.listeners.interfaces.ClickListener;
import com.dragome.helpers.DragomeEntityManager;
import com.dragome.model.interfaces.Renderer;
import com.dragome.model.interfaces.ValueChangeEvent;
import com.dragome.model.interfaces.ValueChangeHandler;
import com.dragome.render.canvas.interfaces.Canvas;
import com.dragome.render.html.renderers.AbstractHTMLComponentRenderer;
import com.dragome.render.html.renderers.MergeableElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import org.w3c.dom.Element;

public class HTMLListRenderer
extends AbstractHTMLComponentRenderer<VisualListBox<Object>> {
    public Canvas<Element> render(final VisualListBox<Object> visualList) {
        Canvas canvas = GuiaServiceLocator.getInstance().getTemplateManager().getCanvasFactory().createCanvas();
        canvas.setContent((Object)new MergeableElement(){

            @Override
            public void mergeWith(final Element selectElement) {
                String id = DragomeEntityManager.add((Object)visualList);
                visualList.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Object>(){

                    public void onValueChange(ValueChangeEvent<Object> event) {
                        if (event.getValue() instanceof Collection) {
                            this.selectValue(selectElement, (Collection)event.getValue());
                        } else {
                            this.selectValue(selectElement, Arrays.asList(event.getValue()));
                        }
                    }

                    private void selectValue(Element selectElement2, Collection<Object> values) {
                        Renderer renderer = visualList.getRenderer();
                        ScriptHelper.put((String)"renderedValues", (Object)new Object(), (Object)this);
                        ScriptHelper.eval((String)"renderedValues={}", (Object)this);
                        for (Object object : values) {
                            ScriptHelper.put((String)"value", (Object)renderer.render(object), (Object)this);
                            ScriptHelper.evalNoResult((String)"renderedValues[value]=true", (Object)this);
                        }
                        ScriptHelper.put((String)"sel", (Object)selectElement2, (Object)this);
                        ScriptHelper.evalNoResult((String)"for(var opt, j = 0; opt = sel.node.options[j]; j++) {opt.selected= renderedValues[opt.value]; }", (Object)this);
                    }
                });
                visualList.addListener(ClickListener.class, (EventListener)new ClickListener(){

                    public void clickPerformed(VisualComponent aVisualComponent) {
                        ScriptHelper.put((String)"e", (Object)selectElement, (Object)this);
                        if (ScriptHelper.evalBoolean((String)"e.node.multiple", (Object)this)) {
                            String values = (String)ScriptHelper.eval((String)"(function (){for (var options = e.node.options, values= [], i = 0, len = options.length; i < len;i++)  if (options[i].selected) values.push(options[i].value); return values.join(',')})()", (Object)this);
                            visualList.setSelectedValues(Arrays.asList(values.split(",")));
                        } else {
                            String value = (String)ScriptHelper.eval((String)"e.node.options[e.node.selectedIndex].value", (Object)this);
                            Renderer renderer = visualList.getRenderer();
                            Collection acceptableValues = visualList.getAcceptableValues();
                            for (Object object : acceptableValues) {
                                String render = renderer.render(object);
                                if (!render.equals(value)) continue;
                                visualList.setValue(object);
                            }
                        }
                    }
                });
                selectElement.setAttribute("size", HTMLListRenderer.this.getSelectElementSize() + "");
                if (visualList.isMultipleItems()) {
                    selectElement.setAttribute("multiple", "multiple");
                }
                boolean i = true;
                String options = "";
                for (Object element : visualList.getAcceptableValues()) {
                    Renderer renderer = visualList.getRenderer();
                    String rendered = renderer.render(element);
                    Object value = visualList.getValue();
                    String selected = "";
                    boolean isSelected = visualList.isMultipleItems() && visualList.getSelectedValues().contains(element);
                    if (isSelected |= !visualList.isMultipleItems() && element.equals(value)) {
                        selected = "selected=\"selected\"";
                    }
                    String option = "<option value=\"" + rendered + "\" " + selected + ">" + rendered + "</option>\n";
                    options = options + option;
                }
                AbstractHTMLComponentRenderer.setElementInnerHTML(selectElement, options);
                HTMLListRenderer.this.addListeners((VisualComponent)visualList, selectElement);
            }
        });
        return canvas;
    }

    protected int getSelectElementSize() {
        return 5;
    }
}

