/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.render.html.renderers;

import com.dragome.guia.GuiaServiceLocator;
import com.dragome.guia.components.interfaces.VisualProgressBar;
import com.dragome.model.interfaces.ValueChangeEvent;
import com.dragome.model.interfaces.ValueChangeHandler;
import com.dragome.render.canvas.interfaces.Canvas;
import com.dragome.render.html.renderers.AbstractHTMLComponentRenderer;
import com.dragome.render.interfaces.ComponentRenderer;
import com.dragome.services.WebServiceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HTMLProgressBarRenderer
extends AbstractHTMLComponentRenderer<VisualProgressBar>
implements ComponentRenderer<Element, VisualProgressBar> {
    public Canvas<Element> render(final VisualProgressBar progressBar) {
        Document document = WebServiceLocator.getInstance().getDomHandler().getDocument();
        Element mainDiv = document.createElement("div");
        mainDiv.setAttribute("class", "progressWrap");
        final Element perDiv = document.createElement("div");
        perDiv.setAttribute("class", "progressPer");
        mainDiv.appendChild(perDiv);
        final Element statDiv = document.createElement("div");
        statDiv.setAttribute("class", "progressStat");
        mainDiv.appendChild(statDiv);
        this.updatePercentage(perDiv, statDiv, progressBar);
        progressBar.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Integer>(){

            public void onValueChange(ValueChangeEvent<Integer> event) {
                HTMLProgressBarRenderer.this.updatePercentage(perDiv, statDiv, progressBar);
            }
        });
        Canvas canvas = GuiaServiceLocator.getInstance().getTemplateManager().getCanvasFactory().createCanvas();
        canvas.setContent((Object)mainDiv);
        return canvas;
    }

    private void updatePercentage(Element perDiv, Element statDiv, VisualProgressBar progressBar) {
        HTMLProgressBarRenderer.setElementInnerHTML(perDiv, progressBar.getPercentage() + "%");
        statDiv.setAttribute("style", "width:" + progressBar.getPercentage() + "%;");
    }
}

