/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.render.html.renderers;

import com.dragome.commons.javascript.ScriptHelper;
import com.dragome.guia.GuiaServiceLocator;
import com.dragome.guia.components.VisualRadioButton;
import com.dragome.guia.components.interfaces.VisualComponent;
import com.dragome.guia.events.listeners.interfaces.ClickListener;
import com.dragome.helpers.DragomeEntityManager;
import com.dragome.render.canvas.interfaces.Canvas;
import com.dragome.render.html.renderers.AbstractHTMLComponentRenderer;
import com.dragome.services.WebServiceLocator;
import java.util.EventListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HTMLRadioButtonRenderer
extends AbstractHTMLComponentRenderer<VisualRadioButton> {
    public Canvas<Element> render(final VisualRadioButton radioButton) {
        String id = DragomeEntityManager.add((Object)radioButton);
        Document document = WebServiceLocator.getInstance().getDomHandler().getDocument();
        final Element radioButtonElement = document.createElement("input");
        radioButton.addListener(ClickListener.class, (EventListener)new ClickListener(){

            public void clickPerformed(VisualComponent aVisualComponent) {
                ScriptHelper.put((String)"e", (Object)radioButtonElement, (Object)this);
                boolean value = ScriptHelper.evalBoolean((String)"e.node.checked", (Object)this);
                radioButton.setValue((Object)value);
            }
        });
        radioButtonElement.setAttribute("type", "radio");
        radioButtonElement.setAttribute("value", radioButton.getCaption());
        radioButtonElement.setAttribute("name", radioButton.getButtonGroup());
        if (((Boolean)radioButton.getValue()).booleanValue()) {
            radioButtonElement.setAttribute("checked", "checked");
        }
        this.addListeners((VisualComponent)radioButton, radioButtonElement);
        Canvas canvas = GuiaServiceLocator.getInstance().getTemplateManager().getCanvasFactory().createCanvas();
        canvas.setContent((Object)radioButtonElement);
        return canvas;
    }
}

