/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.render.html.renderers;

import com.dragome.guia.events.listeners.interfaces.StyleChangedListener;
import com.dragome.helpers.DragomeEntityManager;
import com.dragome.model.interfaces.Style;
import com.dragome.services.WebServiceLocator;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.w3c.dom.Element;

public class HTMLStyleChangedListener
implements StyleChangedListener {
    private Element element;

    public void styleChanged(Style style) {
        String entityId = DragomeEntityManager.getEntityId((Object)style.getVisualComponent());
        Element element = WebServiceLocator.getInstance().getDomHandler().getElementBySelector("[data-component-id=\"" + entityId + "\"]");
        if (element != null) {
            String name = style.getName();
            if (!style.isSynchronized()) {
                String attribute = element.getAttribute("class");
                if (attribute == null) {
                    attribute = "";
                }
                String result = (attribute + (name != null ? " " + name : "")).trim();
                style.setName(this.deDup(result));
                style.setSynchronized(true);
            } else {
                if (name != null && name.trim().length() > 0) {
                    element.setAttribute("class", name);
                } else {
                    element.removeAttribute("class");
                }
                if (style.isEnabled()) {
                    element.removeAttribute("disabled");
                } else {
                    element.setAttribute("disabled", "disabled");
                }
            }
        }
    }

    public String deDup(String s) {
        String[] strArr = s.split(" ");
        LinkedHashSet<String> set = new LinkedHashSet<String>(Arrays.asList(strArr));
        String[] result = new String[set.size()];
        set.toArray(result);
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < result.length; ++i) {
            String string = result[i];
            if (i == result.length - 1) {
                res.append(string);
                continue;
            }
            res.append(string).append(" ");
        }
        return res.toString();
    }

    public void boundsChanged(Style style) {
        String entityId = DragomeEntityManager.getEntityId((Object)style.getVisualComponent());
        if (this.element == null) {
            this.element = WebServiceLocator.getInstance().getDomHandler().getElementBySelector("[data-component-id=\"" + entityId + "\"]");
        }
        String styleString = "position: relative; left: ${left}px;top: ${top}px;";
        styleString = styleString.replace("${left}", style.getBounds().getX() + "");
        styleString = styleString.replace("${top}", style.getBounds().getY() + "");
        if (this.element != null) {
            this.element.setAttribute("style", styleString);
        }
    }
}

