/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.render.html.renderers;

import com.dragome.commons.javascript.ScriptHelper;
import com.dragome.guia.GuiaServiceLocator;
import com.dragome.guia.components.interfaces.VisualComponent;
import com.dragome.guia.components.interfaces.VisualTextField;
import com.dragome.guia.events.listeners.interfaces.FocusListener;
import com.dragome.guia.events.listeners.interfaces.InputListener;
import com.dragome.helpers.DragomeEntityManager;
import com.dragome.model.interfaces.ValueChangeEvent;
import com.dragome.model.interfaces.ValueChangeHandler;
import com.dragome.render.canvas.interfaces.Canvas;
import com.dragome.render.html.renderers.AbstractHTMLComponentRenderer;
import com.dragome.render.html.renderers.MergeableElement;
import java.util.EventListener;
import org.w3c.dom.Element;

public class HTMLTextFieldRenderer
extends AbstractHTMLComponentRenderer<VisualTextField<Object>> {
    public Canvas<Element> render(final VisualTextField<Object> visualTextField) {
        Canvas canvas = GuiaServiceLocator.getInstance().getTemplateManager().getCanvasFactory().createCanvas();
        canvas.setContent((Object)new MergeableElement(){

            @Override
            public void mergeWith(final Element textFieldElement) {
                String id = DragomeEntityManager.add((Object)visualTextField);
                visualTextField.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Object>(){

                    public void onValueChange(ValueChangeEvent<Object> event) {
                        String value = visualTextField.getRenderer().render(event.getValue());
                        textFieldElement.setAttribute("value", value);
                        ScriptHelper.put((String)"textFieldElement", (Object)textFieldElement, (Object)this);
                        ScriptHelper.put((String)"value", (Object)value, (Object)this);
                        ScriptHelper.evalNoResult((String)"textFieldElement.node.value=value", (Object)this);
                    }
                });
                visualTextField.addListener(InputListener.class, (EventListener)new InputListener(){

                    public void inputPerformed(VisualComponent visualComponent) {
                        ScriptHelper.put((String)"textFieldElement", (Object)textFieldElement, (Object)this);
                        String value = (String)ScriptHelper.eval((String)"textFieldElement.node.value", (Object)this);
                        visualTextField.setValue((Object)value);
                    }
                });
                visualTextField.addListener(FocusListener.class, (EventListener)new FocusListener(){

                    public void focusGained(VisualComponent component) {
                        ScriptHelper.put((String)"textFieldElement", (Object)textFieldElement, (Object)this);
                        ScriptHelper.evalNoResult((String)"textFieldElement.node.focus()", (Object)this);
                    }

                    public void focusLost(VisualComponent component) {
                    }
                });
                String value = visualTextField.getRenderer().render(visualTextField.getValue());
                textFieldElement.setAttribute("type", "text");
                textFieldElement.setAttribute("value", value);
                ScriptHelper.put((String)"value", (Object)(value == null ? "" : value), (Object)this);
                ScriptHelper.put((String)"textFieldElement", (Object)textFieldElement, (Object)this);
                ScriptHelper.evalNoResult((String)"textFieldElement.node.value=value", (Object)this);
                HTMLTextFieldRenderer.this.addListeners((VisualComponent)visualTextField, textFieldElement);
            }
        });
        return canvas;
    }
}

