/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.render.html.renderers;

import com.dragome.guia.components.interfaces.VisualComponent;
import com.dragome.guia.events.listeners.interfaces.BlurListener;
import com.dragome.guia.events.listeners.interfaces.ClickListener;
import com.dragome.guia.events.listeners.interfaces.DoubleClickListener;
import com.dragome.guia.events.listeners.interfaces.InputListener;
import com.dragome.guia.events.listeners.interfaces.KeyDownListener;
import com.dragome.guia.events.listeners.interfaces.KeyPressListener;
import com.dragome.guia.events.listeners.interfaces.KeyUpListener;
import com.dragome.guia.events.listeners.interfaces.MouseDownListener;
import com.dragome.guia.events.listeners.interfaces.MouseOutListener;
import com.dragome.guia.events.listeners.interfaces.MouseOverListener;
import com.dragome.guia.events.listeners.interfaces.MouseUpListener;
import com.dragome.web.enhancers.jsdelegate.JsCast;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.KeyboardEvent;

public class MultipleEventListener<T>
implements EventListener {
    private final VisualComponent visualComponent;
    public static final String KEYPRESS = "keypress";
    public static final String KEYDOWN = "keydown";
    public static final String KEYUP = "keyup";
    public static final String INPUT = "input";
    public static final String BLUR = "blur";
    public static final String MOUSEOUT = "mouseout";
    public static final String MOUSEOVER = "mouseover";
    public static final String MOUSEDOWN = "mousedown";
    public static final String MOUSEUP = "mouseup";
    public static final String DBLCLICK = "dblclick";
    public static final String CLICK = "click";

    public MultipleEventListener(VisualComponent visualComponent) {
        this.visualComponent = visualComponent;
    }

    @Override
    public void handleEvent(Event event) {
        String type = event.getType();
        if (type.equals(CLICK)) {
            ((ClickListener)this.visualComponent.getListener(ClickListener.class)).clickPerformed(this.visualComponent);
        } else if (type.equals(DBLCLICK)) {
            ((DoubleClickListener)this.visualComponent.getListener(DoubleClickListener.class)).doubleClickPerformed(this.visualComponent);
        } else if (type.equals(MOUSEOVER)) {
            ((MouseOverListener)this.visualComponent.getListener(MouseOverListener.class)).mouseOverPerformed(this.visualComponent);
        } else if (type.equals(MOUSEOUT)) {
            ((MouseOutListener)this.visualComponent.getListener(MouseOutListener.class)).mouseOutPerformed(this.visualComponent);
        } else if (type.equals(MOUSEDOWN)) {
            ((MouseDownListener)this.visualComponent.getListener(MouseDownListener.class)).mouseDownPerformed(null);
        } else if (type.equals(MOUSEUP)) {
            ((MouseUpListener)this.visualComponent.getListener(MouseUpListener.class)).mouseUpPerformed(this.visualComponent);
        } else if (type.equals(BLUR)) {
            ((BlurListener)this.visualComponent.getListener(BlurListener.class)).blurPerformed(this.visualComponent);
        } else if (type.equals(INPUT)) {
            ((InputListener)this.visualComponent.getListener(InputListener.class)).inputPerformed(this.visualComponent);
        } else {
            KeyboardEvent keyboardEvent = (KeyboardEvent)JsCast.castTo((Object)event, KeyboardEvent.class);
            if (type.equals(KEYUP)) {
                ((KeyUpListener)this.visualComponent.getListener(KeyUpListener.class)).keyupPerformed(this.visualComponent, keyboardEvent.getKeyCode());
            } else if (type.equals(KEYDOWN)) {
                ((KeyDownListener)this.visualComponent.getListener(KeyDownListener.class)).keydownPerformed(this.visualComponent, keyboardEvent.getKeyCode());
            } else if (type.equals(KEYPRESS)) {
                ((KeyPressListener)this.visualComponent.getListener(KeyPressListener.class)).keypressPerformed(this.visualComponent, keyboardEvent.getKeyCode());
            }
        }
    }
}

