/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.templates;

import com.dragome.templates.ContentImpl;
import com.dragome.templates.TemplateImpl;
import com.dragome.templates.interfaces.Content;
import com.dragome.templates.interfaces.Template;
import com.dragome.web.html.dom.RegExp;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HTMLTemplateFactory {
    public static final String DATA_TEMPLATE = "data-template";

    public Template createTemplate(Element fromElement, String aTemplateName) {
        Template template = HTMLTemplateFactory.createTemplate(aTemplateName);
        template.setFiringEvents(false);
        Element mainElement = fromElement;
        String attributeValue = fromElement.getAttribute(DATA_TEMPLATE);
        if (attributeValue.equals("")) {
            mainElement = (Element)HTMLTemplateFactory.getTemplateElements(fromElement, aTemplateName, false).get(0);
        }
        List subTemplates = HTMLTemplateFactory.getTemplateElements(mainElement, ".+", false);
        for (int i = 0; i < subTemplates.size(); ++i) {
            Element childTemplateElement = (Element)subTemplates.get(i);
            String childTemplateName = childTemplateElement.getAttribute(DATA_TEMPLATE);
            template.addChild(this.createTemplate(childTemplateElement, childTemplateName));
        }
        template.setContent((Content)new ContentImpl((Object)mainElement));
        template.setInner(Boolean.valueOf(mainElement.getAttribute(DATA_TEMPLATE).indexOf("*") != -1));
        mainElement.setAttribute(DATA_TEMPLATE, "replaced: " + aTemplateName);
        template.setFiringEvents(true);
        return template;
    }

    public static List getTemplateElements(Element fromNode, String aNameRegexp, boolean deepSearch) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList childs = fromNode.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            String attribute = child.getAttribute(DATA_TEMPLATE);
            boolean isTemplate = attribute != null && new RegExp(aNameRegexp).test(attribute);
            NamedNodeMap attributes = child.getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Attr item;
                Node item2 = attributes.item(j);
                if (!(item2 instanceof Attr) || !(item = (Attr)item2).getName().startsWith("data-attribute-template-")) continue;
                String value = item.getValue().substring(item.getValue().indexOf("${template:") + 11, item.getValue().indexOf("}"));
                String name = item.getName().substring(item.getName().indexOf("data-attribute-template-") + 24);
                child.setAttribute(DATA_TEMPLATE, value);
                child.setAttribute("data-attribute-name", name);
                isTemplate = true;
                result.addAll(HTMLTemplateFactory.getTemplateElements(child, aNameRegexp, deepSearch));
            }
            if (isTemplate) {
                result.add(child);
            }
            if (isTemplate && !deepSearch) continue;
            result.addAll(HTMLTemplateFactory.getTemplateElements(child, aNameRegexp, deepSearch));
        }
        return result;
    }

    public static Template createTemplate() {
        TemplateImpl template = new TemplateImpl();
        return template;
    }

    public static Template createTemplate(String name) {
        TemplateImpl template = new TemplateImpl(name);
        return template;
    }
}

