/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.column;

import com.github.mauricio.async.db.column.ColumnDecoder;
import com.github.mauricio.async.db.column.ColumnEncoder;
import com.github.mauricio.async.db.column.ColumnEncoderDecoder;
import com.github.mauricio.async.db.column.TimestampEncoderDecoder$;
import com.github.mauricio.async.db.exceptions.DateEncoderNotAvailableException;
import com.github.mauricio.async.db.general.ColumnData;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005}<QAG\u000e\t\u0002!2QAK\u000e\t\u0002-BQAM\u0001\u0005\u0002MBq\u0001N\u0001C\u0002\u0013\u0005Q\u0007\u0003\u0004?\u0003\u0001\u0006IA\u000e\u0005\b\u007f\u0005\u0011\r\u0011\"\u00016\u0011\u0019\u0001\u0015\u0001)A\u0005m!9\u0011)\u0001b\u0001\n\u0003\u0011\u0005B\u0002@\u0002A\u0003%1I\u0002\u0003+7\u0001!\u0005\"\u0002\u001a\n\t\u0003A\u0005bB%\n\u0005\u0004%IA\u0013\u0005\u0007/&\u0001\u000b\u0011B&\t\u000faK!\u0019!C\u0005\u0015\"1\u0011,\u0003Q\u0001\n-CqAW\u0005C\u0002\u0013%1\f\u0003\u0004`\u0013\u0001\u0006I\u0001\u0018\u0005\bA&\u0011\r\u0011\"\u0003b\u0011\u0019)\u0017\u0002)A\u0005E\"9a-\u0003b\u0001\n\u0013\t\u0007BB4\nA\u0003%!\rC\u0004O\u0013\t\u0007I\u0011B1\t\r!L\u0001\u0015!\u0003c\u0011\u0015I\u0017\u0002\"\u0001b\u0011\u0015Q\u0017\u0002\"\u0011l\u0011\u0015Y\u0018\u0002\"\u0011}\u0003]!\u0016.\\3ti\u0006l\u0007/\u00128d_\u0012,'\u000fR3d_\u0012,'O\u0003\u0002\u001d;\u000511m\u001c7v[:T!AH\u0010\u0002\u0005\u0011\u0014'B\u0001\u0011\"\u0003\u0015\t7/\u001f8d\u0015\t\u00113%\u0001\u0005nCV\u0014\u0018nY5p\u0015\t!S%\u0001\u0004hSRDWO\u0019\u0006\u0002M\u0005\u00191m\\7\u0004\u0001A\u0011\u0011&A\u0007\u00027\t9B+[7fgR\fW\u000e]#oG>$WM\u001d#fG>$WM]\n\u0003\u00031\u0002\"!\f\u0019\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001)\u0003)\u0011\u0015m]3G_Jl\u0017\r^\u000b\u0002mA\u0011q\u0007P\u0007\u0002q)\u0011\u0011HO\u0001\u0005Y\u0006twMC\u0001<\u0003\u0011Q\u0017M^1\n\u0005uB$AB*ue&tw-A\u0006CCN,gi\u001c:nCR\u0004\u0013\u0001D'jY2L7OR8s[\u0006$\u0018!D'jY2L7OR8s[\u0006$\b%\u0001\u0005J]N$\u0018M\\2f+\u0005\u0019\u0005CA\u0015\n'\rIA&\u0012\t\u0003S\u0019K!aR\u000e\u0003)\r{G.^7o\u000b:\u001cw\u000eZ3s\t\u0016\u001cw\u000eZ3s)\u0005\u0019\u0015\u0001C8qi&|g.\u00197\u0016\u0003-\u0003\"\u0001T+\u000e\u00035S!AT(\u0002\r\u0019|'/\\1u\u0015\t\u0001\u0016+\u0001\u0003uS6,'B\u0001*T\u0003\u0011Qw\u000eZ1\u000b\u0003Q\u000b1a\u001c:h\u0013\t1VJ\u0001\bECR,G+[7f!\u0006\u00148/\u001a:\u0002\u0013=\u0004H/[8oC2\u0004\u0013\u0001E8qi&|g.\u00197US6,'l\u001c8f\u0003Ey\u0007\u000f^5p]\u0006dG+[7f5>tW\rI\u0001\bEVLG\u000eZ3s+\u0005a\u0006C\u0001'^\u0013\tqVJ\u0001\rECR,G+[7f\r>\u0014X.\u0019;uKJ\u0014U/\u001b7eKJ\f\u0001BY;jY\u0012,'\u000fI\u0001\u0011i&lWM_8oK\u0012\u0004&/\u001b8uKJ,\u0012A\u0019\t\u0003\u0019\u000eL!\u0001Z'\u0003#\u0011\u000bG/\u001a+j[\u00164uN]7biR,'/A\tuS6,'p\u001c8fIB\u0013\u0018N\u001c;fe\u0002\n1C\\8o)&lWM_8oK\u0012\u0004&/\u001b8uKJ\fAC\\8o)&lWM_8oK\u0012\u0004&/\u001b8uKJ\u0004\u0013a\u00024pe6\fG\u000fI\u0001\nM>\u0014X.\u0019;uKJ\fa\u0001Z3d_\u0012,GC\u00017p!\tiS.\u0003\u0002o]\t\u0019\u0011I\\=\t\u000bAD\u0002\u0019A9\u0002\u000bY\fG.^3\u0011\u0005ILhBA:x!\t!h&D\u0001v\u0015\t1x%\u0001\u0004=e>|GOP\u0005\u0003q:\na\u0001\u0015:fI\u00164\u0017BA\u001f{\u0015\tAh&\u0001\u0004f]\u000e|G-\u001a\u000b\u0003cvDQ\u0001]\rA\u00021\f\u0011\"\u00138ti\u0006t7-\u001a\u0011")
public class TimestampEncoderDecoder
implements ColumnEncoderDecoder {
    private final DateTimeParser optional;
    private final DateTimeParser optionalTimeZone;
    private final DateTimeFormatterBuilder builder;
    private final DateTimeFormatter timezonedPrinter;
    private final DateTimeFormatter nonTimezonedPrinter;
    private final DateTimeFormatter format;

    public static TimestampEncoderDecoder Instance() {
        return TimestampEncoderDecoder$.MODULE$.Instance();
    }

    public static String MillisFormat() {
        return TimestampEncoderDecoder$.MODULE$.MillisFormat();
    }

    public static String BaseFormat() {
        return TimestampEncoderDecoder$.MODULE$.BaseFormat();
    }

    @Override
    public Object decode(ColumnData kind, ByteBuf value, Charset charset) {
        return ColumnDecoder.decode$(this, kind, value, charset);
    }

    @Override
    public boolean supportsStringDecoding() {
        return ColumnDecoder.supportsStringDecoding$(this);
    }

    private DateTimeParser optional() {
        return this.optional;
    }

    private DateTimeParser optionalTimeZone() {
        return this.optionalTimeZone;
    }

    private DateTimeFormatterBuilder builder() {
        return this.builder;
    }

    private DateTimeFormatter timezonedPrinter() {
        return this.timezonedPrinter;
    }

    private DateTimeFormatter nonTimezonedPrinter() {
        return this.nonTimezonedPrinter;
    }

    private DateTimeFormatter format() {
        return this.format;
    }

    public DateTimeFormatter formatter() {
        return this.format();
    }

    @Override
    public Object decode(String value) {
        return this.formatter().parseLocalDateTime(value);
    }

    @Override
    public String encode(Object value) {
        String string;
        Object object = value;
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            string = this.timezonedPrinter().print((ReadableInstant)new DateTime((Object)timestamp));
        } else if (object instanceof Date) {
            Date date = (Date)object;
            string = this.timezonedPrinter().print((ReadableInstant)new DateTime((Object)date));
        } else if (object instanceof Calendar) {
            Calendar calendar = (Calendar)object;
            string = this.timezonedPrinter().print((ReadableInstant)new DateTime((Object)calendar));
        } else if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            string = this.nonTimezonedPrinter().print((ReadablePartial)localDateTime);
        } else if (object instanceof ReadableDateTime) {
            ReadableDateTime readableDateTime = (ReadableDateTime)object;
            string = this.timezonedPrinter().print((ReadableInstant)readableDateTime);
        } else {
            throw new DateEncoderNotAvailableException(value);
        }
        return string;
    }

    public TimestampEncoderDecoder() {
        ColumnEncoder.$init$(this);
        ColumnDecoder.$init$(this);
        this.optional = new DateTimeFormatterBuilder().appendPattern(TimestampEncoderDecoder$.MODULE$.MillisFormat()).toParser();
        this.optionalTimeZone = new DateTimeFormatterBuilder().appendPattern("Z").toParser();
        this.builder = new DateTimeFormatterBuilder().appendPattern(TimestampEncoderDecoder$.MODULE$.BaseFormat()).appendOptional(this.optional()).appendOptional(this.optionalTimeZone());
        this.timezonedPrinter = new DateTimeFormatterBuilder().appendPattern(new StringBuilder(1).append(TimestampEncoderDecoder$.MODULE$.BaseFormat()).append(TimestampEncoderDecoder$.MODULE$.MillisFormat()).append("Z").toString()).toFormatter();
        this.nonTimezonedPrinter = new DateTimeFormatterBuilder().appendPattern(new StringBuilder(0).append(TimestampEncoderDecoder$.MODULE$.BaseFormat()).append(TimestampEncoderDecoder$.MODULE$.MillisFormat()).toString()).toFormatter();
        this.format = this.builder().toFormatter();
    }
}

