/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.pool;

import com.github.mauricio.async.db.pool.AsyncObjectPool;
import com.github.mauricio.async.db.pool.ObjectFactory;
import com.github.mauricio.async.db.pool.PoolAlreadyTerminatedException;
import com.github.mauricio.async.db.pool.PoolConfiguration;
import com.github.mauricio.async.db.pool.PoolExhaustedException;
import com.github.mauricio.async.db.pool.SingleThreadedAsyncObjectPool$;
import com.github.mauricio.async.db.util.Worker;
import com.github.mauricio.async.db.util.Worker$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\t\u0005r!B\u00193\u0011\u0003yd!B!3\u0011\u0003\u0011\u0005\"B%\u0002\t\u0003Q\u0005bB&\u0002\u0005\u0004%\t\u0001\u0014\u0005\u00073\u0006\u0001\u000b\u0011B'\t\u000fi\u000b!\u0019!C\u00017\"1A-\u0001Q\u0001\nq3A!\u0011\u001a\u0001K\"AQo\u0002B\u0001B\u0003%a\u000f\u0003\u0005z\u000f\t\u0005\t\u0015!\u0003{\u0011\u0015Iu\u0001\"\u0001~\u0011%\t\u0019a\u0002b\u0001\n\u0013\t)\u0001\u0003\u0005\u0002\u0012\u001d\u0001\u000b\u0011BA\u0004\u0011%\t\u0019b\u0002a\u0001\n\u0013\t)\u0002C\u0005\u0002P\u001d\u0001\r\u0011\"\u0003\u0002R!A\u0011QL\u0004!B\u0013\t9\u0002C\u0005\u0002`\u001d\u0011\r\u0011\"\u0003\u0002b!A\u0011qN\u0004!\u0002\u0013\t\u0019\u0007C\u0005\u0002r\u001d\u0011\r\u0011\"\u0003\u0002t!A\u0011QQ\u0004!\u0002\u0013\t)\bC\u0005\u0002\b\u001e\u0011\r\u0011\"\u0003\u0002\n\"A\u00111S\u0004!\u0002\u0013\tY\tC\u0005\u0002\u0016\u001e\u0011\r\u0011\"\u0003\u0002\u0018\"A\u0011\u0011U\u0004!\u0002\u0013\tI\nC\u0005\u0002$\u001e\u0001\r\u0011\"\u0003\u0002&\"I\u0011QV\u0004A\u0002\u0013%\u0011q\u0016\u0005\t\u0003g;\u0001\u0015)\u0003\u0002(\"9\u0011QW\u0004\u0005\u0002\u0005]\u0006bBA`\u000f\u0011\u0005\u0011\u0011\u0019\u0005\b\u0003\u000f<A\u0011AAS\u0011\u001d\tIm\u0002C\u0001\u0003\u0017Dq!!4\b\t\u0003\ty\rC\u0004\u0002j\u001e!\t!a4\t\u000f\u0005-x\u0001\"\u0001\u0002n\"9\u0011\u0011_\u0004\u0005\u0002\u0005\u0015\u0006bBAz\u000f\u0011%\u0011Q\u001f\u0005\b\u0003\u007f<A\u0011\u0002B\u0001\u0011\u001d\u0011)a\u0002C\u0005\u0005\u000fAqAa\u0003\b\t\u0013\u0011i\u0001C\u0004\u0003\u0012\u001d!\tEa\u0005\t\u000f\tUq\u0001\"\u0003\u0003\u0018!9!\u0011D\u0004\u0005\n\tmaABA\u0016\u000f\u0011\ti\u0003\u0003\u0006\u00022)\u0012)\u0019!C\u0001\u0003gA!\"!\u000f+\u0005\u0003\u0005\u000b\u0011BA\u001b\u0011\u0019I%\u0006\"\u0001\u0002<!I\u0011\u0011\t\u0016C\u0002\u0013\u0005\u00111\t\u0005\t\u0003\u0017R\u0003\u0015!\u0003\u0002F!9\u0011Q\n\u0016\u0005\u0002\u0005\r\u0013!H*j]\u001edW\r\u00165sK\u0006$W\rZ!ts:\u001cwJ\u00196fGR\u0004vn\u001c7\u000b\u0005M\"\u0014\u0001\u00029p_2T!!\u000e\u001c\u0002\u0005\u0011\u0014'BA\u001c9\u0003\u0015\t7/\u001f8d\u0015\tI$(\u0001\u0005nCV\u0014\u0018nY5p\u0015\tYD(\u0001\u0004hSRDWO\u0019\u0006\u0002{\u0005\u00191m\\7\u0004\u0001A\u0011\u0001)A\u0007\u0002e\ti2+\u001b8hY\u0016$\u0006N]3bI\u0016$\u0017i]=oG>\u0013'.Z2u!>|Gn\u0005\u0002\u0002\u0007B\u0011AiR\u0007\u0002\u000b*\ta)A\u0003tG\u0006d\u0017-\u0003\u0002I\u000b\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A \u0002\u000f\r{WO\u001c;feV\tQ\n\u0005\u0002O/6\tqJ\u0003\u0002Q#\u00061\u0011\r^8nS\u000eT!AU*\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002U+\u0006!Q\u000f^5m\u0015\u00051\u0016\u0001\u00026bm\u0006L!\u0001W(\u0003\u0015\u0005#x.\\5d\u0019>tw-\u0001\u0005D_VtG/\u001a:!\u0003\rawnZ\u000b\u00029B\u0011QLY\u0007\u0002=*\u0011q\fY\u0001\u0006g24GG\u001b\u0006\u0002C\u0006\u0019qN]4\n\u0005\rt&A\u0002'pO\u001e,'/\u0001\u0003m_\u001e\u0004SC\u00014m'\r91i\u001a\t\u0004\u0001\"T\u0017BA53\u0005=\t5/\u001f8d\u001f\nTWm\u0019;Q_>d\u0007CA6m\u0019\u0001!Q!\\\u0004C\u00029\u0014\u0011\u0001V\t\u0003_J\u0004\"\u0001\u00129\n\u0005E,%a\u0002(pi\"Lgn\u001a\t\u0003\tNL!\u0001^#\u0003\u0007\u0005s\u00170A\u0004gC\u000e$xN]=\u0011\u0007\u0001;(.\u0003\u0002ye\tiqJ\u00196fGR4\u0015m\u0019;pef\fQbY8oM&<WO]1uS>t\u0007C\u0001!|\u0013\ta(GA\tQ_>d7i\u001c8gS\u001e,(/\u0019;j_:$BA`@\u0002\u0002A\u0019\u0001i\u00026\t\u000bUT\u0001\u0019\u0001<\t\u000beT\u0001\u0019\u0001>\u0002\u00115\f\u0017N\u001c)p_2,\"!a\u0002\u0011\t\u0005%\u0011QB\u0007\u0003\u0003\u0017Q!\u0001\u0016\u001b\n\t\u0005=\u00111\u0002\u0002\u0007/>\u00148.\u001a:\u0002\u00135\f\u0017N\u001c)p_2\u0004\u0013!\u00039p_2\f'\r\\3t+\t\t9\u0002\u0005\u0004\u0002\u001a\u0005\r\u0012qE\u0007\u0003\u00037QA!!\b\u0002 \u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003C)\u0015AC2pY2,7\r^5p]&!\u0011QEA\u000e\u0005\u0011a\u0015n\u001d;\u0011\t\u0005%\"F[\u0007\u0002\u000f\tq\u0001k\\8mC\ndW\rS8mI\u0016\u0014X\u0003BA\u0018\u0003o\u0019\"AK\"\u0002\t%$X-\\\u000b\u0003\u0003k\u00012a[A\u001c\t\u0015i'F1\u0001o\u0003\u0015IG/Z7!)\u0011\ti$a\u0010\u0011\u000b\u0005%\"&!\u000e\t\u000f\u0005ER\u00061\u0001\u00026\u0005!A/[7f+\t\t)\u0005E\u0002E\u0003\u000fJ1!!\u0013F\u0005\u0011auN\\4\u0002\u000bQLW.\u001a\u0011\u0002\u0017QLW.Z#mCB\u001cX\rZ\u0001\u000ea>|G.\u00192mKN|F%Z9\u0015\t\u0005M\u0013\u0011\f\t\u0004\t\u0006U\u0013bAA,\u000b\n!QK\\5u\u0011%\tYFDA\u0001\u0002\u0004\t9\"A\u0002yIE\n!\u0002]8pY\u0006\u0014G.Z:!\u0003%\u0019\u0007.Z2l_V$8/\u0006\u0002\u0002dA)\u0011QMA6U6\u0011\u0011q\r\u0006\u0005\u0003S\ny\"A\u0004nkR\f'\r\\3\n\t\u00055\u0014q\r\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'/\u0001\u0006dQ\u0016\u001c7n\\;ug\u0002\n\u0011b^1jiF+X-^3\u0016\u0005\u0005U\u0004CBA3\u0003o\nY(\u0003\u0003\u0002z\u0005\u001d$!B)vKV,\u0007#BA?\u0003\u0003SWBAA@\u0015\t\u0011V)\u0003\u0003\u0002\u0004\u0006}$a\u0002)s_6L7/Z\u0001\u000bo\u0006LG/U;fk\u0016\u0004\u0013!\u0002;j[\u0016\u0014XCAAF!\u0011\ti)a$\u000e\u0003MK1!!%T\u0005\u0015!\u0016.\\3s\u0003\u0019!\u0018.\\3sA\u0005y1M]3bi\u0016\u001cV-\\1qQ>\u0014X-\u0006\u0002\u0002\u001aB!\u00111TAO\u001b\u0005\t\u0016bAAP#\nI1+Z7ba\"|'/Z\u0001\u0011GJ,\u0017\r^3TK6\f\u0007\u000f[8sK\u0002\naa\u00197pg\u0016$WCAAT!\r!\u0015\u0011V\u0005\u0004\u0003W+%a\u0002\"p_2,\u0017M\\\u0001\u000bG2|7/\u001a3`I\u0015\fH\u0003BA*\u0003cC\u0011\"a\u0017\u001a\u0003\u0003\u0005\r!a*\u0002\u000f\rdwn]3eA\u0005!A/Y6f+\t\tI\fE\u0003\u0002~\u0005m&.\u0003\u0003\u0002>\u0006}$A\u0002$viV\u0014X-\u0001\u0005hSZ,')Y2l)\u0011\t\u0019-!2\u0011\u000b\u0005u\u00141X4\t\r\u0005EB\u00041\u0001k\u0003\u0019I7OR;mY\u0006)1\r\\8tKV\u0011\u00111Y\u0001\u000bCZ\f\u0017\u000e\\1cY\u0016\u001cXCAAi!\u0015\t\u0019.a9k\u001d\u0011\t).a8\u000f\t\u0005]\u0017Q\\\u0007\u0003\u00033T1!a7?\u0003\u0019a$o\\8u}%\ta)C\u0002\u0002b\u0016\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002f\u0006\u001d(\u0001C%uKJ\f'\r\\3\u000b\u0007\u0005\u0005X)A\u0003j]V\u001bX-\u0001\u0004rk\u0016,X\rZ\u000b\u0003\u0003_\u0004b!a5\u0002d\u0006m\u0014\u0001C5t\u00072|7/\u001a3\u0002\u000f\u0005$GMQ1dWR1\u00111KA|\u0003sDa!!\r$\u0001\u0004Q\u0007bBA~G\u0001\u0007\u0011Q`\u0001\baJ|W.[:f!\u0015\ti(!!h\u00039)g.];fk\u0016\u0004&o\\7jg\u0016$B!a\u0015\u0003\u0004!9\u00111 \u0013A\u0002\u0005m\u0014\u0001C2iK\u000e\\w.\u001e;\u0015\t\u0005M#\u0011\u0002\u0005\b\u0003w,\u0003\u0019AA>\u0003I\u0019'/Z1uK>\u0013(+\u001a;ve:LE/Z7\u0015\t\u0005M#q\u0002\u0005\b\u0003w4\u0003\u0019AA>\u0003!1\u0017N\\1mSj,GCAA*\u0003-!Xm\u001d;PE*,7\r^:\u0016\u0005\u0005M\u0013a\u00023fgR\u0014x.\u001f\u000b\u0005\u0003'\u0012i\u0002\u0003\u0004\u0003 %\u0002\rA[\u0001\u0002S\u0002")
public class SingleThreadedAsyncObjectPool<T>
implements AsyncObjectPool<T> {
    private final ObjectFactory<T> factory;
    private final PoolConfiguration configuration;
    private final Worker com$github$mauricio$async$db$pool$SingleThreadedAsyncObjectPool$$mainPool;
    private List<PoolableHolder<T>> poolables;
    private final ArrayBuffer<T> checkouts;
    private final Queue<Promise<T>> waitQueue;
    private final Timer timer;
    private final Semaphore createSemaphore;
    private boolean closed;

    public static Logger log() {
        return SingleThreadedAsyncObjectPool$.MODULE$.log();
    }

    public static AtomicLong Counter() {
        return SingleThreadedAsyncObjectPool$.MODULE$.Counter();
    }

    @Override
    public <A> Future<A> use(Function1<T, Future<A>> f, ExecutionContext executionContext) {
        return AsyncObjectPool.use$(this, f, executionContext);
    }

    public Worker com$github$mauricio$async$db$pool$SingleThreadedAsyncObjectPool$$mainPool() {
        return this.com$github$mauricio$async$db$pool$SingleThreadedAsyncObjectPool$$mainPool;
    }

    private List<PoolableHolder<T>> poolables() {
        return this.poolables;
    }

    private void poolables_$eq(List<PoolableHolder<T>> x$1) {
        this.poolables = x$1;
    }

    private ArrayBuffer<T> checkouts() {
        return this.checkouts;
    }

    private Queue<Promise<T>> waitQueue() {
        return this.waitQueue;
    }

    private Timer timer() {
        return this.timer;
    }

    private Semaphore createSemaphore() {
        return this.createSemaphore;
    }

    private boolean closed() {
        return this.closed;
    }

    private void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    @Override
    public Future<T> take() {
        if (this.closed()) {
            return Promise$.MODULE$.failed((Throwable)new PoolAlreadyTerminatedException()).future();
        }
        Promise promise = Promise$.MODULE$.apply();
        this.checkout(promise);
        return promise.future();
    }

    @Override
    public Future<AsyncObjectPool<T>> giveBack(T item) {
        Promise promise = Promise$.MODULE$.apply();
        this.com$github$mauricio$async$db$pool$SingleThreadedAsyncObjectPool$$mainPool().action((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            int idx = this.checkouts().indexOf(item);
            if (idx >= 0) {
                this.checkouts().remove(idx);
                Try<Object> try_ = $this.factory.validate(item);
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Object item = success.value();
                    this.addBack(item, promise);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                } else {
                    if (!(try_ instanceof Failure)) throw new MatchError(try_);
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    this.destroy(item);
                    promise.failure(e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return;
            } else {
                Option option;
                Object object = item;
                if (object instanceof Object) {
                    Object object2 = object;
                    option = this.poolables().find((Function1 & Serializable)holder -> BoxesRunTime.boxToBoolean((boolean)SingleThreadedAsyncObjectPool.$anonfun$giveBack$2(object2, holder)));
                } else {
                    option = this.poolables().find((Function1 & Serializable)holder -> BoxesRunTime.boxToBoolean((boolean)SingleThreadedAsyncObjectPool.$anonfun$giveBack$3(item, holder)));
                }
                boolean isFromOurPool = option.isDefined();
                if (isFromOurPool) {
                    promise.failure((Throwable)new IllegalStateException("This item has already been returned"));
                    return;
                } else {
                    promise.failure((Throwable)new IllegalArgumentException("The returned item did not come from this pool."));
                }
            }
        });
        return promise.future();
    }

    public boolean isFull() {
        return this.poolables().isEmpty() && this.checkouts().size() == this.configuration.maxObjects();
    }

    @Override
    public Future<AsyncObjectPool<T>> close() {
        Future future;
        try {
            Promise promise = Promise$.MODULE$.apply();
            this.com$github$mauricio$async$db$pool$SingleThreadedAsyncObjectPool$$mainPool().action((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                if (!this.closed()) {
                    try {
                        this.timer().cancel();
                        this.com$github$mauricio$async$db$pool$SingleThreadedAsyncObjectPool$$mainPool().shutdown();
                        this.closed_$eq(true);
                        ((List)this.poolables().map((Function1 & Serializable)i -> i.item()).$plus$plus(this.checkouts())).foreach((Function1 & Serializable)item -> {
                            this.destroy(item);
                            return BoxedUnit.UNIT;
                        });
                        promise.success((Object)this);
                    }
                    catch (Exception e) {
                        promise.failure((Throwable)e);
                    }
                } else {
                    promise.success((Object)this);
                }
            });
            future = promise.future();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof RejectedExecutionException) || !this.closed()) {
                throw throwable;
            }
            Future future2 = Future$.MODULE$.successful((Object)this);
            future = future2;
        }
        return future;
    }

    public Iterable<T> availables() {
        return this.poolables().map((Function1 & Serializable)item -> item.item());
    }

    public Iterable<T> inUse() {
        return this.checkouts();
    }

    public Iterable<Promise<T>> queued() {
        return this.waitQueue();
    }

    public boolean isClosed() {
        return this.closed();
    }

    private void addBack(T item, Promise<AsyncObjectPool<T>> promise) {
        this.poolables_$eq(this.poolables().$colon$colon(new PoolableHolder<T>(this, item)));
        if (this.waitQueue().nonEmpty()) {
            this.checkout((Promise)this.waitQueue().dequeue());
        }
        promise.success((Object)this);
    }

    private void enqueuePromise(Promise<T> promise) {
        if (this.waitQueue().size() >= this.configuration.maxQueueSize()) {
            PoolExhaustedException exception = new PoolExhaustedException("There are no objects available and the waitQueue is full");
            exception.fillInStackTrace();
            promise.failure((Throwable)exception);
        } else {
            this.waitQueue().$plus$eq(promise);
        }
    }

    private void checkout(Promise<T> promise) {
        this.com$github$mauricio$async$db$pool$SingleThreadedAsyncObjectPool$$mainPool().action((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if (this.isFull()) {
                this.enqueuePromise(promise);
            } else {
                this.createOrReturnItem(promise);
            }
        });
    }

    private void createOrReturnItem(Promise<T> promise) {
        if (this.poolables().isEmpty() && this.createSemaphore().tryAcquire()) {
            try {
                T item = this.factory.create();
                this.checkouts().$plus$eq(item);
                promise.success(item);
            }
            catch (Exception e) {
                promise.failure((Throwable)e);
                this.createSemaphore().release();
            }
        } else {
            List<PoolableHolder<T>> list = this.poolables();
            if (!(list instanceof .colon.colon)) {
                throw new MatchError(list);
            }
            .colon.colon colon2 = (.colon.colon)list;
            PoolableHolder h = (PoolableHolder)colon2.head();
            List t = colon2.next$access$1();
            Tuple2 tuple2 = new Tuple2((Object)h, (Object)t);
            Tuple2 tuple22 = tuple2;
            PoolableHolder h2 = (PoolableHolder)tuple22._1();
            List t2 = (List)tuple22._2();
            this.poolables_$eq(t2);
            Object item = h2.item();
            this.checkouts().$plus$eq(item);
            promise.success(item);
        }
    }

    public void finalize() {
        this.close();
    }

    public void com$github$mauricio$async$db$pool$SingleThreadedAsyncObjectPool$$testObjects() {
        ArrayBuffer removals = new ArrayBuffer();
        this.poolables().foreach((Function1 & Serializable)poolable -> {
            SingleThreadedAsyncObjectPool.$anonfun$testObjects$1(this, removals, poolable);
            return BoxedUnit.UNIT;
        });
        this.poolables_$eq((List)this.poolables().diff((Seq)removals));
    }

    private void destroy(T i) {
        this.factory.destroy(i);
        this.createSemaphore().release();
    }

    public static final /* synthetic */ boolean $anonfun$giveBack$2(Object x2$1, PoolableHolder holder) {
        return x2$1 == holder.item();
    }

    public static final /* synthetic */ boolean $anonfun$giveBack$3(Object item$1, PoolableHolder holder) {
        return BoxesRunTime.equals((Object)item$1, holder.item());
    }

    public static final /* synthetic */ void $anonfun$testObjects$1(SingleThreadedAsyncObjectPool $this, ArrayBuffer removals$1, PoolableHolder poolable) {
        Try try_ = $this.factory.test(poolable.item());
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit;
            if (poolable.timeElapsed() > $this.configuration.maxIdle()) {
                SingleThreadedAsyncObjectPool$.MODULE$.log().debug("Connection was idle for {}, maxIdle is {}, removing it", (Object)BoxesRunTime.boxToLong((long)poolable.timeElapsed()), (Object)BoxesRunTime.boxToLong((long)$this.configuration.maxIdle()));
                removals$1.$plus$eq((Object)poolable);
                $this.destroy(poolable.item());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            SingleThreadedAsyncObjectPool$.MODULE$.log().error("Failed to validate object", e);
            removals$1.$plus$eq((Object)poolable);
            $this.destroy(poolable.item());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(try_);
        }
    }

    public SingleThreadedAsyncObjectPool(ObjectFactory<T> factory, PoolConfiguration configuration) {
        this.factory = factory;
        this.configuration = configuration;
        AsyncObjectPool.$init$(this);
        this.com$github$mauricio$async$db$pool$SingleThreadedAsyncObjectPool$$mainPool = Worker$.MODULE$.apply();
        this.poolables = List$.MODULE$.empty();
        this.checkouts = new ArrayBuffer(configuration.maxObjects());
        this.waitQueue = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
        this.timer = new Timer(new StringBuilder(24).append("async-object-pool-timer-").append(SingleThreadedAsyncObjectPool$.MODULE$.Counter().incrementAndGet()).toString(), true);
        this.createSemaphore = new Semaphore(configuration.maxObjects());
        this.timer().scheduleAtFixedRate(new TimerTask(this){
            private final /* synthetic */ SingleThreadedAsyncObjectPool $outer;

            public void run() {
                this.$outer.com$github$mauricio$async$db$pool$SingleThreadedAsyncObjectPool$$mainPool().action((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.$outer.com$github$mauricio$async$db$pool$SingleThreadedAsyncObjectPool$$testObjects());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(com.github.mauricio.async.db.pool.SingleThreadedAsyncObjectPool$$anon$1 )}, serializedLambda);
            }
        }, configuration.validationInterval(), configuration.validationInterval());
        this.closed = false;
    }

    public class PoolableHolder<T> {
        private final T item;
        private final long time;
        public final /* synthetic */ SingleThreadedAsyncObjectPool $outer;

        public T item() {
            return this.item;
        }

        public long time() {
            return this.time;
        }

        public long timeElapsed() {
            return System.currentTimeMillis() - this.time();
        }

        public /* synthetic */ SingleThreadedAsyncObjectPool com$github$mauricio$async$db$pool$SingleThreadedAsyncObjectPool$PoolableHolder$$$outer() {
            return this.$outer;
        }

        public PoolableHolder(SingleThreadedAsyncObjectPool $outer, T item) {
            this.item = item;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.time = System.currentTimeMillis();
        }
    }
}

