/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.util;

import com.github.mauricio.async.db.Configuration;
import com.github.mauricio.async.db.SSLConfiguration;
import com.github.mauricio.async.db.SSLConfiguration$;
import com.github.mauricio.async.db.exceptions.UnableToParseURLException;
import com.github.mauricio.async.db.util.AbstractURIParser$;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\u0005ed!\u0002\u000f\u001e\u0003\u0003Q\u0003\"B\u0019\u0001\t\u0003\u0011\u0004bB\u001b\u0001\u0005\u0004%\tB\u000e\u0005\u0007\u007f\u0001\u0001\u000b\u0011B\u001c\t\u000b\u0001\u0003AQC!\t\u000fU\u0003!\u0019!D\t-\"9a\f\u0001b\u0001\u000e\u0003y\u0006\"\u00023\u0001\t\u0003)\u0007\u0002C@\u0001#\u0003%\t!!\u0001\t\u000f\u0005]\u0001\u0001\"\u0001\u0002\u001a!I\u0011q\u0004\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0001\u0005\b\u0003C\u0001A\u0011CA\u0012\u0011\u001d\t9\u0002\u0001C\t\u0003cAq!a\u0011\u0001\t#\t)\u0005C\u0004\u0002J\u0001!)\"a\u0013\b\u000f\u0005ES\u0004#\u0001\u0002T\u00191A$\bE\u0001\u0003+Ba!\r\t\u0005\u0002\u0005]\u0003\"CA-!\t\u0007I\u0011AA.\u0011!\t9\u0007\u0005Q\u0001\n\u0005u\u0003\"CA5!\t\u0007I\u0011AA.\u0011!\tY\u0007\u0005Q\u0001\n\u0005u\u0003\"CA7!\t\u0007I\u0011AA.\u0011!\ty\u0007\u0005Q\u0001\n\u0005u\u0003\"CA9!\t\u0007I\u0011AA.\u0011!\t\u0019\b\u0005Q\u0001\n\u0005u\u0003\"CA;!\t\u0007I\u0011AA.\u0011!\t9\b\u0005Q\u0001\n\u0005u#!E!cgR\u0014\u0018m\u0019;V%&\u0003\u0016M]:fe*\u0011adH\u0001\u0005kRLGN\u0003\u0002!C\u0005\u0011AM\u0019\u0006\u0003E\r\nQ!Y:z]\u000eT!\u0001J\u0013\u0002\u00115\fWO]5dS>T!AJ\u0014\u0002\r\u001dLG\u000f[;c\u0015\u0005A\u0013aA2p[\u000e\u00011C\u0001\u0001,!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\r\t\u0003i\u0001i\u0011!H\u0001\u0007Y><w-\u001a:\u0016\u0003]\u0002\"\u0001O\u001f\u000e\u0003eR!AO\u001e\u0002\u000bMdg\r\u000e6\u000b\u0003q\n1a\u001c:h\u0013\tq\u0014H\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u00035\u0001\u0018M]:f+N,'/\u00138g_R\u0011!i\u0015\t\u0005Y\r+U)\u0003\u0002E[\t1A+\u001e9mKJ\u00022\u0001\f$I\u0013\t9UF\u0001\u0004PaRLwN\u001c\t\u0003\u0013Bs!A\u0013(\u0011\u0005-kS\"\u0001'\u000b\u00055K\u0013A\u0002\u001fs_>$h(\u0003\u0002P[\u00051\u0001K]3eK\u001aL!!\u0015*\u0003\rM#(/\u001b8h\u0015\tyU\u0006C\u0003U\t\u0001\u0007Q)\u0001\u0005vg\u0016\u0014\u0018J\u001c4p\u0003\u0019\u00196\tS#N\u000bV\tq\u000b\u0005\u0002Y96\t\u0011L\u0003\u0002[7\u0006AQ.\u0019;dQ&twM\u0003\u0002\u001f[%\u0011Q,\u0017\u0002\u0006%\u0016<W\r_\u0001\b\t\u00163\u0015)\u0016'U+\u0005\u0001\u0007CA1c\u001b\u0005y\u0012BA2 \u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006Q\u0001/\u0019:tK>\u0013H)[3\u0015\u0007\u00014\u0007\u000eC\u0003h\u000f\u0001\u0007\u0001*A\u0002ve2Dq![\u0004\u0011\u0002\u0003\u0007!.A\u0004dQ\u0006\u00148/\u001a;\u0011\u0005-\fX\"\u00017\u000b\u0005%l'B\u00018p\u0003\rq\u0017n\u001c\u0006\u0002a\u0006!!.\u0019<b\u0013\t\u0011HNA\u0004DQ\u0006\u00148/\u001a;)\u0007\u001d!X\u0010E\u0002-k^L!A^\u0017\u0003\rQD'o\\<t!\tA80D\u0001z\u0015\tQx$\u0001\u0006fq\u000e,\u0007\u000f^5p]NL!\u0001`=\u00033Us\u0017M\u00197f)>\u0004\u0016M]:f+JcU\t_2faRLwN\\\u0011\u0002}\u0006y\u0015N\u001a\u0011uQ\u0016\u0004SK\u0015'!I>,7\u000f\t8pi\u0002j\u0017\r^2iAQDW\rI3ya\u0016\u001cG/\u001a3!if\u0004X\r\f\u0011pe\u0002\u001a\u0017M\u001c8pi\u0002\u0012W\r\t9beN,G\r\t4pe\u0002\ng.\u001f\u0011sK\u0006\u001cxN\\\u0001\u0015a\u0006\u00148/Z(s\t&,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\r!f\u00016\u0002\u0006-\u0012\u0011q\u0001\t\u0005\u0003\u0013\t\u0019\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003%)hn\u00195fG.,GMC\u0002\u0002\u00125\n!\"\u00198o_R\fG/[8o\u0013\u0011\t)\"a\u0003\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0003qCJ\u001cX\rF\u0003a\u00037\ti\u0002C\u0003h\u0013\u0001\u0007\u0001\nC\u0004j\u0013A\u0005\t\u0019\u00016\u0002\u001fA\f'o]3%I\u00164\u0017-\u001e7uII\nQ#Y:tK6\u0014G.Z\"p]\u001aLw-\u001e:bi&|g\u000eF\u0003a\u0003K\ty\u0003C\u0004\u0002(-\u0001\r!!\u000b\u0002\u0015A\u0014x\u000e]3si&,7\u000fE\u0003J\u0003WA\u0005*C\u0002\u0002.I\u00131!T1q\u0011\u0015I7\u00021\u0001k)\u0011\tI#a\r\t\u000f\u0005UB\u00021\u0001\u00028\u0005\u0019QO]5\u0011\t\u0005e\u0012qH\u0007\u0003\u0003wQ1!!\u0010p\u0003\rqW\r^\u0005\u0005\u0003\u0003\nYDA\u0002V%&\u000b!\u0002[1oI2,'\n\u0012\"D)\u0011\tI#a\u0012\t\u000f\u0005UR\u00021\u0001\u00028\u0005\tRO\\<sCBL\u0005O\u001e\u001cbI\u0012\u0014Xm]:\u0015\u0007!\u000bi\u0005\u0003\u0004\u0002P9\u0001\r\u0001S\u0001\u0007g\u0016\u0014h/\u001a:\u0002#\u0005\u00137\u000f\u001e:bGR,&+\u0013)beN,'\u000f\u0005\u00025!M\u0011\u0001c\u000b\u000b\u0003\u0003'\nA\u0001U(S)V\u0011\u0011Q\f\t\u0005\u0003?\n)'\u0004\u0002\u0002b)\u0019\u00111M8\u0002\t1\fgnZ\u0005\u0004#\u0006\u0005\u0014!\u0002)P%R\u0003\u0013A\u0002#C\u001d\u0006kU)A\u0004E\u0005:\u000bU*\u0012\u0011\u0002\t!{5\u000bV\u0001\u0006\u0011>\u001bF\u000bI\u0001\t+N+%KT!N\u000b\u0006IQkU#S\u001d\u0006kU\tI\u0001\t!\u0006\u001b6kV(S\t\u0006I\u0001+Q*T/>\u0013F\t\t")
public abstract class AbstractURIParser {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public static String PASSWORD() {
        return AbstractURIParser$.MODULE$.PASSWORD();
    }

    public static String USERNAME() {
        return AbstractURIParser$.MODULE$.USERNAME();
    }

    public static String HOST() {
        return AbstractURIParser$.MODULE$.HOST();
    }

    public static String DBNAME() {
        return AbstractURIParser$.MODULE$.DBNAME();
    }

    public static String PORT() {
        return AbstractURIParser$.MODULE$.PORT();
    }

    public Logger logger() {
        return this.logger;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Tuple2<Option<String>, Option<String>> parseUserInfo(Option<String> userInfo) {
        boolean bl = false;
        Some some = null;
        Option option = userInfo.map((Function1 & Serializable)x$1 -> Predef$.MODULE$.wrapRefArray((Object[])x$1.split(":", 2)).toList());
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            List list = (List)some.value();
            if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                String user = (String)colon2.head();
                List list2 = colon2.next$access$1();
                if (list2 instanceof .colon.colon) {
                    .colon.colon colon3 = (.colon.colon)list2;
                    String pass = (String)colon3.head();
                    List list3 = colon3.next$access$1();
                    if (Nil$.MODULE$.equals(list3)) {
                        return new Tuple2((Object)new Some((Object)user), (Object)new Some((Object)pass));
                    }
                }
            }
        }
        if (!bl) return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        List list = (List)some.value();
        if (!(list instanceof .colon.colon)) return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        .colon.colon colon4 = (.colon.colon)list;
        String user = (String)colon4.head();
        List list4 = colon4.next$access$1();
        if (!Nil$.MODULE$.equals(list4)) return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        return new Tuple2((Object)new Some((Object)user), (Object)None$.MODULE$);
    }

    public abstract Regex SCHEME();

    public abstract Configuration DEFAULT();

    public Configuration parseOrDie(String url, Charset charset) throws UnableToParseURLException {
        Configuration configuration;
        try {
            Map<String, String> properties = this.parse(new URI(url).parseServerAuthority());
            configuration = this.assembleConfiguration(properties, charset);
        }
        catch (URISyntaxException e) {
            throw new UnableToParseURLException(new StringBuilder(21).append("Failed to parse URL: ").append(url).toString(), e);
        }
        return configuration;
    }

    public Configuration parse(String url, Charset charset) {
        Configuration configuration;
        try {
            configuration = this.parseOrDie(url, charset);
        }
        catch (Exception e) {
            this.logger().warn(new StringBuilder(38).append("Connection url '").append(url).append("' could not be parsed.").toString(), (Throwable)e);
            configuration = this.DEFAULT();
        }
        return configuration;
    }

    public Configuration assembleConfiguration(Map<String, String> properties, Charset charset) {
        String x$1 = (String)properties.getOrElse((Object)AbstractURIParser$.MODULE$.USERNAME(), (Function0 & Serializable)() -> this.DEFAULT().username());
        Option x$22 = properties.get((Object)AbstractURIParser$.MODULE$.PASSWORD());
        Option x$3 = properties.get((Object)AbstractURIParser$.MODULE$.DBNAME());
        String x$4 = (String)properties.getOrElse((Object)AbstractURIParser$.MODULE$.HOST(), (Function0 & Serializable)() -> this.DEFAULT().host());
        int x$5 = BoxesRunTime.unboxToInt((Object)properties.get((Object)AbstractURIParser$.MODULE$.PORT()).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$2)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> this.DEFAULT().port()));
        SSLConfiguration x$6 = SSLConfiguration$.MODULE$.apply(properties);
        Charset x$7 = charset;
        int x$8 = this.DEFAULT().copy$default$8();
        ByteBufAllocator x$9 = this.DEFAULT().copy$default$9();
        Duration x$10 = this.DEFAULT().copy$default$10();
        Duration x$11 = this.DEFAULT().copy$default$11();
        int x$12 = this.DEFAULT().copy$default$12();
        Duration x$13 = this.DEFAULT().copy$default$13();
        EventLoopGroup x$14 = this.DEFAULT().copy$default$14();
        Class<? extends SocketChannel> x$15 = this.DEFAULT().copy$default$15();
        Option<Duration> x$16 = this.DEFAULT().copy$default$16();
        return this.DEFAULT().copy(x$1, x$4, x$5, (Option<String>)x$22, (Option<String>)x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
    }

    public Map<String, String> parse(URI uri) {
        Map map;
        Option option;
        String string = uri.getScheme();
        if (string != null && !(option = this.SCHEME().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(0) == 0) {
            Tuple2<Option<String>, Option<String>> userInfo = this.parseUserInfo((Option<String>)Option$.MODULE$.apply((Object)uri.getUserInfo()));
            Option port = new Some((Object)BoxesRunTime.boxToInteger((int)uri.getPort())).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$3 -> x$3 > 0);
            Option db = Option$.MODULE$.apply((Object)uri.getPath()).map((Function1 & Serializable)x$4 -> StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(x$4), "/")).filterNot((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isEmpty()));
            Option host = Option$.MODULE$.apply((Object)uri.getHost());
            Builder builder = Predef$.MODULE$.Map().newBuilder();
            builder.$plus$plus$eq((IterableOnce)((Option)userInfo._1()).map((Function1 & Serializable)x$6 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AbstractURIParser$.MODULE$.USERNAME()), x$6)));
            builder.$plus$plus$eq((IterableOnce)((Option)userInfo._2()).map((Function1 & Serializable)x$7 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AbstractURIParser$.MODULE$.PASSWORD()), x$7)));
            builder.$plus$plus$eq((IterableOnce)port.map((Function1 & Serializable)x$8 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AbstractURIParser$.MODULE$.PORT()), (Object)((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$8))).toString())));
            builder.$plus$plus$eq((IterableOnce)db.map((Function1 & Serializable)x$9 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AbstractURIParser$.MODULE$.DBNAME()), x$9)));
            builder.$plus$plus$eq((IterableOnce)host.map((Function1 & Serializable)x$10 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AbstractURIParser$.MODULE$.HOST()), (Object)this.unwrapIpv6address((String)x$10))));
            builder.$plus$plus$eq((IterableOnce)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)uri.getQuery())).toSeq().flatMap((Function1 & Serializable)qs -> Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(qs), '&')), (Function1 & Serializable)parameter -> {
                Object object;
                String[] stringArray = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(parameter), '=');
                if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
                    throw new MatchError((Object)stringArray);
                }
                String name = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                String value = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                Tuple3 tuple3 = new Tuple3((Object)stringArray, (Object)name, (Object)value);
                Tuple3 tuple32 = tuple3;
                String[] x$11 = (String[])tuple32._1();
                String name2 = (String)tuple32._2();
                String value2 = (String)tuple32._3();
                return new Tuple2(parameter, (Object)x$11);
            }, ClassTag$.MODULE$.apply(Tuple2.class))), (Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)AbstractURIParser.$anonfun$parse$11(x$13))).map((Function1 & Serializable)x$14 -> {
                Object object;
                String[] stringArray;
                Tuple2 tuple2 = x$14;
                if (tuple2 == null || (stringArray = (String[])tuple2._2()) == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
                    throw new MatchError((Object)tuple2);
                }
                String name = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                String value = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)URLDecoder.decode(name, "UTF-8")), (Object)URLDecoder.decode(value, "UTF-8"));
                return tuple22;
            }, ClassTag$.MODULE$.apply(Tuple2.class)))));
            map = (Map)builder.result();
        } else if ("jdbc".equals(string)) {
            map = this.handleJDBC(uri);
        } else {
            throw new UnableToParseURLException("Unrecognized URI scheme");
        }
        return map;
    }

    public Charset parseOrDie$default$2() {
        return this.DEFAULT().charset();
    }

    public Charset parse$default$2() {
        return this.DEFAULT().charset();
    }

    public Map<String, String> handleJDBC(URI uri) {
        return this.parse(new URI(uri.getSchemeSpecificPart()));
    }

    public final String unwrapIpv6address(String server) {
        return server.startsWith("[") ? server.substring(1, server.length() - 1) : server;
    }

    public static final /* synthetic */ boolean $anonfun$parse$11(Tuple2 x$13) {
        Object object;
        String[] stringArray;
        Tuple2 tuple2 = x$13;
        if (tuple2 == null || (stringArray = (String[])tuple2._2()) == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
        String value = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
        boolean bl = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(name)) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(value));
        return bl;
    }
}

