/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.util;

import com.github.mauricio.async.db.util.Execution$Implicits$;
import com.github.mauricio.async.db.util.Stat;
import com.github.mauricio.async.db.util.Stat$;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.util.Try;

public final class Metrics$ {
    public static final Metrics$ MODULE$ = new Metrics$();
    private static final Logger com$github$mauricio$async$db$util$Metrics$$metricsLogger = LoggerFactory.getLogger((String)"async.metrics");
    private static final Logger com$github$mauricio$async$db$util$Metrics$$slowLogger = LoggerFactory.getLogger((String)"async.slow");
    private static final LoadingCache<String, Stat> stats = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, Stat>(){

        public Stat load(String key) {
            return new Stat(Stat$.MODULE$.apply$default$1(), Stat$.MODULE$.apply$default$2(), Stat$.MODULE$.apply$default$3(), Stat$.MODULE$.apply$default$4());
        }
    });

    public Logger com$github$mauricio$async$db$util$Metrics$$metricsLogger() {
        return com$github$mauricio$async$db$util$Metrics$$metricsLogger;
    }

    public Logger com$github$mauricio$async$db$util$Metrics$$slowLogger() {
        return com$github$mauricio$async$db$util$Metrics$$slowLogger;
    }

    public LoadingCache<String, Stat> stats() {
        return stats;
    }

    public <T> Future<T> stat(String key, Function0<Future<T>> f) {
        long start = System.currentTimeMillis();
        Future fut = (Future)f.apply();
        fut.onComplete((Function1 & Serializable)x0$1 -> {
            Metrics$.$anonfun$stat$1(start, key, x0$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)Execution$Implicits$.MODULE$.trampoline());
        return fut;
    }

    private void logSlow(String sql, long time) {
        block0: {
            if (time <= 50L) break block0;
            this.com$github$mauricio$async$db$util$Metrics$$slowLogger().info(new StringBuilder(16).append("SQL:[").append(sql).append("],TIME:[").append(time).append("]ms").toString());
        }
    }

    private void logMetrics(String key) {
        block0: {
            Stat stat = (Stat)this.stats().get((Object)key);
            long t = stat.total().get();
            long c = stat.times().get();
            long min = stat.min().get();
            long max = stat.max().get();
            if (c % 1000L != 0L) break block0;
            this.com$github$mauricio$async$db$util$Metrics$$metricsLogger().info(new StringBuilder(34).append("[SQL-").append(key).append("], count:").append(c).append(", avg:").append(t / package$.MODULE$.max(1L, c)).append("ms, max:").append(max).append(", min:").append(min).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$stat$1(long start$1, String key$1, Try x0$1) {
        Try try_ = x0$1;
        long end = System.currentTimeMillis();
        long time = end - start$1;
        ((Stat)MODULE$.stats().get((Object)key$1)).add(time);
        MODULE$.logSlow(key$1, time);
        MODULE$.logMetrics(key$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private Metrics$() {
    }
}

