/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql;

import com.github.mauricio.async.db.Configuration;
import com.github.mauricio.async.db.Connection;
import com.github.mauricio.async.db.QueryResult;
import com.github.mauricio.async.db.column.ColumnDecoderRegistry;
import com.github.mauricio.async.db.column.ColumnEncoderRegistry;
import com.github.mauricio.async.db.exceptions.ConnectionStillRunningQueryException;
import com.github.mauricio.async.db.exceptions.InsufficientParametersException;
import com.github.mauricio.async.db.general.ColumnData;
import com.github.mauricio.async.db.general.MutableResultSet;
import com.github.mauricio.async.db.pool.TimeoutScheduler;
import com.github.mauricio.async.db.postgresql.PostgreSQLConnection$;
import com.github.mauricio.async.db.postgresql.PreparedStatementHolder;
import com.github.mauricio.async.db.postgresql.codec.PostgreSQLConnectionDelegate;
import com.github.mauricio.async.db.postgresql.codec.PostgreSQLConnectionHandler;
import com.github.mauricio.async.db.postgresql.exceptions.GenericDatabaseException;
import com.github.mauricio.async.db.postgresql.exceptions.MissingCredentialInformationException;
import com.github.mauricio.async.db.postgresql.exceptions.QueryMustNotBeNullOrEmptyException;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeCleartextMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeMD5;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationOkMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.CommandCompleteMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.DataRowMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.ErrorMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.NotificationResponse;
import com.github.mauricio.async.db.postgresql.messages.backend.ParameterStatusMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.PostgreSQLColumnData;
import com.github.mauricio.async.db.postgresql.messages.backend.RowDescriptionMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.ClientMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.CredentialMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.PreparedStatementExecuteMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.PreparedStatementMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.PreparedStatementOpeningMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.QueryMessage;
import com.github.mauricio.async.db.util.Metrics$;
import com.github.mauricio.async.db.util.Version;
import com.github.mauricio.async.db.util.Version$;
import io.netty.buffer.ByteBuf;
import io.netty.channel.EventLoopGroup;
import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0011%s!B0a\u0011\u0003ig!B8a\u0011\u0003\u0001\b\"B<\u0002\t\u0003A\bbB=\u0002\u0005\u0004%)A\u001f\u0005\b\u0003\u001f\t\u0001\u0015!\u0004|\u0011%\t\t\"\u0001b\u0001\n\u000b\t\u0019\u0002\u0003\u0005\u0002\u001c\u0005\u0001\u000bQBA\u000b\u0011%\ti\"\u0001b\u0001\n\u000b\ty\u0002\u0003\u0005\u00022\u0005\u0001\u000bQBA\u0011\u0011%\t\u0019$AI\u0001\n\u0003\t)\u0004C\u0005\u0002T\u0005\t\n\u0011\"\u0001\u0002V!I\u0011QM\u0001\u0012\u0002\u0013\u0005\u0011q\r\u0005\n\u0003c\n\u0011\u0013!C\u0001\u0003gB\u0011\"! \u0002#\u0003%\t!a \u0007\u000b=\u0004\u0007!!$\t\u0015\u00055fB!A!\u0002\u0013\tI\u0004\u0003\u0006\u00020:\u0011\t\u0011)A\u0005\u00033B!\"!-\u000f\u0005\u0003\u0005\u000b\u0011BA6\u0011)\t\u0019L\u0004B\u0001B\u0003%\u0011q\u000f\u0005\u000b\u0003ks!Q1A\u0005\u0004\u0005]\u0006BCA]\u001d\t\u0005\t\u0015!\u0003\u0002\u0004\"1qO\u0004C\u0001\u0003wC\u0011\"!3\u000f\u0005\u0004%I!a3\t\u0011\u0005\u0005h\u0002)A\u0005\u0003\u001bD\u0011\"a9\u000f\u0005\u0004%i!!:\t\u0011\u00055h\u0002)A\u0007\u0003OD\u0011\"a<\u000f\u0005\u0004%i!!=\t\u0011\u0005eh\u0002)A\u0007\u0003gD\u0011\"a?\u000f\u0005\u0004%i!!@\t\u0011\t\u0015a\u0002)A\u0007\u0003\u007fD\u0011Ba\u0002\u000f\u0005\u0004%IA!\u0003\t\u0011\tEb\u0002)A\u0005\u0005\u0017A\u0011Ba\r\u000f\u0005\u0004%IA!\u000e\t\u0011\t}b\u0002)A\u0005\u0005oA\u0011B!\u0011\u000f\u0001\u0004%IAa\u0011\t\u0013\t\u0015c\u00021A\u0005\n\t\u001d\u0003\u0002\u0003B*\u001d\u0001\u0006K!a\u001e\t\u0013\tUcB1A\u0005\n\t]\u0003\u0002\u0003B0\u001d\u0001\u0006IA!\u0017\t\u0013\t\u0005d\u00021A\u0005\n\t\r\u0003\"\u0003B2\u001d\u0001\u0007I\u0011\u0002B3\u0011!\u0011IG\u0004Q!\n\u0005]\u0004\"\u0003B6\u001d\t\u0007I\u0011\u0002B7\u0011!\u0011\u0019I\u0004Q\u0001\n\t=\u0004\"\u0003BC\u001d\u0001\u0007I\u0011\u0002BD\u0011%\u00119K\u0004a\u0001\n\u0013\u0011I\u000b\u0003\u0005\u0003.:\u0001\u000b\u0015\u0002BE\u0011%\u0011yK\u0004a\u0001\n\u0013\u0011\t\fC\u0005\u00036:\u0001\r\u0011\"\u0003\u00038\"A!1\u0018\b!B\u0013\u0011\u0019\fC\u0005\u0003>:\u0001\r\u0011\"\u0003\u0003@\"I!1\u001a\bA\u0002\u0013%!Q\u001a\u0005\t\u0005#t\u0001\u0015)\u0003\u0003B\"I!1\u001b\bA\u0002\u0013%!Q\u001b\u0005\n\u0005Wt\u0001\u0019!C\u0005\u0005[D\u0001B!=\u000fA\u0003&!q\u001b\u0005\n\u0005gt\u0001\u0019!C\u0005\u0005kD\u0011B!?\u000f\u0001\u0004%IAa?\t\u0011\t}h\u0002)Q\u0005\u0005oDqa!\u0001\u000f\t\u0003\nY\rC\u0004\u0004\u00049!\tAa\u0011\t\u000f\r\u0015a\u0002\"\u0001\u0004\b!91q\u0002\b\u0005B\r\u001d\u0001bBB\t\u001d\u0011\u000531\u0003\u0005\b\u0007+qA\u0011\tB\"\u0011\u001d\u00199B\u0004C\u0001\u00073Aqaa\n\u000f\t\u0003\u001aI\u0003C\u0004\u000429!\tea\r\t\u0013\rMc\"%A\u0005\u0002\rU\u0003bBB-\u001d\u0011\u000531\f\u0005\b\u0007OrA\u0011\u0001B\"\u0011\u001d\u0019IG\u0004C\u0005\u0007WBqa!\u001d\u000f\t\u0003\u001a\u0019\bC\u0004\u0004Z9!\te!\u001e\t\u000f\r\u0005e\u0002\"\u0011\u0004\u0004\"91Q\u0012\b\u0005B\r=\u0005bBBM\u001d\u0011\u000531\u0014\u0005\b\u0007KsA\u0011IBT\u0011\u001d\u0019\tL\u0004C\u0005\u0007gCqaa0\u000f\t\u0003\u001a\t\rC\u0004\u0004N:!\tea4\t\u000f\rMg\u0002\"\u0001\u0004V\"911\u001c\b\u0005\u0002\ru\u0007bBBq\u001d\u0011\u000511\u000f\u0005\b\u0007GtA\u0011BBs\u0011!\u0019iP\u0004Q\u0005\n\r}\bb\u0002C\b\u001d\u0011\u0005A\u0011\u0003\u0005\b\t+qA\u0011\u0002C\f\u0011\u001d!YB\u0004C\u0005\t;Aq\u0001b\b\u000f\t\u0013!\t\u0003C\u0004\u0005(9!I\u0001\"\b\t\u000f\u0011%b\u0002\"\u0003\u0005,!9A\u0011\u0007\b\u0005\n\u0011M\u0002b\u0002C\u001d\u001d\u0011%A1\b\u0005\b\t\u000brA\u0011\tC$\u0003Q\u0001vn\u001d;he\u0016\u001c\u0016\u000bT\"p]:,7\r^5p]*\u0011\u0011MY\u0001\u000ba>\u001cHo\u001a:fgFd'BA2e\u0003\t!'M\u0003\u0002fM\u0006)\u0011m]=oG*\u0011q\r[\u0001\t[\u0006,(/[2j_*\u0011\u0011N[\u0001\u0007O&$\b.\u001e2\u000b\u0003-\f1aY8n\u0007\u0001\u0001\"A\\\u0001\u000e\u0003\u0001\u0014A\u0003U8ti\u001e\u0014XmU)M\u0007>tg.Z2uS>t7CA\u0001r!\t\u0011X/D\u0001t\u0015\u0005!\u0018!B:dC2\f\u0017B\u0001<t\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\\\u0001\b\u0007>,h\u000e^3s+\u0005Y\bc\u0001?\u0002\f5\tQP\u0003\u0002\u007f\u007f\u00061\u0011\r^8nS\u000eTA!!\u0001\u0002\u0004\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005\u0015\u0011qA\u0001\u0005kRLGN\u0003\u0002\u0002\n\u0005!!.\u0019<b\u0013\r\ti! \u0002\u000b\u0003R|W.[2M_:<\u0017\u0001C\"pk:$XM\u001d\u0011\u0002!M+'O^3s-\u0016\u00148/[8o\u0017\u0016LXCAA\u000b\u001f\t\t9\"\t\u0002\u0002\u001a\u0005q1/\u001a:wKJ|f/\u001a:tS>t\u0017!E*feZ,'OV3sg&|gnS3zA\u0005\u0019An\\4\u0016\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003[i!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\u0006g24GG\u001b\u0006\u0003\u0003W\t1a\u001c:h\u0013\u0011\ty#!\n\u0003\r1{wmZ3s\u0003\u0011awn\u001a\u0011\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\t9D\u000b\u0003\u0002:\u0005\u0005\u0003\u0003BA\u001e\u0003{i\u0011AY\u0005\u0004\u0003\u007f\u0011'!D\"p]\u001aLw-\u001e:bi&|gn\u000b\u0002\u0002DA!\u0011QIA(\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013!C;oG\",7m[3e\u0015\r\tie]\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA)\u0003\u000f\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u000b\u0016\u0005\u00033\n\t\u0005\u0005\u0003\u0002\\\u0005\u0005TBAA/\u0015\r\tyFY\u0001\u0007G>dW/\u001c8\n\t\u0005\r\u0014Q\f\u0002\u0016\u0007>dW/\u001c8F]\u000e|G-\u001a:SK\u001eL7\u000f\u001e:z\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\u000e\u0016\u0005\u0003W\n\t\u0005\u0005\u0003\u0002\\\u00055\u0014\u0002BA8\u0003;\u0012QcQ8mk6tG)Z2pI\u0016\u0014(+Z4jgR\u0014\u00180A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003kRC!a\u001e\u0002BA\u0019!/!\u001f\n\u0007\u0005m4OA\u0004C_>dW-\u00198\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\t\tI\u000b\u0003\u0002\u0004\u0006\u0005\u0003\u0003BAC\u0003\u0013k!!a\"\u000b\u0007\u0005\u00051/\u0003\u0003\u0002\f\u0006\u001d%\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u'!q\u0011/a$\u0002\u001c\u0006\u0005\u0006\u0003BAI\u0003/k!!a%\u000b\u0007\u0005U\u0005-A\u0003d_\u0012,7-\u0003\u0003\u0002\u001a\u0006M%\u0001\b)pgR<'/Z*R\u0019\u000e{gN\\3di&|g\u000eR3mK\u001e\fG/\u001a\t\u0005\u0003w\ti*C\u0002\u0002 \n\u0014!bQ8o]\u0016\u001cG/[8o!\u0011\t\u0019+!+\u000e\u0005\u0005\u0015&bAATE\u0006!\u0001o\\8m\u0013\u0011\tY+!*\u0003!QKW.Z8viN\u001b\u0007.\u001a3vY\u0016\u0014\u0018!D2p]\u001aLw-\u001e:bi&|g.A\bf]\u000e|G-\u001a:SK\u001eL7\u000f\u001e:z\u0003=!WmY8eKJ\u0014VmZ5tiJL\u0018!\u00069pg&$\u0018n\u001c8bYB\u000b'/Y7I_2$WM]\u0001\u0011Kb,7-\u001e;j_:\u001cuN\u001c;fqR,\"!a!\u0002#\u0015DXmY;uS>t7i\u001c8uKb$\b\u0005\u0006\u0007\u0002>\u0006}\u0016\u0011YAb\u0003\u000b\f9\r\u0005\u0002o\u001d!I\u0011QV\u000b\u0011\u0002\u0003\u0007\u0011\u0011\b\u0005\n\u0003_+\u0002\u0013!a\u0001\u00033B\u0011\"!-\u0016!\u0003\u0005\r!a\u001b\t\u0013\u0005MV\u0003%AA\u0002\u0005]\u0004\"CA[+A\u0005\t9AAB\u0003\u00159'o\\;q+\t\ti\r\u0005\u0003\u0002P\u0006uWBAAi\u0015\u0011\t\u0019.!6\u0002\u000f\rD\u0017M\u001c8fY*!\u0011q[Am\u0003\u0015qW\r\u001e;z\u0015\t\tY.\u0001\u0002j_&!\u0011q\\Ai\u00059)e/\u001a8u\u0019>|\u0007o\u0012:pkB\faa\u001a:pkB\u0004\u0013!E2p]:,7\r^5p]\"\u000bg\u000e\u001a7feV\u0011\u0011q\u001d\t\u0005\u0003#\u000bI/\u0003\u0003\u0002l\u0006M%a\u0007)pgR<'/Z*R\u0019\u000e{gN\\3di&|g\u000eS1oI2,'/\u0001\nd_:tWm\u0019;j_:D\u0015M\u001c3mKJ\u0004\u0013\u0001D2veJ,g\u000e^\"pk:$XCAAz!\r\u0011\u0018Q_\u0005\u0004\u0003o\u001c(\u0001\u0002'p]\u001e\fQbY;se\u0016tGoQ8v]R\u0004\u0013!\u00079sKB\f'/\u001a3Ti\u0006$X-\\3oiN\u001cu.\u001e8uKJ,\"!a@\u0011\u0007q\u0014\t!C\u0002\u0003\u0004u\u0014Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\u0018A\u00079sKB\f'/\u001a3Ti\u0006$X-\\3oiN\u001cu.\u001e8uKJ\u0004\u0013a\u00049be\u0006lW\r^3s'R\fG/^:\u0016\u0005\t-\u0001\u0003\u0003B\u0007\u0005/\u0011YBa\u0007\u000e\u0005\t=!\u0002\u0002B\t\u0005'\tq!\\;uC\ndWMC\u0002\u0003\u0016M\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011IBa\u0004\u0003\u000f!\u000b7\u000f['baB!!Q\u0004B\u0016\u001d\u0011\u0011yBa\n\u0011\u0007\t\u00052/\u0004\u0002\u0003$)\u0019!Q\u00057\u0002\rq\u0012xn\u001c;?\u0013\r\u0011Ic]\u0001\u0007!J,G-\u001a4\n\t\t5\"q\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\t%2/\u0001\tqCJ\fW.\u001a;feN#\u0018\r^;tA\u0005\u0001\u0002/\u0019:tK\u0012\u001cF/\u0019;f[\u0016tGo]\u000b\u0003\u0005o\u0001\u0002B!\u0004\u0003\u0018\tm!\u0011\b\t\u0004]\nm\u0012b\u0001B\u001fA\n9\u0002K]3qCJ,Gm\u0015;bi\u0016lWM\u001c;I_2$WM]\u0001\u0012a\u0006\u00148/\u001a3Ti\u0006$X-\\3oiN\u0004\u0013!D1vi\",g\u000e^5dCR,G-\u0006\u0002\u0002x\u0005\t\u0012-\u001e;iK:$\u0018nY1uK\u0012|F%Z9\u0015\t\t%#q\n\t\u0004e\n-\u0013b\u0001B'g\n!QK\\5u\u0011%\u0011\tfIA\u0001\u0002\u0004\t9(A\u0002yIE\na\"Y;uQ\u0016tG/[2bi\u0016$\u0007%\u0001\td_:tWm\u0019;j_:4U\u000f^;sKV\u0011!\u0011\f\t\u0007\u0003\u000b\u0013Y&a'\n\t\tu\u0013q\u0011\u0002\b!J|W.[:f\u0003E\u0019wN\u001c8fGRLwN\u001c$viV\u0014X\rI\u0001\fe\u0016\u001cWM\u001c;FeJ|'/A\bsK\u000e,g\u000e^#se>\u0014x\fJ3r)\u0011\u0011IEa\u001a\t\u0013\tE\u0003&!AA\u0002\u0005]\u0014\u0001\u0004:fG\u0016tG/\u0012:s_J\u0004\u0013!F9vKJL\bK]8nSN,'+\u001a4fe\u0016t7-Z\u000b\u0003\u0005_\u0002R\u0001 B9\u0005kJ1Aa\u001d~\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007#\u0002:\u0003x\tm\u0014b\u0001B=g\n1q\n\u001d;j_:\u0004b!!\"\u0003\\\tu\u0004\u0003BA\u001e\u0005\u007fJ1A!!c\u0005-\tV/\u001a:z%\u0016\u001cX\u000f\u001c;\u0002-E,XM]=Qe>l\u0017n]3SK\u001a,'/\u001a8dK\u0002\nAbY;se\u0016tG/U;fef,\"A!#\u0011\u000bI\u00149Ha#\u0011\r\t5%1\u0013BL\u001b\t\u0011yIC\u0002\u0003\u0012\n\fqaZ3oKJ\fG.\u0003\u0003\u0003\u0016\n=%\u0001E'vi\u0006\u0014G.\u001a*fgVdGoU3u!\u0011\u0011IJa)\u000e\u0005\tm%\u0002\u0002BO\u0005?\u000bqAY1dW\u0016tGMC\u0002\u0003\"\u0002\f\u0001\"\\3tg\u0006<Wm]\u0005\u0005\u0005K\u0013YJ\u0001\u000bQ_N$xM]3T#2\u001bu\u000e\\;n]\u0012\u000bG/Y\u0001\u0011GV\u0014(/\u001a8u#V,'/_0%KF$BA!\u0013\u0003,\"I!\u0011K\u0017\u0002\u0002\u0003\u0007!\u0011R\u0001\u000eGV\u0014(/\u001a8u#V,'/\u001f\u0011\u00021\r,(O]3oiB\u0013X\r]1sK\u0012\u001cF/\u0019;f[\u0016tG/\u0006\u0002\u00034B)!Oa\u001e\u0003:\u0005a2-\u001e:sK:$\bK]3qCJ,Gm\u0015;bi\u0016lWM\u001c;`I\u0015\fH\u0003\u0002B%\u0005sC\u0011B!\u00151\u0003\u0003\u0005\rAa-\u00023\r,(O]3oiB\u0013X\r]1sK\u0012\u001cF/\u0019;f[\u0016tG\u000fI\u0001\bm\u0016\u00148/[8o+\t\u0011\t\r\u0005\u0003\u0003D\n\u001dWB\u0001Bc\u0015\r\t)AY\u0005\u0005\u0005\u0013\u0014)MA\u0004WKJ\u001c\u0018n\u001c8\u0002\u0017Y,'o]5p]~#S-\u001d\u000b\u0005\u0005\u0013\u0012y\rC\u0005\u0003RM\n\t\u00111\u0001\u0003B\u0006Aa/\u001a:tS>t\u0007%A\bo_RLg-\u001f'jgR,g.\u001a:t+\t\u00119\u000e\u0005\u0004\u0003Z\nm'q\\\u0007\u0002\u007f&\u0019!Q\\@\u0003)\r{\u0007/_(o/JLG/Z!se\u0006LH*[:u!\u001d\u0011(\u0011\u001dBs\u0005\u0013J1Aa9t\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0003\u001a\n\u001d\u0018\u0002\u0002Bu\u00057\u0013ACT8uS\u001aL7-\u0019;j_:\u0014Vm\u001d9p]N,\u0017a\u00058pi&4\u0017\u0010T5ti\u0016tWM]:`I\u0015\fH\u0003\u0002B%\u0005_D\u0011B!\u00157\u0003\u0003\u0005\rAa6\u0002!9|G/\u001b4z\u0019&\u001cH/\u001a8feN\u0004\u0013aC9vKJL(+Z:vYR,\"Aa>\u0011\u000bI\u00149H! \u0002\u001fE,XM]=SKN,H\u000e^0%KF$BA!\u0013\u0003~\"I!\u0011K\u001d\u0002\u0002\u0003\u0007!q_\u0001\rcV,'/\u001f*fgVdG\u000fI\u0001\u000fKZ,g\u000e\u001e'p_B<%o\\;q\u0003=I7OU3bIf4uN])vKJL\u0018aB2p]:,7\r^\u000b\u0003\u0007\u0013\u0001b!!\"\u0004\f\u0005m\u0015\u0002BB\u0007\u0003\u000f\u0013aAR;ukJ,\u0017A\u00033jg\u000e|gN\\3di\u0006IqN\u001c+j[\u0016|W\u000f^\u000b\u0003\u0005\u0013\n1\"[:D_:tWm\u0019;fI\u0006\t\u0002/\u0019:b[\u0016$XM]*uCR,8/Z:\u0016\u0005\rm\u0001\u0003CB\u000f\u0007G\u0011YBa\u0007\u000e\u0005\r}!\u0002BB\u0011\u0005'\t\u0011\"[7nkR\f'\r\\3\n\t\r\u00152q\u0004\u0002\u0004\u001b\u0006\u0004\u0018!C:f]\u0012\fV/\u001a:z)\u0011\u0019Yc!\f\u0011\r\u0005\u001551\u0002B?\u0011\u001d\u0019yC\u0011a\u0001\u00057\tQ!];fef\fQc]3oIB\u0013X\r]1sK\u0012\u001cF/\u0019;f[\u0016tG\u000f\u0006\u0004\u0004,\rU2q\u0007\u0005\b\u0007_\u0019\u0005\u0019\u0001B\u000e\u0011%\u0019Id\u0011I\u0001\u0002\u0004\u0019Y$\u0001\u0004wC2,Xm\u001d\t\u0007\u0007{\u00199e!\u0014\u000f\t\r}21\t\b\u0005\u0005C\u0019\t%C\u0001u\u0013\r\u0019)e]\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0019Iea\u0013\u0003\u0007M+\u0017OC\u0002\u0004FM\u00042A]B(\u0013\r\u0019\tf\u001d\u0002\u0004\u0003:L\u0018aH:f]\u0012\u0004&/\u001a9be\u0016$7\u000b^1uK6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u00111q\u000b\u0016\u0005\u0007w\t\t%A\u0004p]\u0016\u0013(o\u001c:\u0015\t\t%3Q\f\u0005\b\u0007?*\u0005\u0019AB1\u0003%)\u0007pY3qi&|g\u000e\u0005\u0003\u0004>\r\r\u0014\u0002BB3\u0007\u0017\u0012\u0011\u0002\u00165s_^\f'\r\\3\u0002\u001d!\f7OU3dK:$XI\u001d:pe\u0006\t2/\u001a;FeJ|'o\u00148GkR,(/Z:\u0015\t\t%3Q\u000e\u0005\b\u0007_:\u0005\u0019AB1\u0003\u0005)\u0017aD8o%\u0016\fG-\u001f$peF+XM]=\u0015\u0005\t%C\u0003\u0002B%\u0007oBqa!\u001fJ\u0001\u0004\u0019Y(A\u0001n!\u0011\u0011Ij! \n\t\r}$1\u0014\u0002\r\u000bJ\u0014xN]'fgN\fw-Z\u0001\u0012_:\u001cu.\\7b]\u0012\u001cu.\u001c9mKR,G\u0003\u0002B%\u0007\u000bCqa!\u001fK\u0001\u0004\u00199\t\u0005\u0003\u0003\u001a\u000e%\u0015\u0002BBF\u00057\u0013acQ8n[\u0006tGmQ8na2,G/Z'fgN\fw-Z\u0001\u0012_:\u0004\u0016M]1nKR,'o\u0015;biV\u001cH\u0003\u0002B%\u0007#Cqa!\u001fL\u0001\u0004\u0019\u0019\n\u0005\u0003\u0003\u001a\u000eU\u0015\u0002BBL\u00057\u0013a\u0003U1sC6,G/\u001a:Ti\u0006$Xo]'fgN\fw-Z\u0001\n_:$\u0015\r^1S_^$BA!\u0013\u0004\u001e\"91\u0011\u0010'A\u0002\r}\u0005\u0003\u0002BM\u0007CKAaa)\u0003\u001c\nqA)\u0019;b%><X*Z:tC\u001e,\u0017\u0001E8o%><H)Z:de&\u0004H/[8o)\u0011\u0011Ie!+\t\u000f\reT\n1\u0001\u0004,B!!\u0011TBW\u0013\u0011\u0019yKa'\u0003+I{w\u000fR3tGJL\u0007\u000f^5p]6+7o]1hK\u0006q1/\u001a;D_2,XN\u001c#bi\u0006\u001cH\u0003\u0002B%\u0007kCqaa.O\u0001\u0004\u0019I,A\u0006d_2,XN\u001c#bi\u0006\u001c\bC\u0002B\u0007\u0007w\u00139*\u0003\u0003\u0004>\n=!aC!se\u0006L()\u001e4gKJ\f\u0001d\u001c8BkRDWM\u001c;jG\u0006$\u0018n\u001c8SKN\u0004xN\\:f)\u0011\u0011Iea1\t\u000f\r\u0015w\n1\u0001\u0004H\u00069Q.Z:tC\u001e,\u0007\u0003\u0002BM\u0007\u0013LAaa3\u0003\u001c\n)\u0012)\u001e;iK:$\u0018nY1uS>tW*Z:tC\u001e,\u0017AF8o\u001d>$\u0018NZ5dCRLwN\u001c*fgB|gn]3\u0015\t\t%3\u0011\u001b\u0005\b\u0007\u000b\u0004\u0006\u0019\u0001Bs\u0003Y\u0011XmZ5ti\u0016\u0014hj\u001c;jMfd\u0015n\u001d;f]\u0016\u0014H\u0003\u0002B%\u0007/Dqa!7R\u0001\u0004\u0011y.\u0001\u0005mSN$XM\\3s\u0003a)hN]3hSN$XM\u001d(pi&4\u0017\u0010T5ti\u0016tWM\u001d\u000b\u0005\u0005\u0013\u001ay\u000eC\u0004\u0004ZJ\u0003\rAa8\u0002)\rdW-\u0019:O_RLg-\u001f'jgR,g.\u001a:t\u0003)\u0019'/\u001a3f]RL\u0017\r\u001c\u000b\u0005\u0007O\u001c\u0019\u0010\u0005\u0003\u0004j\u000e=XBABv\u0015\u0011\u0019iOa(\u0002\u0011\u0019\u0014xN\u001c;f]\u0012LAa!=\u0004l\n\t2I]3eK:$\u0018.\u00197NKN\u001c\u0018mZ3\t\u000f\rUH\u000b1\u0001\u0004x\u0006)\u0012-\u001e;iK:$\u0018nY1uS>tW*Z:tC\u001e,\u0007\u0003\u0002BM\u0007sLAaa?\u0003\u001c\nq\u0012)\u001e;iK:$\u0018nY1uS>t7\t[1mY\u0016tw-Z'fgN\fw-Z\u0001\u0016]>$(+Z1es\u001a{'/U;fef,%O]8s)\u0019!\t\u0001b\u0002\u0005\fA\u0019!\u000fb\u0001\n\u0007\u0011\u00151OA\u0004O_RD\u0017N\\4\t\u000f\u0011%Q\u000b1\u0001\u0003\u001c\u0005aQM\u001d:pe6+7o]1hK\"9AQB+A\u0002\u0005]\u0014\u0001\u0002:bG\u0016\f1D^1mS\u0012\fG/Z%g\u0013RL5OU3bIf4uN])vKJLH\u0003\u0002B%\t'Aq\u0001\"\u0003W\u0001\u0004\u0011Y\"A\u0007wC2LG-\u0019;f#V,'/\u001f\u000b\u0005\u0005\u0013\"I\u0002C\u0004\u00040]\u0003\rAa\u0007\u0002\u0019E,XM]=Qe>l\u0017n]3\u0016\u0005\tU\u0014aD:fiF+XM]=Qe>l\u0017n]3\u0015\t\t%C1\u0005\u0005\b\tKI\u0006\u0019\u0001B>\u0003\u001d\u0001(o\\7jg\u0016\f\u0011c\u00197fCJ\fV/\u001a:z!J|W.[:f\u0003A1\u0017-\u001b7Rk\u0016\u0014\u0018\u0010\u0015:p[&\u001cX\r\u0006\u0003\u0003J\u00115\u0002b\u0002C\u00187\u0002\u00071\u0011M\u0001\u0002i\u0006\u00192/^2dK\u0016$\u0017+^3ssB\u0013x.\\5tKR!!\u0011\nC\u001b\u0011\u001d!9\u0004\u0018a\u0001\u0005{\naA]3tk2$\u0018!B<sSR,G\u0003\u0002B%\t{Aqa!2^\u0001\u0004!y\u0004\u0005\u0003\u0004j\u0012\u0005\u0013\u0002\u0002C\"\u0007W\u0014Qb\u00117jK:$X*Z:tC\u001e,\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\tm\u0001")
public class PostgreSQLConnection
implements PostgreSQLConnectionDelegate,
Connection,
TimeoutScheduler {
    private final Configuration configuration;
    private final ColumnEncoderRegistry encoderRegistry;
    private final ColumnDecoderRegistry decoderRegistry;
    private final boolean positionalParamHolder;
    private final ExecutionContext executionContext;
    private final EventLoopGroup group;
    private final PostgreSQLConnectionHandler connectionHandler;
    private final long currentCount;
    private final AtomicInteger preparedStatementsCounter;
    private final HashMap<String, String> parameterStatus;
    private final HashMap<String, PreparedStatementHolder> parsedStatements;
    private boolean authenticated;
    private final Promise<Connection> connectionFuture;
    private boolean recentError;
    private final AtomicReference<Option<Promise<QueryResult>>> queryPromiseReference;
    private Option<MutableResultSet<PostgreSQLColumnData>> currentQuery;
    private Option<PreparedStatementHolder> currentPreparedStatement;
    private Version version;
    private CopyOnWriteArrayList<Function1<NotificationResponse, BoxedUnit>> notifyListeners;
    private Option<QueryResult> queryResult;
    private AtomicBoolean com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool;

    public static ExecutionContext $lessinit$greater$default$5() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$5();
    }

    public static boolean $lessinit$greater$default$4() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$4();
    }

    public static ColumnDecoderRegistry $lessinit$greater$default$3() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$3();
    }

    public static ColumnEncoderRegistry $lessinit$greater$default$2() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$2();
    }

    public static Configuration $lessinit$greater$default$1() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$1();
    }

    public static Logger log() {
        return PostgreSQLConnection$.MODULE$.log();
    }

    public static String ServerVersionKey() {
        return PostgreSQLConnection$.MODULE$.ServerVersionKey();
    }

    public static AtomicLong Counter() {
        return PostgreSQLConnection$.MODULE$.Counter();
    }

    public AtomicBoolean com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool() {
        return this.com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool;
    }

    public void com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool_$eq(AtomicBoolean x$1) {
        this.com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool = x$1;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    private EventLoopGroup group() {
        return this.group;
    }

    private final PostgreSQLConnectionHandler connectionHandler() {
        return this.connectionHandler;
    }

    private final long currentCount() {
        return this.currentCount;
    }

    private final AtomicInteger preparedStatementsCounter() {
        return this.preparedStatementsCounter;
    }

    private HashMap<String, String> parameterStatus() {
        return this.parameterStatus;
    }

    private HashMap<String, PreparedStatementHolder> parsedStatements() {
        return this.parsedStatements;
    }

    private boolean authenticated() {
        return this.authenticated;
    }

    private void authenticated_$eq(boolean x$1) {
        this.authenticated = x$1;
    }

    private Promise<Connection> connectionFuture() {
        return this.connectionFuture;
    }

    private boolean recentError() {
        return this.recentError;
    }

    private void recentError_$eq(boolean x$1) {
        this.recentError = x$1;
    }

    private AtomicReference<Option<Promise<QueryResult>>> queryPromiseReference() {
        return this.queryPromiseReference;
    }

    private Option<MutableResultSet<PostgreSQLColumnData>> currentQuery() {
        return this.currentQuery;
    }

    private void currentQuery_$eq(Option<MutableResultSet<PostgreSQLColumnData>> x$1) {
        this.currentQuery = x$1;
    }

    private Option<PreparedStatementHolder> currentPreparedStatement() {
        return this.currentPreparedStatement;
    }

    private void currentPreparedStatement_$eq(Option<PreparedStatementHolder> x$1) {
        this.currentPreparedStatement = x$1;
    }

    private Version version() {
        return this.version;
    }

    private void version_$eq(Version x$1) {
        this.version = x$1;
    }

    private CopyOnWriteArrayList<Function1<NotificationResponse, BoxedUnit>> notifyListeners() {
        return this.notifyListeners;
    }

    private void notifyListeners_$eq(CopyOnWriteArrayList<Function1<NotificationResponse, BoxedUnit>> x$1) {
        this.notifyListeners = x$1;
    }

    private Option<QueryResult> queryResult() {
        return this.queryResult;
    }

    private void queryResult_$eq(Option<QueryResult> x$1) {
        this.queryResult = x$1;
    }

    public EventLoopGroup eventLoopGroup() {
        return this.group();
    }

    public boolean isReadyForQuery() {
        return this.queryPromise().isEmpty();
    }

    public Future<Connection> connect() {
        this.connectionHandler().connect().onComplete((Function1 & Serializable)x0$1 -> {
            Object object;
            Try try_ = x0$1;
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                object = BoxesRunTime.boxToBoolean((boolean)this.connectionFuture().tryFailure(e));
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        }, this.executionContext());
        return this.connectionFuture().future();
    }

    public Future<Connection> disconnect() {
        return this.connectionHandler().disconnect().map((Function1 & Serializable)c -> this, this.executionContext());
    }

    public void onTimeout() {
        this.disconnect();
    }

    public boolean isConnected() {
        return this.connectionHandler().isConnected();
    }

    public Map<String, String> parameterStatuses() {
        return this.parameterStatus().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Future<QueryResult> sendQuery(String query) {
        return Metrics$.MODULE$.stat(query, (Function0 & Serializable)() -> {
            this.validateQuery(query);
            Promise promise = Promise$.MODULE$.apply();
            this.setQueryPromise((Promise<QueryResult>)promise);
            this.write(new QueryMessage(query));
            this.addTimeout(promise, $this.configuration.queryTimeout(), this.executionContext());
            return promise.future();
        });
    }

    public Future<QueryResult> sendPreparedStatement(String query, Seq<Object> values) {
        return Metrics$.MODULE$.stat(query, (Function0 & Serializable)() -> {
            PreparedStatementMessage preparedStatementMessage;
            this.validateQuery(query);
            Promise promise = Promise$.MODULE$.apply();
            this.setQueryPromise((Promise<QueryResult>)promise);
            PreparedStatementHolder holder = (PreparedStatementHolder)this.parsedStatements().getOrElseUpdate((Object)query, (Function0 & Serializable)() -> new PreparedStatementHolder(query, this.preparedStatementsCounter().incrementAndGet(), $this.positionalParamHolder));
            if (holder.paramsCount() != values.length()) {
                this.clearQueryPromise();
                throw new InsufficientParametersException(holder.paramsCount(), values);
            }
            this.currentPreparedStatement_$eq((Option<PreparedStatementHolder>)new Some((Object)holder));
            this.currentQuery_$eq((Option<MutableResultSet<PostgreSQLColumnData>>)new Some((Object)new MutableResultSet(holder.columnDatas())));
            if (holder.prepared()) {
                preparedStatementMessage = new PreparedStatementExecuteMessage(holder.statementId(), holder.realQuery(), values, $this.encoderRegistry);
            } else {
                holder.prepared_$eq(true);
                preparedStatementMessage = new PreparedStatementOpeningMessage(holder.statementId(), holder.realQuery(), values, $this.encoderRegistry);
            }
            this.write(preparedStatementMessage);
            this.addTimeout(promise, $this.configuration.queryTimeout(), this.executionContext());
            return promise.future();
        });
    }

    public Seq<Object> sendPreparedStatement$default$2() {
        return Nil$.MODULE$;
    }

    @Override
    public void onError(Throwable exception) {
        this.setErrorOnFutures(exception);
    }

    public boolean hasRecentError() {
        return this.recentError();
    }

    private void setErrorOnFutures(Throwable e) {
        Future<Connection> future;
        this.recentError_$eq(true);
        PostgreSQLConnection$.MODULE$.log().error("Error on connection", e);
        if (!this.connectionFuture().isCompleted()) {
            this.connectionFuture().failure(e);
            future = this.disconnect();
        } else {
            future = BoxedUnit.UNIT;
        }
        this.currentPreparedStatement().map((Function1 & Serializable)p -> this.parsedStatements().remove((Object)p.query()));
        this.currentPreparedStatement_$eq((Option<PreparedStatementHolder>)None$.MODULE$);
        this.failQueryPromise(e);
    }

    @Override
    public void onReadyForQuery() {
        this.connectionFuture().trySuccess((Object)this);
        this.recentError_$eq(false);
        this.queryResult().foreach((Function1 & Serializable)result -> {
            this.succeedQueryPromise(result);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void onError(ErrorMessage m) {
        PostgreSQLConnection$.MODULE$.log().error("Error with message -> {}", (Object)m);
        GenericDatabaseException error = new GenericDatabaseException(m);
        error.fillInStackTrace();
        this.setErrorOnFutures((Throwable)((Object)error));
    }

    @Override
    public void onCommandComplete(CommandCompleteMessage m) {
        this.currentPreparedStatement_$eq((Option<PreparedStatementHolder>)None$.MODULE$);
        this.queryResult_$eq((Option<QueryResult>)new Some((Object)new QueryResult((long)m.rowsAffected(), m.statusMessage(), this.currentQuery())));
    }

    @Override
    public void onParameterStatus(ParameterStatusMessage m) {
        block0: {
            this.parameterStatus().put((Object)m.key(), (Object)m.value());
            if (!"server_version".equals(m.key())) break block0;
            this.version_$eq(Version$.MODULE$.apply(m.value()));
        }
    }

    @Override
    public void onDataRow(DataRowMessage m) {
        Object[] items = new Object[ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])m.values()))];
        for (int x = 0; x < ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])m.values())); ++x) {
            Object object;
            ByteBuf buf = m.values()[x];
            if (buf == null) {
                object = null;
            } else {
                try {
                    PostgreSQLColumnData columnType = (PostgreSQLColumnData)((MutableResultSet)this.currentQuery().get()).columnTypes().apply(x);
                    object = this.decoderRegistry.decode((ColumnData)columnType, buf, this.configuration.charset());
                }
                finally {
                    buf.release();
                }
            }
            items[x] = object;
        }
        ((MutableResultSet)this.currentQuery().get()).addRow(items);
    }

    @Override
    public void onRowDescription(RowDescriptionMessage m) {
        this.currentQuery_$eq((Option<MutableResultSet<PostgreSQLColumnData>>)Option$.MODULE$.apply((Object)new MutableResultSet(m.columnDatas())));
        this.setColumnDatas(m.columnDatas());
    }

    private void setColumnDatas(ArrayBuffer<PostgreSQLColumnData> columnDatas) {
        this.currentPreparedStatement().foreach((Function1 & Serializable)holder -> {
            holder.columnDatas_$eq((ArrayBuffer<PostgreSQLColumnData>)columnDatas);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void onAuthenticationResponse(AuthenticationMessage message) {
        AuthenticationMessage authenticationMessage = message;
        if (authenticationMessage instanceof AuthenticationOkMessage) {
            PostgreSQLConnection$.MODULE$.log().debug("Successfully logged in to database");
            this.authenticated_$eq(true);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (authenticationMessage instanceof AuthenticationChallengeCleartextMessage) {
            AuthenticationChallengeCleartextMessage authenticationChallengeCleartextMessage = (AuthenticationChallengeCleartextMessage)authenticationMessage;
            this.write(this.credential(authenticationChallengeCleartextMessage));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (authenticationMessage instanceof AuthenticationChallengeMD5) {
            AuthenticationChallengeMD5 authenticationChallengeMD5 = (AuthenticationChallengeMD5)authenticationMessage;
            this.write(this.credential(authenticationChallengeMD5));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)authenticationMessage);
        }
    }

    @Override
    public void onNotificationResponse(NotificationResponse message) {
        Iterator<Function1<NotificationResponse, BoxedUnit>> iterator = this.notifyListeners().iterator();
        while (iterator.hasNext()) {
            iterator.next().apply((Object)message);
        }
    }

    public void registerNotifyListener(Function1<NotificationResponse, BoxedUnit> listener) {
        this.notifyListeners().add(listener);
    }

    public void unregisterNotifyListener(Function1<NotificationResponse, BoxedUnit> listener) {
        this.notifyListeners().remove(listener);
    }

    public void clearNotifyListeners() {
        this.notifyListeners().clear();
    }

    private CredentialMessage credential(AuthenticationChallengeMessage authenticationMessage) {
        if (this.configuration.username() == null || !this.configuration.password().isDefined()) {
            throw new MissingCredentialInformationException(this.configuration.username(), (Option<String>)this.configuration.password(), authenticationMessage.challengeType());
        }
        return new CredentialMessage(this.configuration.username(), (String)this.configuration.password().get(), authenticationMessage.challengeType(), authenticationMessage.salt());
    }

    private Nothing$ notReadyForQueryError(String errorMessage, boolean race) {
        PostgreSQLConnection$.MODULE$.log().error(errorMessage);
        throw new ConnectionStillRunningQueryException(this.currentCount(), race);
    }

    public void validateIfItIsReadyForQuery(String errorMessage) {
        if (this.queryPromise().isDefined()) {
            throw this.notReadyForQueryError(errorMessage, false);
        }
    }

    private void validateQuery(String query) {
        this.validateIfItIsReadyForQuery("Can't run query because there is one query pending already");
        if (query == null || query.isEmpty()) {
            throw new QueryMustNotBeNullOrEmptyException(query);
        }
    }

    private Option<Promise<QueryResult>> queryPromise() {
        return this.queryPromiseReference().get();
    }

    private void setQueryPromise(Promise<QueryResult> promise) {
        if (!this.queryPromiseReference().compareAndSet((Option<Promise<QueryResult>>)None$.MODULE$, (Option<Promise<QueryResult>>)new Some(promise))) {
            throw this.notReadyForQueryError("Can't run query due to a race with another started query", true);
        }
    }

    private Option<Promise<QueryResult>> clearQueryPromise() {
        return this.queryPromiseReference().getAndSet((Option<Promise<QueryResult>>)None$.MODULE$);
    }

    private void failQueryPromise(Throwable t) {
        this.clearQueryPromise().foreach((Function1 & Serializable)promise -> {
            PostgreSQLConnection$.MODULE$.log().error("Setting error on future {}", promise);
            return promise.failure(t);
        });
    }

    private void succeedQueryPromise(QueryResult result) {
        this.queryResult_$eq((Option<QueryResult>)None$.MODULE$);
        this.currentQuery_$eq((Option<MutableResultSet<PostgreSQLColumnData>>)None$.MODULE$);
        this.clearQueryPromise().foreach((Function1 & Serializable)x$1 -> x$1.success((Object)result));
    }

    private void write(ClientMessage message) {
        this.connectionHandler().write(message);
    }

    public String toString() {
        return new StringBuilder(10).append(this.getClass().getSimpleName()).append("{counter=").append(this.currentCount()).append("}").toString();
    }

    public PostgreSQLConnection(Configuration configuration, ColumnEncoderRegistry encoderRegistry, ColumnDecoderRegistry decoderRegistry, boolean positionalParamHolder, ExecutionContext executionContext) {
        this.configuration = configuration;
        this.encoderRegistry = encoderRegistry;
        this.decoderRegistry = decoderRegistry;
        this.positionalParamHolder = positionalParamHolder;
        this.executionContext = executionContext;
        Connection.$init$((Connection)this);
        TimeoutScheduler.$init$((TimeoutScheduler)this);
        this.group = configuration.eventLoopGroup();
        this.connectionHandler = new PostgreSQLConnectionHandler(configuration, encoderRegistry, decoderRegistry, this, this.group(), executionContext);
        this.currentCount = PostgreSQLConnection$.MODULE$.Counter().incrementAndGet();
        this.preparedStatementsCounter = new AtomicInteger();
        this.parameterStatus = new HashMap();
        this.parsedStatements = new HashMap();
        this.authenticated = false;
        this.connectionFuture = Promise$.MODULE$.apply();
        this.recentError = false;
        this.queryPromiseReference = new AtomicReference<None$>(None$.MODULE$);
        this.currentQuery = None$.MODULE$;
        this.currentPreparedStatement = None$.MODULE$;
        this.version = new Version(0, 0, 0);
        this.notifyListeners = new CopyOnWriteArrayList();
        this.queryResult = None$.MODULE$;
    }
}

