/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql.codec;

import com.github.mauricio.async.db.exceptions.NegativeMessageSizeException;
import com.github.mauricio.async.db.postgresql.codec.MessageDecoder$;
import com.github.mauricio.async.db.postgresql.exceptions.MessageTooLongException;
import com.github.mauricio.async.db.postgresql.messages.backend.SSLResponseMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.ServerMessage;
import com.github.mauricio.async.db.postgresql.parsers.AuthenticationStartupParser$;
import com.github.mauricio.async.db.postgresql.parsers.MessageParsersRegistry;
import com.github.mauricio.async.db.util.BufferDumper;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005}r!B\n\u0015\u0011\u0003\u0019c!B\u0013\u0015\u0011\u00031\u0003\"B\u0017\u0002\t\u0003q\u0003bB\u0018\u0002\u0005\u0004%\t\u0001\r\u0005\u0007s\u0005\u0001\u000b\u0011B\u0019\t\u000fi\n!\u0019!C\u0001w!1q(\u0001Q\u0001\nqBq\u0001Q\u0001\u0012\u0002\u0013\u0005\u0011I\u0002\u0003&)\u0001a\u0005\u0002\u0003-\t\u0005\u0003\u0005\u000b\u0011B-\t\u0011qC!\u0011!Q\u0001\nuC\u0001B\u001a\u0005\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\u0006[!!\ta\u001a\u0005\bY\"\u0011\r\u0011\"\u0003n\u0011\u0019!\b\u0002)A\u0005]\"9Q\u000f\u0003a\u0001\n\u00131\bbB<\t\u0001\u0004%I\u0001\u001f\u0005\u0007}\"\u0001\u000b\u0015B-\t\r}DA\u0011IA\u0001\u00039iUm]:bO\u0016$UmY8eKJT!!\u0006\f\u0002\u000b\r|G-Z2\u000b\u0005]A\u0012A\u00039pgR<'/Z:rY*\u0011\u0011DG\u0001\u0003I\nT!a\u0007\u000f\u0002\u000b\u0005\u001c\u0018P\\2\u000b\u0005uq\u0012\u0001C7bkJL7-[8\u000b\u0005}\u0001\u0013AB4ji\",(MC\u0001\"\u0003\r\u0019w.\\\u0002\u0001!\t!\u0013!D\u0001\u0015\u00059iUm]:bO\u0016$UmY8eKJ\u001c\"!A\u0014\u0011\u0005!ZS\"A\u0015\u000b\u0003)\nQa]2bY\u0006L!\u0001L\u0015\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1%A\u0002m_\u001e,\u0012!\r\t\u0003e]j\u0011a\r\u0006\u0003iU\nQa\u001d7gi)T\u0011AN\u0001\u0004_J<\u0017B\u0001\u001d4\u0005\u0019aunZ4fe\u0006!An\\4!\u0003I!UMZ1vYRl\u0015\r_5nk6\u001c\u0016N_3\u0016\u0003q\u0002\"\u0001K\u001f\n\u0005yJ#aA%oi\u0006\u0019B)\u001a4bk2$X*\u0019=j[Vl7+\u001b>fA\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\u0012A\u0011\u0016\u0003y\r[\u0013\u0001\u0012\t\u0003\u000b*k\u0011A\u0012\u0006\u0003\u000f\"\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005%K\u0013AC1o]>$\u0018\r^5p]&\u00111J\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,7C\u0001\u0005N!\tqe+D\u0001P\u0015\t)\u0002K\u0003\u0002R%\u00069\u0001.\u00198eY\u0016\u0014(BA*U\u0003\u0015qW\r\u001e;z\u0015\u0005)\u0016AA5p\u0013\t9vJ\u0001\u000bCsR,Gk\\'fgN\fw-\u001a#fG>$WM]\u0001\u000bgNdWI\\1cY\u0016$\u0007C\u0001\u0015[\u0013\tY\u0016FA\u0004C_>dW-\u00198\u0002\u000f\rD\u0017M]:fiB\u0011a\fZ\u0007\u0002?*\u0011A\f\u0019\u0006\u0003C\n\f1A\\5p\u0015\u0005\u0019\u0017\u0001\u00026bm\u0006L!!Z0\u0003\u000f\rC\u0017M]:fi\u0006\u0011R.\u0019=j[VlW*Z:tC\u001e,7+\u001b>f)\u0011A\u0017N[6\u0011\u0005\u0011B\u0001\"\u0002-\r\u0001\u0004I\u0006\"\u0002/\r\u0001\u0004i\u0006b\u00024\r!\u0003\u0005\r\u0001P\u0001\u0007a\u0006\u00148/\u001a:\u0016\u00039\u0004\"a\u001c:\u000e\u0003AT!!\u001d\f\u0002\u000fA\f'o]3sg&\u00111\u000f\u001d\u0002\u0017\u001b\u0016\u001c8/Y4f!\u0006\u00148/\u001a:t%\u0016<\u0017n\u001d;ss\u00069\u0001/\u0019:tKJ\u0004\u0013AC:tY\u000eCWmY6fIV\t\u0011,\u0001\btg2\u001c\u0005.Z2lK\u0012|F%Z9\u0015\u0005ed\bC\u0001\u0015{\u0013\tY\u0018F\u0001\u0003V]&$\bbB?\u0011\u0003\u0003\u0005\r!W\u0001\u0004q\u0012\n\u0014aC:tY\u000eCWmY6fI\u0002\na\u0001Z3d_\u0012,GcB=\u0002\u0004\u0005M\u00111\u0005\u0005\b\u0003\u000b\u0011\u0002\u0019AA\u0004\u0003\r\u0019G\u000f\u001f\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011Q\u0002*\u0002\u000f\rD\u0017M\u001c8fY&!\u0011\u0011CA\u0006\u0005U\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJ\u001cuN\u001c;fqRDq!!\u0006\u0013\u0001\u0004\t9\"A\u0001c!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000f%\u00061!-\u001e4gKJLA!!\t\u0002\u001c\t9!)\u001f;f\u0005V4\u0007bBA\u0013%\u0001\u0007\u0011qE\u0001\u0004_V$\bCBA\u0015\u0003_\t\u0019$\u0004\u0002\u0002,)\u0019\u0011Q\u00062\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003c\tYC\u0001\u0003MSN$\b\u0003BA\u001b\u0003wi!!a\u000e\u000b\u0007\u0005e\"-\u0001\u0003mC:<\u0017\u0002BA\u001f\u0003o\u0011aa\u00142kK\u000e$\b")
public class MessageDecoder
extends ByteToMessageDecoder {
    private final boolean sslEnabled;
    private final int maximumMessageSize;
    private final MessageParsersRegistry parser;
    private boolean sslChecked;

    public static int $lessinit$greater$default$3() {
        return MessageDecoder$.MODULE$.$lessinit$greater$default$3();
    }

    public static int DefaultMaximumSize() {
        return MessageDecoder$.MODULE$.DefaultMaximumSize();
    }

    public static Logger log() {
        return MessageDecoder$.MODULE$.log();
    }

    private MessageParsersRegistry parser() {
        return this.parser;
    }

    private boolean sslChecked() {
        return this.sslChecked;
    }

    private void sslChecked_$eq(boolean x$1) {
        this.sslChecked = x$1;
    }

    public void decode(ChannelHandlerContext ctx, ByteBuf b, List<Object> out) {
        block9: {
            block8: {
                if (!(this.sslEnabled & !this.sslChecked())) break block8;
                byte code = b.readByte();
                this.sslChecked_$eq(true);
                out.add(new SSLResponseMessage(code == 83));
                break block9;
            }
            if (b.readableBytes() < 5) break block9;
            b.markReaderIndex();
            byte code = b.readByte();
            int lengthWithSelf = b.readInt();
            int length = lengthWithSelf - 4;
            if (length < 0) {
                throw new NegativeMessageSizeException(code, length);
            }
            if (length > this.maximumMessageSize) {
                throw new MessageTooLongException(code, length, this.maximumMessageSize);
            }
            if (b.readableBytes() >= length) {
                ServerMessage serverMessage;
                if (MessageDecoder$.MODULE$.log().isTraceEnabled()) {
                    MessageDecoder$.MODULE$.log().trace(new StringBuilder(17).append("Received buffer ").append(code).append("\n").append(BufferDumper.dumpAsHex((ByteBuf)b)).toString());
                }
                byte by = code;
                switch (by) {
                    case 82: {
                        serverMessage = AuthenticationStartupParser$.MODULE$.parseMessage(b);
                        break;
                    }
                    default: {
                        serverMessage = this.parser().parse(code, b.readSlice(length));
                        break;
                    }
                }
                ServerMessage result = serverMessage;
                out.add(result);
            } else {
                b.resetReaderIndex();
            }
        }
    }

    public MessageDecoder(boolean sslEnabled, Charset charset, int maximumMessageSize) {
        this.sslEnabled = sslEnabled;
        this.maximumMessageSize = maximumMessageSize;
        this.parser = new MessageParsersRegistry(charset);
        this.sslChecked = false;
    }
}

