/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql.column;

import com.github.mauricio.async.db.column.ColumnDecoder;
import com.github.mauricio.async.db.column.ColumnEncoder;
import com.github.mauricio.async.db.column.ColumnEncoderDecoder;
import com.github.mauricio.async.db.exceptions.DateEncoderNotAvailableException;
import com.github.mauricio.async.db.general.ColumnData;
import com.github.mauricio.async.db.postgresql.messages.backend.PostgreSQLColumnData;
import com.github.mauricio.async.db.util.Log$;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class PostgreSQLTimestampEncoderDecoder$
implements ColumnEncoderDecoder {
    public static final PostgreSQLTimestampEncoderDecoder$ MODULE$ = new PostgreSQLTimestampEncoderDecoder$();
    private static final Logger log;
    private static final DateTimeParser optionalTimeZone;
    private static final IndexedSeq<DateTimeFormatter> internalFormatters;
    private static final DateTimeFormatter internalFormatterWithoutSeconds;

    static {
        ColumnEncoder.$init$((ColumnEncoder)MODULE$);
        ColumnDecoder.$init$((ColumnDecoder)MODULE$);
        log = Log$.MODULE$.getByName(MODULE$.getClass().getName());
        optionalTimeZone = new DateTimeFormatterBuilder().appendPattern("Z").toParser();
        internalFormatters = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 6).inclusive().map((Function1 & Serializable)index -> PostgreSQLTimestampEncoderDecoder$.$anonfun$internalFormatters$1(BoxesRunTime.unboxToInt((Object)index)));
        internalFormatterWithoutSeconds = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendOptional(MODULE$.optionalTimeZone()).toFormatter();
    }

    private Logger log() {
        return log;
    }

    private DateTimeParser optionalTimeZone() {
        return optionalTimeZone;
    }

    private IndexedSeq<DateTimeFormatter> internalFormatters() {
        return internalFormatters;
    }

    private DateTimeFormatter internalFormatterWithoutSeconds() {
        return internalFormatterWithoutSeconds;
    }

    public DateTimeFormatter formatter() {
        return (DateTimeFormatter)this.internalFormatters().apply(5);
    }

    public Object decode(ColumnData kind, ByteBuf value, Charset charset) {
        LocalDateTime localDateTime;
        byte[] bytes = new byte[value.readableBytes()];
        value.readBytes(bytes);
        String text = new String(bytes, charset);
        PostgreSQLColumnData columnType = (PostgreSQLColumnData)kind;
        int n = columnType.dataType();
        switch (n) {
            case 1114: 
            case 1115: {
                localDateTime = this.selectFormatter(text).parseLocalDateTime(text);
                break;
            }
            case 1185: {
                localDateTime = this.selectFormatter(text).parseDateTime(text);
                break;
            }
            case 1184: {
                if (columnType.dataTypeModifier() > 0) {
                    localDateTime = ((DateTimeFormatter)this.internalFormatters().apply(columnType.dataTypeModifier() - 1)).parseDateTime(text);
                    break;
                }
                localDateTime = this.selectFormatter(text).parseDateTime(text);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return localDateTime;
    }

    private DateTimeFormatter selectFormatter(String text) {
        return text.contains(".") ? (DateTimeFormatter)this.internalFormatters().apply(5) : this.internalFormatterWithoutSeconds();
    }

    public Object decode(String value) {
        throw new UnsupportedOperationException("this method should not have been called");
    }

    public String encode(Object value) {
        String string;
        Object object = value;
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            string = this.formatter().print((ReadableInstant)new DateTime((Object)timestamp));
        } else if (object instanceof Date) {
            Date date = (Date)object;
            string = this.formatter().print((ReadableInstant)new DateTime((Object)date));
        } else if (object instanceof Calendar) {
            Calendar calendar = (Calendar)object;
            string = this.formatter().print((ReadableInstant)new DateTime((Object)calendar));
        } else if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            string = this.formatter().print((ReadablePartial)localDateTime);
        } else if (object instanceof ReadableDateTime) {
            ReadableDateTime readableDateTime = (ReadableDateTime)object;
            string = this.formatter().print((ReadableInstant)readableDateTime);
        } else {
            throw new DateEncoderNotAvailableException(value);
        }
        return string;
    }

    public boolean supportsStringDecoding() {
        return false;
    }

    public static final /* synthetic */ DateTimeFormatter $anonfun$internalFormatters$1(int index) {
        return new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendPattern(new StringBuilder(1).append(".").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("S"), index)).toString()).appendOptional(MODULE$.optionalTimeZone()).toFormatter();
    }

    private PostgreSQLTimestampEncoderDecoder$() {
    }
}

