/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql.codec;

import com.github.mauricio.async.db.KindedMessage;
import com.github.mauricio.async.db.column.ColumnEncoderRegistry;
import com.github.mauricio.async.db.exceptions.EncoderNotAvailableException;
import com.github.mauricio.async.db.postgresql.codec.MessageEncoder$;
import com.github.mauricio.async.db.postgresql.encoders.CloseMessageEncoder$;
import com.github.mauricio.async.db.postgresql.encoders.CredentialEncoder;
import com.github.mauricio.async.db.postgresql.encoders.Encoder;
import com.github.mauricio.async.db.postgresql.encoders.ExecutePreparedStatementEncoder;
import com.github.mauricio.async.db.postgresql.encoders.PreparedStatementOpeningEncoder;
import com.github.mauricio.async.db.postgresql.encoders.QueryMessageEncoder;
import com.github.mauricio.async.db.postgresql.encoders.SSLMessageEncoder$;
import com.github.mauricio.async.db.postgresql.encoders.StartupMessageEncoder;
import com.github.mauricio.async.db.postgresql.messages.frontend.ClientMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.SSLRequestMessage$;
import com.github.mauricio.async.db.postgresql.messages.frontend.StartupMessage;
import com.github.mauricio.async.db.util.BufferDumper;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ur!\u0002\u000b\u0016\u0011\u0003!c!\u0002\u0014\u0016\u0011\u00039\u0003\"\u0002\u0018\u0002\t\u0003y\u0003b\u0002\u0019\u0002\u0005\u0004%\t!\r\u0005\u0007u\u0005\u0001\u000b\u0011\u0002\u001a\u0007\t\u0019*\u0002a\u000f\u0005\t\u001f\u0016\u0011\t\u0011)A\u0005!\"Aq+\u0002B\u0001B\u0003%\u0001\fC\u0003/\u000b\u0011\u0005a\fC\u0004c\u000b\t\u0007I\u0011B2\t\r),\u0001\u0015!\u0003e\u0011\u001dYWA1A\u0005\n1Da\u0001]\u0003!\u0002\u0013i\u0007bB9\u0006\u0005\u0004%IA\u001d\u0005\u0007m\u0016\u0001\u000b\u0011B:\t\u000f],!\u0019!C\u0005q\"1A0\u0002Q\u0001\neDq!`\u0003C\u0002\u0013%a\u0010C\u0004\u0002\u0006\u0015\u0001\u000b\u0011B@\t\u000f\u0005\u001dQ\u0001\"\u0011\u0002\n\u0005qQ*Z:tC\u001e,WI\\2pI\u0016\u0014(B\u0001\f\u0018\u0003\u0015\u0019w\u000eZ3d\u0015\tA\u0012$\u0001\u0006q_N$xM]3tc2T!AG\u000e\u0002\u0005\u0011\u0014'B\u0001\u000f\u001e\u0003\u0015\t7/\u001f8d\u0015\tqr$\u0001\u0005nCV\u0014\u0018nY5p\u0015\t\u0001\u0013%\u0001\u0004hSRDWO\u0019\u0006\u0002E\u0005\u00191m\\7\u0004\u0001A\u0011Q%A\u0007\u0002+\tqQ*Z:tC\u001e,WI\\2pI\u0016\u00148CA\u0001)!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001J\u0001\u0004Y><W#\u0001\u001a\u0011\u0005MBT\"\u0001\u001b\u000b\u0005U2\u0014!B:mMRR'\"A\u001c\u0002\u0007=\u0014x-\u0003\u0002:i\t1Aj\\4hKJ\fA\u0001\\8hAM\u0011Q\u0001\u0010\t\u0004{\u0015;U\"\u0001 \u000b\u0005Yy$B\u0001!B\u0003\u001dA\u0017M\u001c3mKJT!AQ\"\u0002\u000b9,G\u000f^=\u000b\u0003\u0011\u000b!![8\n\u0005\u0019s$aF'fgN\fw-\u001a+p\u001b\u0016\u001c8/Y4f\u000b:\u001cw\u000eZ3s!\tAU*D\u0001J\u0015\tQ5*\u0001\u0003mC:<'\"\u0001'\u0002\t)\fg/Y\u0005\u0003\u001d&\u0013aa\u00142kK\u000e$\u0018aB2iCJ\u001cX\r\u001e\t\u0003#Vk\u0011A\u0015\u0006\u0003\u001fNS!\u0001V&\u0002\u00079Lw.\u0003\u0002W%\n91\t[1sg\u0016$\u0018aD3oG>$WM\u001d*fO&\u001cHO]=\u0011\u0005ecV\"\u0001.\u000b\u0005mK\u0012AB2pYVlg.\u0003\u0002^5\n)2i\u001c7v[:,enY8eKJ\u0014VmZ5tiJLHcA0aCB\u0011Q%\u0002\u0005\u0006\u001f\"\u0001\r\u0001\u0015\u0005\u0006/\"\u0001\r\u0001W\u0001\u000fKb,7-\u001e;f\u000b:\u001cw\u000eZ3s+\u0005!\u0007CA3i\u001b\u00051'BA4\u0018\u0003!)gnY8eKJ\u001c\u0018BA5g\u0005})\u00050Z2vi\u0016\u0004&/\u001a9be\u0016$7\u000b^1uK6,g\u000e^#oG>$WM]\u0001\u0010Kb,7-\u001e;f\u000b:\u001cw\u000eZ3sA\u0005Yq\u000e]3o\u000b:\u001cw\u000eZ3s+\u0005i\u0007CA3o\u0013\tygMA\u0010Qe\u0016\u0004\u0018M]3e'R\fG/Z7f]R|\u0005/\u001a8j]\u001e,enY8eKJ\fAb\u001c9f]\u0016s7m\u001c3fe\u0002\nab\u001d;beR,\b/\u00128d_\u0012,'/F\u0001t!\t)G/\u0003\u0002vM\n)2\u000b^1siV\u0004X*Z:tC\u001e,WI\\2pI\u0016\u0014\u0018aD:uCJ$X\u000f]#oG>$WM\u001d\u0011\u0002\u0019E,XM]=F]\u000e|G-\u001a:\u0016\u0003e\u0004\"!\u001a>\n\u0005m4'aE)vKJLX*Z:tC\u001e,WI\\2pI\u0016\u0014\u0018!D9vKJLXI\\2pI\u0016\u0014\b%A\tde\u0016$WM\u001c;jC2,enY8eKJ,\u0012a \t\u0004K\u0006\u0005\u0011bAA\u0002M\n\t2I]3eK:$\u0018.\u00197F]\u000e|G-\u001a:\u0002%\r\u0014X\rZ3oi&\fG.\u00128d_\u0012,'\u000fI\u0001\u0007K:\u001cw\u000eZ3\u0015\u0011\u0005-\u0011\u0011CA\u0011\u0003K\u00012!KA\u0007\u0013\r\tyA\u000b\u0002\u0005+:LG\u000fC\u0004\u0002\u0014M\u0001\r!!\u0006\u0002\u0007\r$\b\u0010\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tY\"Q\u0001\bG\"\fgN\\3m\u0013\u0011\ty\"!\u0007\u0003+\rC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe\u000e{g\u000e^3yi\"1\u00111E\nA\u0002!\n1!\\:h\u0011\u001d\t9c\u0005a\u0001\u0003S\t1a\\;u!\u0015\tY#!\rH\u001b\t\tiCC\u0002\u00020-\u000bA!\u001e;jY&!\u00111GA\u0017\u0005\u0011a\u0015n\u001d;")
public class MessageEncoder
extends MessageToMessageEncoder<Object> {
    private final ExecutePreparedStatementEncoder executeEncoder;
    private final PreparedStatementOpeningEncoder openEncoder;
    private final StartupMessageEncoder startupEncoder;
    private final QueryMessageEncoder queryEncoder;
    private final CredentialEncoder credentialEncoder;

    public static Logger log() {
        return MessageEncoder$.MODULE$.log();
    }

    private ExecutePreparedStatementEncoder executeEncoder() {
        return this.executeEncoder;
    }

    private PreparedStatementOpeningEncoder openEncoder() {
        return this.openEncoder;
    }

    private StartupMessageEncoder startupEncoder() {
        return this.startupEncoder;
    }

    private QueryMessageEncoder queryEncoder() {
        return this.queryEncoder;
    }

    private CredentialEncoder credentialEncoder() {
        return this.credentialEncoder;
    }

    public void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) {
        ByteBuf byteBuf;
        Object object = msg;
        if (SSLRequestMessage$.MODULE$.equals(object)) {
            byteBuf = SSLMessageEncoder$.MODULE$.encode();
        } else if (object instanceof StartupMessage) {
            StartupMessage startupMessage = (StartupMessage)object;
            byteBuf = this.startupEncoder().encode(startupMessage);
        } else if (object instanceof ClientMessage) {
            Encoder encoder;
            ClientMessage clientMessage = (ClientMessage)object;
            int n = clientMessage.kind();
            switch (n) {
                case 88: {
                    encoder = CloseMessageEncoder$.MODULE$;
                    break;
                }
                case 69: {
                    encoder = this.executeEncoder();
                    break;
                }
                case 80: {
                    encoder = this.openEncoder();
                    break;
                }
                case 81: {
                    encoder = this.queryEncoder();
                    break;
                }
                case 112: {
                    encoder = this.credentialEncoder();
                    break;
                }
                default: {
                    throw new EncoderNotAvailableException((KindedMessage)clientMessage);
                }
            }
            Encoder encoder2 = encoder;
            byteBuf = encoder2.encode(clientMessage);
        } else {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Can not encode message %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{msg})));
        }
        ByteBuf buffer = byteBuf;
        if (MessageEncoder$.MODULE$.log().isTraceEnabled()) {
            MessageEncoder$.MODULE$.log().trace(new StringBuilder(17).append("Sending message ").append(msg.getClass().getName()).append("\n").append(BufferDumper.dumpAsHex((ByteBuf)buffer)).toString());
        }
        out.add(buffer);
    }

    public MessageEncoder(Charset charset, ColumnEncoderRegistry encoderRegistry) {
        this.executeEncoder = new ExecutePreparedStatementEncoder(charset, encoderRegistry);
        this.openEncoder = new PreparedStatementOpeningEncoder(charset, encoderRegistry);
        this.startupEncoder = new StartupMessageEncoder(charset);
        this.queryEncoder = new QueryMessageEncoder(charset);
        this.credentialEncoder = new CredentialEncoder(charset);
    }
}

