/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql.parsers;

import com.github.mauricio.async.db.exceptions.UnsupportedAuthenticationMethodException;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeCleartextMessage$;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeMD5;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationOkMessage$;
import com.github.mauricio.async.db.postgresql.messages.backend.ServerMessage;
import com.github.mauricio.async.db.postgresql.parsers.MessageParser;
import io.netty.buffer.ByteBuf;

public final class AuthenticationStartupParser$
implements MessageParser {
    public static final AuthenticationStartupParser$ MODULE$ = new AuthenticationStartupParser$();
    private static final int AuthenticationOk = 0;
    private static final int AuthenticationKerberosV5 = 2;
    private static final int AuthenticationCleartextPassword = 3;
    private static final int AuthenticationMD5Password = 5;
    private static final int AuthenticationSCMCredential = 6;
    private static final int AuthenticationGSS = 7;
    private static final int AuthenticationGSSContinue = 8;
    private static final int AuthenticationSSPI = 9;

    public int AuthenticationOk() {
        return AuthenticationOk;
    }

    public int AuthenticationKerberosV5() {
        return AuthenticationKerberosV5;
    }

    public int AuthenticationCleartextPassword() {
        return AuthenticationCleartextPassword;
    }

    public int AuthenticationMD5Password() {
        return AuthenticationMD5Password;
    }

    public int AuthenticationSCMCredential() {
        return AuthenticationSCMCredential;
    }

    public int AuthenticationGSS() {
        return AuthenticationGSS;
    }

    public int AuthenticationGSSContinue() {
        return AuthenticationGSSContinue;
    }

    public int AuthenticationSSPI() {
        return AuthenticationSSPI;
    }

    @Override
    public ServerMessage parseMessage(ByteBuf b) {
        AuthenticationMessage authenticationMessage;
        int authenticationType;
        int n = authenticationType = b.readInt();
        if (this.AuthenticationOk() == n) {
            authenticationMessage = AuthenticationOkMessage$.MODULE$.Instance();
        } else if (this.AuthenticationCleartextPassword() == n) {
            authenticationMessage = AuthenticationChallengeCleartextMessage$.MODULE$.Instance();
        } else if (this.AuthenticationMD5Password() == n) {
            byte[] bytes = new byte[b.readableBytes()];
            b.readBytes(bytes);
            authenticationMessage = new AuthenticationChallengeMD5(bytes);
        } else {
            throw new UnsupportedAuthenticationMethodException(authenticationType);
        }
        return authenticationMessage;
    }

    private AuthenticationStartupParser$() {
    }
}

