/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql.pool;

import com.github.mauricio.async.db.Configuration;
import com.github.mauricio.async.db.Connection;
import com.github.mauricio.async.db.column.ColumnDecoderRegistry;
import com.github.mauricio.async.db.column.ColumnEncoderRegistry;
import com.github.mauricio.async.db.exceptions.ConnectionTimeoutedException;
import com.github.mauricio.async.db.pool.ObjectFactory;
import com.github.mauricio.async.db.postgresql.PostgreSQLConnection;
import com.github.mauricio.async.db.postgresql.PostgreSQLConnection$;
import com.github.mauricio.async.db.postgresql.pool.PostgreSQLConnectionFactory$;
import java.io.Serializable;
import java.nio.channels.ClosedChannelException;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005M<Qa\u0004\t\t\u0002}1Q!\t\t\t\u0002\tBQ!K\u0001\u0005\u0002)BqaK\u0001C\u0002\u0013\u0005A\u0006\u0003\u00046\u0003\u0001\u0006I!\f\u0005\bm\u0005\t\n\u0011\"\u00018\r\u0011\t\u0003\u0003\u0001%\t\u0011I3!Q1A\u0005\u0002MC\u0001\u0002\u0017\u0004\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\t3\u001a\u0011\t\u0011)A\u0005s!)\u0011F\u0002C\u00015\")aL\u0002C\u0001?\")\u0001M\u0002C\u0001C\")qM\u0002C\u0001Q\")\u0001O\u0002C!c\u0006Y\u0002k\\:uOJ,7+\u0015'D_:tWm\u0019;j_:4\u0015m\u0019;pefT!!\u0005\n\u0002\tA|w\u000e\u001c\u0006\u0003'Q\t!\u0002]8ti\u001e\u0014Xm]9m\u0015\t)b#\u0001\u0002eE*\u0011q\u0003G\u0001\u0006CNLhn\u0019\u0006\u00033i\t\u0001\"\\1ve&\u001c\u0017n\u001c\u0006\u00037q\taaZ5uQV\u0014'\"A\u000f\u0002\u0007\r|Wn\u0001\u0001\u0011\u0005\u0001\nQ\"\u0001\t\u00037A{7\u000f^4sKN\u000bFjQ8o]\u0016\u001cG/[8o\r\u0006\u001cGo\u001c:z'\t\t1\u0005\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\t1\u0001\\8h+\u0005i\u0003C\u0001\u00184\u001b\u0005y#B\u0001\u00192\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\u0011\u0014aA8sO&\u0011Ag\f\u0002\u0007\u0019><w-\u001a:\u0002\t1|w\rI\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003aR#!O \u0011\u0005ijT\"A\u001e\u000b\u0005q*\u0013AC2p]\u000e,(O]3oi&\u0011ah\u000f\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\\\u0013\u0001\u0011\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005\u0015+\u0013AC1o]>$\u0018\r^5p]&\u0011qI\u0011\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,7c\u0001\u0004$\u0013B\u0019!\n\u0014(\u000e\u0003-S!!\u0005\u000b\n\u00055[%!D(cU\u0016\u001cGOR1di>\u0014\u0018\u0010\u0005\u0002P!6\t!#\u0003\u0002R%\t!\u0002k\\:uOJ,7+\u0015'D_:tWm\u0019;j_:\fQbY8oM&<WO]1uS>tW#\u0001+\u0011\u0005U3V\"\u0001\u000b\n\u0005]#\"!D\"p]\u001aLw-\u001e:bi&|g.\u0001\bd_:4\u0017nZ;sCRLwN\u001c\u0011\u0002!\u0015DXmY;uS>t7i\u001c8uKb$HcA.];B\u0011\u0001E\u0002\u0005\u0006%*\u0001\r\u0001\u0016\u0005\b3*\u0001\n\u00111\u0001:\u0003\u0019\u0019'/Z1uKV\ta*A\u0004eKN$(o\\=\u0015\u0005\t,\u0007C\u0001\u0013d\u0013\t!WE\u0001\u0003V]&$\b\"\u00024\r\u0001\u0004q\u0015\u0001B5uK6\f\u0001B^1mS\u0012\fG/\u001a\u000b\u0003S>\u00042A[7O\u001b\u0005Y'B\u00017&\u0003\u0011)H/\u001b7\n\u00059\\'a\u0001+ss\")a-\u0004a\u0001\u001d\u0006!A/Z:u)\tI'\u000fC\u0003g\u001d\u0001\u0007a\n")
public class PostgreSQLConnectionFactory
implements ObjectFactory<PostgreSQLConnection> {
    private final Configuration configuration;
    private final ExecutionContext executionContext;

    public static ExecutionContext $lessinit$greater$default$2() {
        return PostgreSQLConnectionFactory$.MODULE$.$lessinit$greater$default$2();
    }

    public static Logger log() {
        return PostgreSQLConnectionFactory$.MODULE$.log();
    }

    public Configuration configuration() {
        return this.configuration;
    }

    /*
     * WARNING - void declaration
     */
    public PostgreSQLConnection create() {
        void var1_6;
        Configuration x$1 = this.configuration();
        ExecutionContext x$2 = this.executionContext;
        ColumnEncoderRegistry x$3 = PostgreSQLConnection$.MODULE$.$lessinit$greater$default$2();
        ColumnDecoderRegistry x$4 = PostgreSQLConnection$.MODULE$.$lessinit$greater$default$3();
        boolean x$5 = PostgreSQLConnection$.MODULE$.$lessinit$greater$default$4();
        PostgreSQLConnection connection = new PostgreSQLConnection(x$1, x$3, x$4, x$5, x$2);
        Await$.MODULE$.result(connection.connect(), this.configuration().connectTimeout());
        return var1_6;
    }

    public void destroy(PostgreSQLConnection item) {
        item.disconnect();
    }

    public Try<PostgreSQLConnection> validate(PostgreSQLConnection item) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            if (item.isTimeouted()) {
                throw new ConnectionTimeoutedException((Connection)item);
            }
            if (!item.isConnected() || item.hasRecentError()) {
                throw new ClosedChannelException();
            }
            item.validateIfItIsReadyForQuery("Trying to give back a connection that is not ready for query");
            return item;
        });
    }

    public Try<PostgreSQLConnection> test(PostgreSQLConnection item) {
        Try try_;
        Try result = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Await$.MODULE$.result(item.sendQuery("SELECT 0"), this.configuration().testTimeout());
            return item;
        });
        Try try_2 = result;
        if (try_2 instanceof Failure) {
            BoxedUnit boxedUnit;
            try {
                boxedUnit = item.isConnected() ? item.disconnect() : BoxedUnit.UNIT;
            }
            catch (Exception e) {
                PostgreSQLConnectionFactory$.MODULE$.log().error("Failed disconnecting object", (Throwable)e);
                boxedUnit = BoxedUnit.UNIT;
            }
            try_ = result;
        } else if (try_2 instanceof Success) {
            try_ = result;
        } else {
            throw new MatchError((Object)try_2);
        }
        return try_;
    }

    public PostgreSQLConnectionFactory(Configuration configuration, ExecutionContext executionContext) {
        this.configuration = configuration;
        this.executionContext = executionContext;
        ObjectFactory.$init$((ObjectFactory)this);
    }
}

