/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql.util;

import com.github.mauricio.async.db.postgresql.exceptions.InvalidArrayException;
import com.github.mauricio.async.db.postgresql.util.ArrayStreamingParserDelegate;
import com.github.mauricio.async.db.util.Log$;
import org.slf4j.Logger;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class ArrayStreamingParser$ {
    public static final ArrayStreamingParser$ MODULE$ = new ArrayStreamingParser$();
    private static final Logger log = Log$.MODULE$.getByName(MODULE$.getClass().getName());

    public Logger log() {
        return log;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parse(String content, ArrayStreamingParserDelegate delegate) {
        boolean escaping = false;
        boolean quoted = false;
        StringBuilder currentElement = null;
        int opens = 0;
        int closes = 0;
        block7: for (int index = 0; index < StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(content)); ++index) {
            BoxedUnit boxedUnit;
            char c = content.charAt(index);
            if (escaping) {
                currentElement.append(c);
                escaping = false;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            char c2 = c;
            switch (c2) {
                case '{': {
                    if (quoted) break;
                    delegate.arrayStarted();
                    ++opens;
                    boxedUnit = BoxedUnit.UNIT;
                    continue block7;
                }
                case '}': {
                    if (quoted) break;
                    if (currentElement != null) {
                        this.sendElementEvent(currentElement, quoted, delegate);
                        currentElement = null;
                    }
                    delegate.arrayEnded();
                    ++closes;
                    boxedUnit = BoxedUnit.UNIT;
                    continue block7;
                }
                case '\"': {
                    if (quoted) {
                        this.sendElementEvent(currentElement, quoted, delegate);
                        currentElement = null;
                        quoted = false;
                    } else {
                        quoted = true;
                        currentElement = new StringBuilder();
                    }
                    boxedUnit = BoxedUnit.UNIT;
                    continue block7;
                }
                case ',': {
                    if (quoted) break;
                    if (currentElement != null) {
                        this.sendElementEvent(currentElement, quoted, delegate);
                    }
                    currentElement = null;
                    boxedUnit = BoxedUnit.UNIT;
                    continue block7;
                }
                case '\\': {
                    escaping = true;
                    boxedUnit = BoxedUnit.UNIT;
                    continue block7;
                }
            }
            if (currentElement == null) {
                currentElement = new StringBuilder();
            }
            boxedUnit = currentElement.append(c);
        }
        if (opens != closes) {
            throw new InvalidArrayException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("This array is unbalanced %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{content})));
        }
    }

    public void sendElementEvent(StringBuilder builder, boolean quoted, ArrayStreamingParserDelegate delegate) {
        String value = builder.toString();
        if (!quoted && "NULL".equalsIgnoreCase(value)) {
            delegate.nullElementFound();
        } else {
            delegate.elementFound(value);
        }
    }

    private ArrayStreamingParser$() {
    }
}

