/*
 * Decompiled with CFR 0.152.
 */
package com.driver733.vkuploader.media;

import com.driver733.vkuploader.media.Media;
import com.driver733.vkuploader.media.MediaSingle;
import com.driver733.vkuploader.post.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;

@SuppressFBWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE"}, justification="This is done on purpose.")
public final class MediaRandom
implements Media,
MediaSingle {
    private final Media origin;
    private final long seed;

    public MediaRandom(Media origin, long seed) {
        this.origin = origin;
        this.seed = seed;
    }

    public MediaRandom(Media origin) {
        this(origin, new Random().nextLong());
    }

    public MediaRandom(long seed, final Path ... files) {
        this(new Media(){

            @Override
            public List<Path> files() {
                return Arrays.asList(files);
            }
        }, seed);
    }

    public MediaRandom(final Path ... files) {
        this(new Media(){

            @Override
            public List<Path> files() {
                return Arrays.asList(files);
            }
        }, new Random().nextLong());
    }

    @Override
    public Path file() throws IOException {
        return this.files().get(0);
    }

    @Override
    public List<Path> files() throws IOException {
        ArrayList<Path> result = new ArrayList<Path>(this.origin.files());
        Collections.shuffle(result, new Random(this.seed));
        return result;
    }
}

