/*
 * Decompiled with CFR 0.152.
 */
package com.driver733.vkuploader.post;

import com.driver733.vkuploader.post.Entrance;
import com.driver733.vkuploader.post.posts.Posts;
import com.jcabi.aspects.Immutable;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cactoos.list.StickyList;

@Immutable
public final class EntranceDirectory
implements Entrance {
    private final List<Path> dirs;
    private final Posts posts;
    private final WatchService watcher;
    private final Map<WatchKey, Path> keys;

    public EntranceDirectory(Posts posts, Path ... dirs) throws IOException {
        this.posts = posts;
        this.dirs = new StickyList((Object[])dirs);
        this.keys = new HashMap<WatchKey, Path>();
        this.watcher = FileSystems.getDefault().newWatchService();
    }

    @Override
    public void start() throws Exception {
        for (Path dir : this.dirs) {
            this.posts.postFromDir(dir).post();
            this.registerDirectory(dir);
        }
        this.processEvents();
    }

    private void processEvents() throws Exception {
        while (true) {
            WatchKey key = this.watcher.take();
            Path dir = this.keys.get(key);
            this.processSubevents(key, dir);
            this.posts.postFromDir(dir).post();
        }
    }

    private void processSubevents(WatchKey key, Path dir) throws IOException {
        for (WatchEvent<?> event : key.pollEvents()) {
            WatchEvent.Kind<?> kind = event.kind();
            Path name = (Path)event.context();
            Path child = dir.resolve(name);
            Logger.debug((Object)this, (String)"%s: %s%n", (Object[])new Object[]{event.kind().name(), child});
            if (kind != StandardWatchEventKinds.ENTRY_CREATE || !Files.isDirectory(child, new LinkOption[0])) continue;
            this.processSubevents(child);
        }
    }

    private void registerDirectory(Path dir) throws IOException {
        WatchKey key = dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.keys.put(key, dir);
    }

    private void processSubevents(Path root) throws IOException {
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path subdir, BasicFileAttributes attrs) throws IOException {
                EntranceDirectory.this.registerDirectory(subdir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

