/*
 * Decompiled with CFR 0.152.
 */
package com.driver733.vkuploader.wallpost.attachment;

import com.driver733.vkuploader.post.SuppressFBWarnings;
import com.driver733.vkuploader.wallpost.PropsFile;
import com.driver733.vkuploader.wallpost.attachment.Attachment;
import com.driver733.vkuploader.wallpost.attachment.AttachmentAddAudio;
import com.driver733.vkuploader.wallpost.attachment.AttachmentAudioWithProps;
import com.driver733.vkuploader.wallpost.attachment.upload.UploadAudio;
import com.jcabi.aspects.Immutable;
import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.TransportClient;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.httpclient.TransportClientCached;
import com.vk.api.sdk.queries.audio.AudioAddQuery;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@Immutable
@SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="If path exists then NP will not occur.")
public final class AttachmentCachedAudio
implements Attachment {
    private final int group;
    private final VkApiClient client;
    private final UserActor actor;
    private final List<Path> audios;
    private final String url;
    private final PropsFile properties;

    public AttachmentCachedAudio(VkApiClient client, UserActor actor, String url, PropsFile properties, List<Path> audios, int group) {
        this.client = client;
        this.audios = audios;
        this.actor = actor;
        this.url = url;
        this.properties = properties;
        this.group = group;
    }

    @Override
    public List<AbstractQueryBuilder> upload() throws Exception {
        ArrayList<AbstractQueryBuilder> list = new ArrayList<AbstractQueryBuilder>(this.audios.size());
        for (Path audio : this.audios) {
            list.addAll(this.upload(audio));
        }
        return list;
    }

    private List<AbstractQueryBuilder> upload(Path audio) throws Exception {
        List<AbstractQueryBuilder> result;
        if (this.properties.property(audio.getFileName().toString()) == null) {
            result = new AttachmentAudioWithProps(this.client, this.actor, this.properties, this.group, new UploadAudio(this.client, this.url, audio)).upload();
        } else {
            String value = this.properties.property(audio.getFileName().toString());
            int status = Integer.parseInt(value.substring(0, StringUtils.ordinalIndexOf((CharSequence)value, (CharSequence)"_", (int)1)));
            if (status == 0) {
                Integer ownerId = Integer.parseInt(value.substring(StringUtils.ordinalIndexOf((CharSequence)value, (CharSequence)"_", (int)1) + 1, StringUtils.ordinalIndexOf((CharSequence)value, (CharSequence)"_", (int)2)));
                int mediaId = Integer.parseInt(value.substring(StringUtils.ordinalIndexOf((CharSequence)value, (CharSequence)"_", (int)2) + 1));
                result = new AttachmentAddAudio(this.client, this.actor, ownerId, mediaId, this.group).upload();
            } else if (status == 1) {
                String mediaId = value.substring(StringUtils.ordinalIndexOf((CharSequence)value, (CharSequence)"_", (int)1) + 1);
                AudioAddQuery query = new AudioAddQuery(new VkApiClient((TransportClient)new TransportClientCached(String.format("{ \"response\" : %s }", mediaId))), new UserActor(Integer.valueOf(0), ""), 0, 0);
                result = Collections.singletonList(query);
            } else {
                throw new IOException("Invalid audios status");
            }
        }
        return result;
    }
}

