/*
 * Decompiled with CFR 0.152.
 */
package com.driver733.vkuploader.wallpost.attachment.support;

import com.driver733.vkuploader.wallpost.PropsFile;
import com.driver733.vkuploader.wallpost.attachment.support.AudioStatus;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.jcabi.aspects.Immutable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@Immutable
public final class PropertiesUpdate
implements Runnable {
    private final PropsFile properties;
    private final Map<Integer, String> ids;
    private final JsonArray root;

    public PropertiesUpdate(PropsFile properties, Map<Integer, String> ids, JsonArray root) {
        this.properties = properties;
        this.ids = ids;
        this.root = root;
    }

    @Override
    public void run() {
        Map<Integer, String> results = this.resStrings();
        for (int index : this.ids.keySet()) {
            try {
                this.properties.with(this.key(index).toString(), String.format("%s_%s", AudioStatus.ADDED.toString(), results.get(index)));
            }
            catch (IOException ex) {
                throw new IllegalStateException("PropertiesUpdate key not found", ex);
            }
        }
    }

    private Object key(int index) throws IOException {
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            String value = entry.getValue();
            if (!Objects.equals(this.ids.get(index), value.substring(StringUtils.ordinalIndexOf((CharSequence)value, (CharSequence)"_", (int)2) + 1))) continue;
            return entry.getKey();
        }
        throw new IOException("Key not found.");
    }

    private Map<Integer, String> resStrings() {
        ArrayList<Integer> integers = new ArrayList<Integer>(this.ids.keySet());
        HashMap<Integer, String> results = new HashMap<Integer, String>();
        int index = 0;
        for (JsonElement element : this.root) {
            if (!element.isJsonPrimitive()) continue;
            results.put((Integer)integers.get(index), String.valueOf(element.getAsInt()));
            ++index;
        }
        return results;
    }
}

