/*
 * Decompiled with CFR 0.152.
 */
package com.driver733.vkuploader.wallpost.attachment.support;

import com.jcabi.aspects.Immutable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.cactoos.Input;
import org.cactoos.io.BytesOf;
import org.cactoos.io.InputOf;

@Immutable
public final class Zipped
implements Input {
    private final Path directory;

    public Zipped(Path directory) {
        this.directory = directory;
    }

    public InputStream stream() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(out);){
            List paths = Files.walk(this.directory, new FileVisitOption[0]).filter(dirr -> !Files.isDirectory(dirr, new LinkOption[0])).collect(Collectors.toList());
            for (Path path : paths) {
                ZipEntry entry = new ZipEntry(this.directory.relativize(path).toString());
                zos.putNextEntry(entry);
                zos.write(new BytesOf((Input)new InputOf(path)).asBytes());
                zos.closeEntry();
            }
            zos.flush();
            zos.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
            return byteArrayInputStream;
        }
    }
}

