/*
 * Decompiled with CFR 0.152.
 */
package com.driver733.vkuploader.wallpost.attachment.support.string;

import com.driver733.vkuploader.wallpost.attachment.support.string.AttachmentString;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jcabi.aspects.Immutable;
import java.io.IOException;

@Immutable
public final class AttachmentStringFromJson
implements AttachmentString {
    private final int group;
    private final JsonElement element;

    public AttachmentStringFromJson(JsonElement element, int group) {
        this.element = element;
        this.group = group;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String attachmentString() throws IOException {
        if (this.element.isJsonPrimitive()) {
            return String.format("%s%d_%d", new Object[]{AttachmentType.AUDIO, -this.group, this.element.getAsInt()});
        }
        if (!this.element.isJsonObject()) throw new IOException("Unknown AttachmentFormat");
        JsonObject object = this.element.getAsJsonObject();
        if (object.has("artist")) {
            return String.format("%s%d_%d", AttachmentType.AUDIO.toString(), object.get("owner_id").getAsInt(), object.get("id").getAsInt());
        }
        if (object.has("photo_75")) {
            return String.format("%s%d_%d", new Object[]{AttachmentType.PHOTO, object.get("owner_id").getAsInt(), object.get("id").getAsInt()});
        }
        if (!object.has("ext")) throw new IOException("Unknown AttachmentFormat");
        return String.format("%s%d_%d", new Object[]{AttachmentType.DOC, object.get("owner_id").getAsInt(), object.get("id").getAsInt()});
    }

    private static enum AttachmentType {
        PHOTO("photo"),
        VIDEO("video"),
        AUDIO("audio"),
        DOC("doc"),
        PAGE("page"),
        NOTE("note"),
        POLL("poll"),
        ALBUM("album");

        private final String type;

        private AttachmentType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

