/*
 * Decompiled with CFR 0.152.
 */
package com.driver733.vkuploader.wallpost.attachment.upload;

import com.driver733.vkuploader.wallpost.attachment.upload.Upload;
import com.jcabi.aspects.Immutable;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.objects.photos.responses.WallUploadResponse;
import com.vk.api.sdk.queries.upload.UploadPhotoWallQuery;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.cactoos.Bytes;
import org.cactoos.io.BytesOf;

@Immutable
public final class UploadWallPhoto
implements Upload<UploadPhotoWallQuery, WallUploadResponse> {
    private final VkApiClient client;
    private final String url;
    private final Bytes photo;

    public UploadWallPhoto(VkApiClient client, String url, Bytes photo) {
        this.client = client;
        this.url = url;
        this.photo = photo;
    }

    public UploadWallPhoto(VkApiClient client, String url, byte[] photo) {
        this(client, url, () -> photo);
    }

    public UploadWallPhoto(VkApiClient client, String url, File photo) {
        this(client, url, (Bytes)new BytesOf(photo));
    }

    public UploadWallPhoto(VkApiClient client, String url, Path photo) {
        this(client, url, (Bytes)new BytesOf(photo));
    }

    public UploadPhotoWallQuery query() throws Exception {
        Path path;
        try {
            path = Files.write(File.createTempFile("albumCover", ".jpg").toPath(), this.photo.asBytes(), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new IOException("Failed to save album cover from byte array to file", ex);
        }
        path.toFile().deleteOnExit();
        return this.client.upload().photoWall(this.url, path.toFile());
    }
}

