/*
 * Decompiled with CFR 0.152.
 */
package com.driver733.vkuploader.wallpost.wallposts;

import com.driver733.vkuploader.media.AudiosNonProcessed;
import com.driver733.vkuploader.media.MediaAudiosBasic;
import com.driver733.vkuploader.post.SuppressFBWarnings;
import com.driver733.vkuploader.post.UploadServersBasic;
import com.driver733.vkuploader.wallpost.PropsFile;
import com.driver733.vkuploader.wallpost.WallPostMusicAlbum;
import com.driver733.vkuploader.wallpost.attachment.support.AudioStatus;
import com.driver733.vkuploader.wallpost.wallposts.WallPosts;
import com.jcabi.aspects.Cacheable;
import com.jcabi.aspects.Immutable;
import com.jcabi.log.Logger;
import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.queries.execute.ExecuteBatchQuery;
import com.vk.api.sdk.queries.wall.WallPostQuery;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cactoos.list.StickyList;

@Immutable
@SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="If path exists then NP will not occur.")
public final class WallPostsMusicAlbum
implements WallPosts {
    private static final int BATCH_MAX_REQ = 25;
    private static final int PHOTOS_IN_POST = 1;
    private static final int WALL_POST_REQ = 1;
    private static final int MAX_ATTACHMENTS = 10;
    private static final int AUDIOS_IN_REQ = 19;
    private static final int AUDIOS_IN_POST = 9;
    private final int group;
    private final VkApiClient client;
    private final UserActor actor;
    private final Path dir;
    private final UploadServersBasic servers;
    private final PropsFile properties;

    public WallPostsMusicAlbum(VkApiClient client, UserActor actor, Path dir, UploadServersBasic servers, PropsFile properties, int group) {
        this.client = client;
        this.actor = actor;
        this.dir = dir;
        this.servers = servers;
        this.properties = properties;
        this.group = group;
    }

    @Override
    public List<ExecuteBatchQuery> postsQueries() throws Exception {
        List<Path> audios = this.audios();
        ArrayList<ExecuteBatchQuery> queries = new ArrayList<ExecuteBatchQuery>(audios.size());
        Logger.debug((Object)this, (String)"Analyzing directory '%s'...", (Object[])new Object[]{this.dir});
        for (int iter = 0; iter < audios.size(); iter += 19) {
            int to = audios.size() < iter + 19 ? audios.size() - iter : iter + 19;
            queries.add(this.postsBatch(audios.subList(iter, to)));
        }
        Collections.reverse(queries);
        if (queries.isEmpty()) {
            Logger.debug((Object)this, (String)"No audios files to upload. Skipping...");
        }
        return queries;
    }

    @Override
    public void updateProperties() throws IOException {
        List<Path> audios = this.audios();
        for (Path audio : audios) {
            this.properties.with(audio.getFileName().toString(), new StringBuilder(this.properties.property(audio.getFileName().toString())).replace(0, 1, AudioStatus.POSTED.toString()).toString());
        }
    }

    @Cacheable(forever=true)
    private List<Path> audios() throws IOException {
        return new AudiosNonProcessed(new MediaAudiosBasic(this.dir), this.properties).files();
    }

    private ExecuteBatchQuery postsBatch(List<Path> audios) throws Exception {
        Logger.info((Object)this, (String)"Processing directory: '%s'...", (Object[])new Object[]{this.dir});
        ArrayList<WallPostQuery> posts = new ArrayList<WallPostQuery>(audios.size());
        for (int from = 0; from < audios.size(); from += 9) {
            WallPostQuery query;
            int to = audios.size() < from + 9 ? audios.size() : from + 9;
            try {
                query = new WallPostMusicAlbum(this.client, this.actor, (List<Path>)new StickyList(audios.subList(from, to)), this.servers, this.properties, this.group).construct();
            }
            catch (IOException ex) {
                throw new IOException("Failed to obtain a WallPost query", ex);
            }
            posts.add(query);
        }
        Collections.reverse(posts);
        return new ExecuteBatchQuery(this.client, this.actor, (AbstractQueryBuilder[])posts.toArray(new WallPostQuery[0]));
    }
}

