/*
 * Decompiled with CFR 0.152.
 */
package com.driver733.vkuploader.wallpost.wallposts;

import com.driver733.vkuploader.media.photo.MediaPhotosBasic;
import com.driver733.vkuploader.media.photo.MediaPhotosNonProcessed;
import com.driver733.vkuploader.post.SuppressFBWarnings;
import com.driver733.vkuploader.post.UploadServersBasic;
import com.driver733.vkuploader.wallpost.PropsFile;
import com.driver733.vkuploader.wallpost.WallPostPhotoAlbum;
import com.driver733.vkuploader.wallpost.attachment.support.WallPhotoStatus;
import com.driver733.vkuploader.wallpost.wallposts.WallPosts;
import com.jcabi.aspects.Cacheable;
import com.jcabi.aspects.Immutable;
import com.jcabi.log.Logger;
import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.queries.execute.ExecuteBatchQuery;
import com.vk.api.sdk.queries.wall.WallPostQuery;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.cactoos.list.StickyList;

@Immutable
@SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="If path exists then NP will not occur.")
public final class WallPostsPhotoAlbum
implements WallPosts {
    private static final int BATCH_MAX_REQ = 25;
    private static final int PHOTOS_IN_POST = 10;
    private static final int WALL_POST_REQ = 1;
    private static final int PHOTOS_IN_REQ = 22;
    private final int group;
    private final VkApiClient client;
    private final UserActor actor;
    private final Path dir;
    private final UploadServersBasic servers;
    private final PropsFile properties;

    public WallPostsPhotoAlbum(VkApiClient client, UserActor actor, Path dir, UploadServersBasic servers, PropsFile properties, int group) {
        this.client = client;
        this.actor = actor;
        this.dir = dir;
        this.servers = servers;
        this.properties = properties;
        this.group = group;
    }

    @Override
    public List<ExecuteBatchQuery> postsQueries() throws Exception {
        List<Path> photos = this.photos();
        ArrayList<ExecuteBatchQuery> queries = new ArrayList<ExecuteBatchQuery>(photos.size());
        Logger.debug((Object)this, (String)"Analyzing directory '%s'...", (Object[])new Object[]{this.dir});
        for (int iter = 0; iter < photos.size(); iter += 22) {
            int to = photos.size() < iter + 22 ? photos.size() - iter : iter + 22;
            queries.add(this.postsBatch(photos.subList(iter, to)));
        }
        if (queries.isEmpty()) {
            Logger.debug((Object)this, (String)"No photos to upload. Skipping...");
        }
        return queries;
    }

    @Override
    public void updateProperties() throws IOException {
        List<Path> photos = this.photos();
        for (Path photo : photos) {
            this.properties.with(photo.getFileName().toString(), WallPhotoStatus.POSTED.toString());
        }
    }

    @Cacheable(forever=true)
    private List<Path> photos() throws IOException {
        return new MediaPhotosNonProcessed(new MediaPhotosBasic(this.dir), this.properties).files();
    }

    private ExecuteBatchQuery postsBatch(List<Path> photos) throws Exception {
        Logger.info((Object)this, (String)"Processing directory: '%s'...", (Object[])new Object[]{this.dir});
        ArrayList<WallPostQuery> posts = new ArrayList<WallPostQuery>(photos.size());
        for (int from = 0; from < photos.size(); from += 10) {
            WallPostQuery query;
            int to = photos.size() < from + 10 ? photos.size() : from + 10;
            try {
                query = new WallPostPhotoAlbum(this.client, this.actor, (List<Path>)new StickyList(photos.subList(from, to)), this.servers, this.group).construct();
            }
            catch (IOException ex) {
                throw new IOException("Failed to obtain a WallPost query", ex);
            }
            posts.add(query);
        }
        return new ExecuteBatchQuery(this.client, this.actor, (AbstractQueryBuilder[])posts.toArray(new WallPostQuery[0]));
    }
}

