/*
 * Decompiled with CFR 0.152.
 */
package com.driver733.vkuploader.wallpost.wallposts;

import com.driver733.vkuploader.media.Media;
import com.driver733.vkuploader.media.MediaAudiosBasic;
import com.driver733.vkuploader.media.MediaEmpty;
import com.driver733.vkuploader.media.MediaRandom;
import com.driver733.vkuploader.media.photo.MediaPhotosBasic;
import com.driver733.vkuploader.post.SuppressFBWarnings;
import com.driver733.vkuploader.post.UploadServersBasic;
import com.driver733.vkuploader.wallpost.PropsFile;
import com.driver733.vkuploader.wallpost.WallPostRandom;
import com.driver733.vkuploader.wallpost.attachment.support.AudioStatus;
import com.driver733.vkuploader.wallpost.attachment.support.WallPhotoStatus;
import com.driver733.vkuploader.wallpost.wallposts.WallPosts;
import com.jcabi.aspects.Immutable;
import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.queries.execute.ExecuteBatchQuery;
import com.vk.api.sdk.queries.wall.WallPostQuery;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Immutable
@SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="If path exists then NP will not occur.")
public final class WallPostsRandom
implements WallPosts {
    private static final int BATCH_MAX_REQ = 25;
    private static final int SEED = 123456;
    private final int group;
    private final VkApiClient client;
    private final UserActor actor;
    private final Media photos;
    private final Media audios;
    private final UploadServersBasic servers;
    private final PropsFile properties;

    public WallPostsRandom(VkApiClient client, UserActor actor, UploadServersBasic servers, PropsFile properties, int group, Path photos) {
        this.client = client;
        this.actor = actor;
        this.servers = servers;
        this.group = group;
        this.properties = properties;
        this.photos = new MediaRandom(new MediaPhotosBasic(photos), 123456L);
        this.audios = new MediaEmpty();
    }

    public WallPostsRandom(VkApiClient client, UserActor actor, UploadServersBasic servers, PropsFile properties, Path audios, int group) {
        this.client = client;
        this.actor = actor;
        this.servers = servers;
        this.group = group;
        this.properties = properties;
        this.photos = new MediaEmpty();
        this.audios = new MediaRandom(new MediaAudiosBasic(audios), 123456L);
    }

    public WallPostsRandom(VkApiClient client, UserActor actor, UploadServersBasic servers, PropsFile properties, int group, Path photos, Path audios) {
        this.client = client;
        this.actor = actor;
        this.properties = properties;
        this.servers = servers;
        this.group = group;
        this.photos = new MediaRandom(new MediaPhotosBasic(photos), 123456L);
        this.audios = new MediaRandom(new MediaAudiosBasic(audios), 123456L);
    }

    @Override
    public List<ExecuteBatchQuery> postsQueries() throws Exception {
        int num;
        int left;
        Iterator<Path> audio = this.audios.files().iterator();
        Iterator<Path> photo = this.photos.files().iterator();
        ArrayList<ExecuteBatchQuery> result = new ArrayList<ExecuteBatchQuery>(left);
        for (left = this.numberOfFilesToProcess(); left > 0; left -= num) {
            num = left > 25 ? 25 : left;
            ArrayList<WallPostQuery> posts = new ArrayList<WallPostQuery>(num);
            for (int iter = 0; !(iter >= num || this.photos.files().isEmpty() && this.audios.files().isEmpty()); ++iter) {
                WallPostQuery query = this.audios.files().isEmpty() ? new WallPostRandom(this.client, this.actor, this.servers, photo.next(), this.properties, this.group).construct() : (this.photos.files().isEmpty() ? new WallPostRandom(this.client, this.actor, this.servers, this.group, this.properties, audio.next()).construct() : new WallPostRandom(this.client, this.actor, this.servers, this.group, this.properties, photo.next(), audio.next()).construct());
                posts.add(query);
            }
            result.add(new ExecuteBatchQuery(this.client, this.actor, (AbstractQueryBuilder[])posts.toArray(new WallPostQuery[0])));
        }
        return result;
    }

    @Override
    public void updateProperties() throws IOException {
        List<Path> images = this.photos.files();
        int nphotos = Math.min(this.numberOfFilesToProcess(), images.size());
        for (int iter = 0; iter < nphotos; ++iter) {
            this.properties.with(images.get(iter).getFileName().toString(), WallPhotoStatus.POSTED.toString());
        }
        List<Path> audioss = this.audios.files();
        int naudios = Math.min(this.numberOfFilesToProcess(), audioss.size());
        for (int iter = 0; iter < naudios; ++iter) {
            Path audio = audioss.get(iter);
            this.properties.with(audio.getFileName().toString(), new StringBuilder(this.properties.property(audio.getFileName().toString())).replace(0, 1, AudioStatus.POSTED.toString()).toString());
        }
    }

    private int numberOfFilesToProcess() throws IOException {
        int left = this.audios.files().isEmpty() ? this.photos.files().size() : (this.photos.files().isEmpty() ? this.audios.files().size() : Math.min(this.audios.files().size(), this.photos.files().size()));
        return left;
    }
}

