/*
 * Decompiled with CFR 0.152.
 */
package com.driver733.vkuploader.wallpost.wallposts;

import com.driver733.vkuploader.media.Media;
import com.driver733.vkuploader.media.MediaAudiosBasic;
import com.driver733.vkuploader.media.MediaEmpty;
import com.driver733.vkuploader.media.MediaRandom;
import com.driver733.vkuploader.media.photo.MediaPhotosBasic;
import com.driver733.vkuploader.post.UploadServersBasic;
import com.driver733.vkuploader.wallpost.WallPostWithRandomQuote;
import com.driver733.vkuploader.wallpost.attachment.upload.TransportClientFake;
import com.driver733.vkuploader.wallpost.wallposts.WallPosts;
import com.jcabi.aspects.Immutable;
import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.TransportClient;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.queries.execute.ExecuteBatchQuery;
import com.vk.api.sdk.queries.wall.WallPostQuery;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

@Immutable
public final class WallPostsRandomQuote
implements WallPosts {
    private static final int BATCH_MAX_REQ = 25;
    private final int group;
    private final VkApiClient client;
    private final UserActor actor;
    private final Media photos;
    private final Media audios;
    private final UploadServersBasic servers;
    private final int count;

    public WallPostsRandomQuote(VkApiClient client, UserActor actor, int group, int count) {
        this.client = client;
        this.actor = actor;
        this.servers = new UploadServersBasic(new VkApiClient((TransportClient)new TransportClientFake()), new UserActor(Integer.valueOf(0), ""), 0);
        this.photos = new MediaEmpty();
        this.audios = new MediaEmpty();
        this.group = group;
        this.count = count;
    }

    public WallPostsRandomQuote(VkApiClient client, UserActor actor, UploadServersBasic servers, int group, int count, Path photos) {
        this.client = client;
        this.actor = actor;
        this.servers = servers;
        this.group = group;
        this.count = count;
        this.photos = new MediaPhotosBasic(photos);
        this.audios = new MediaEmpty();
    }

    public WallPostsRandomQuote(VkApiClient client, UserActor actor, UploadServersBasic servers, int group, Path audios, int count) {
        this.client = client;
        this.actor = actor;
        this.servers = servers;
        this.group = group;
        this.count = count;
        this.photos = new MediaEmpty();
        this.audios = new MediaAudiosBasic(audios);
    }

    public WallPostsRandomQuote(VkApiClient client, UserActor actor, UploadServersBasic servers, int group, int count, Path photos, Path audios) {
        this.client = client;
        this.actor = actor;
        this.group = group;
        this.servers = servers;
        this.count = count;
        this.photos = new MediaPhotosBasic(photos);
        this.audios = new MediaAudiosBasic(audios);
    }

    @Override
    public List<ExecuteBatchQuery> postsQueries() throws Exception {
        int num;
        int left;
        ArrayList<ExecuteBatchQuery> result = new ArrayList<ExecuteBatchQuery>(left);
        for (left = this.count; left > 0; left -= num) {
            num = left > 25 ? 25 : left;
            if (this.photos.files().isEmpty() && this.audios.files().isEmpty()) {
                result.add(this.posts(num, new WallPostWithRandomQuote(this.client, this.actor, this.group)));
                continue;
            }
            if (this.audios.files().isEmpty()) {
                result.add(this.posts(num, new WallPostWithRandomQuote(this.client, this.actor, this.servers, new MediaRandom(this.photos).file(), this.group)));
                continue;
            }
            if (this.photos.files().isEmpty()) {
                result.add(this.posts(num, new WallPostWithRandomQuote(this.client, this.actor, this.servers, this.group, new MediaRandom(this.audios).file())));
                continue;
            }
            result.add(this.posts(num, new WallPostWithRandomQuote(this.client, this.actor, this.servers, this.group, new MediaRandom(this.photos).file(), new MediaRandom(this.audios).file())));
        }
        return result;
    }

    @Override
    public void updateProperties() {
        throw new UnsupportedOperationException("All used resources are random.");
    }

    private ExecuteBatchQuery posts(int num, WallPostWithRandomQuote wallpost) throws Exception {
        ArrayList<WallPostQuery> queries = new ArrayList<WallPostQuery>(25);
        for (int iter = 0; iter < num; ++iter) {
            queries.add(wallpost.construct());
            TimeUnit.SECONDS.sleep(2L);
        }
        return new ExecuteBatchQuery(this.client, this.actor, (AbstractQueryBuilder[])queries.toArray(new WallPostQuery[0]));
    }
}

