/*
 * Decompiled with CFR 0.152.
 */
package brainslug.juel;

import brainslug.flow.context.ExecutionContext;
import brainslug.flow.execution.expression.DefaultExpressionEvaluator;
import brainslug.flow.execution.instance.FlowInstanceProperty;
import brainslug.flow.expression.Expression;
import brainslug.juel.JuelExpression;
import de.odysseus.el.ExpressionFactoryImpl;
import de.odysseus.el.util.SimpleContext;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;

public class JuelExpressionEvaluator
extends DefaultExpressionEvaluator {
    public <T> T evaluate(Expression expression, ExecutionContext context, Class<T> resultType) {
        if (expression instanceof JuelExpression) {
            return this.evaluateJuel(((JuelExpression)expression).getString(), context, resultType);
        }
        return (T)super.evaluate(expression, context, resultType);
    }

    private <T> T evaluateJuel(String juelExpression, ExecutionContext context, Class<T> resultType) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext juelContext = new SimpleContext();
        for (FlowInstanceProperty property : context.getProperties().values()) {
            juelContext.setVariable(property.getKey(), this.valueExpression(property, (ExpressionFactory)factory));
        }
        return (T)factory.createValueExpression((ELContext)juelContext, juelExpression, resultType).getValue((ELContext)juelContext);
    }

    private ValueExpression valueExpression(FlowInstanceProperty<?> property, ExpressionFactory factory) {
        if (property.getValue() instanceof String) {
            return factory.createValueExpression(property.getValue(), String.class);
        }
        if (property.getValue() instanceof Number) {
            return factory.createValueExpression(property.getValue(), Number.class);
        }
        return factory.createValueExpression(property.getValue(), property.getClass());
    }
}

