/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.differ;

import com.dropbox.differ.Color;
import com.dropbox.differ.ColorKt;
import com.dropbox.differ.Image;
import com.dropbox.differ.ImageComparator;
import com.dropbox.differ.Mask;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/dropbox/differ/SimpleImageComparator;", "Lcom/dropbox/differ/ImageComparator;", "maxDistance", "", "hShift", "", "vShift", "(FII)V", "getHShift", "()I", "getMaxDistance", "()F", "getVShift", "compare", "Lcom/dropbox/differ/ImageComparator$ComparisonResult;", "left", "Lcom/dropbox/differ/Image;", "right", "mask", "Lcom/dropbox/differ/Mask;", "differ"})
public final class SimpleImageComparator
implements ImageComparator {
    private final float maxDistance;
    private final int hShift;
    private final int vShift;

    public SimpleImageComparator(float maxDistance, int hShift, int vShift) {
        this.maxDistance = maxDistance;
        this.hShift = hShift;
        this.vShift = vShift;
    }

    public /* synthetic */ SimpleImageComparator(float f, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            f = 0.1f;
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        this(f, n, n2);
    }

    public final float getMaxDistance() {
        return this.maxDistance;
    }

    public final int getHShift() {
        return this.hShift;
    }

    public final int getVShift() {
        return this.vShift;
    }

    @Override
    @NotNull
    public ImageComparator.ComparisonResult compare(@NotNull Image left, @NotNull Image right, @Nullable Mask mask) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        int width = Math.max(left.getWidth(), right.getWidth());
        int height = Math.max(left.getHeight(), right.getHeight());
        int misses = 0;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)width);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int x = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            Iterable $this$forEach$iv2 = (Iterable)RangesKt.until((int)0, (int)height);
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                Color rightColor;
                int element$iv2;
                int y = element$iv2 = ((IntIterator)iterator2).nextInt();
                boolean bl2 = false;
                Color leftColor = left.getPixel(x, y);
                float delta = ColorKt.distance(leftColor, rightColor = right.getPixel(x, y));
                if (delta > this.getMaxDistance() && !SimpleImageComparator.compare$compareWindow(this, height, width, left, right, x, y, leftColor)) {
                    int n = misses;
                    misses = n + 1;
                }
                Mask mask2 = mask;
                if (mask2 == null) continue;
                mask2.setValue(x, y, delta);
            }
        }
        return new ImageComparator.ComparisonResult(misses, width * height, width, height);
    }

    private static final boolean compare$compareWindow(SimpleImageComparator this$0, int height, int width, Image $left, Image $right, int x, int y, Color color) {
        if (this$0.hShift == 0 && this$0.vShift == 0) {
            return false;
        }
        int l = Math.max(x - this$0.hShift, 0);
        int t = Math.min(y + this$0.vShift, height - 1);
        int r = Math.min(x + this$0.hShift, width - 1);
        int b = Math.max(y - this$0.vShift, 0);
        Iterable $this$forEach$iv = (Iterable)new IntRange(l, r);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int offsetX = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            Iterable $this$forEach$iv2 = (Iterable)new IntRange(b, t);
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                int element$iv2;
                int offsetY = element$iv2 = ((IntIterator)iterator2).nextInt();
                boolean bl2 = false;
                if (offsetX == x && offsetY == y) continue;
                Color c1 = $left.getPixel(offsetX, offsetY);
                float localDeltaThreshold = ColorKt.distance(color, c1);
                Color c2 = $right.getPixel(offsetX, offsetY);
                float localDelta = ColorKt.distance(color, c2);
                if (!(Math.abs(localDelta - localDeltaThreshold) < this$0.getMaxDistance()) || !(localDeltaThreshold > this$0.getMaxDistance())) continue;
                return true;
            }
        }
        return false;
    }

    public SimpleImageComparator() {
        this(0.0f, 0, 0, 7, null);
    }
}

