/*
 * Decompiled with CFR 0.152.
 */
package com.dropsnorz.showcasefx;

import com.dropsnorz.showcasefx.ShowcaseStep;
import com.dropsnorz.showcasefx.StepBuilder;
import com.dropsnorz.showcasefx.events.ShowcaseEvent;
import com.dropsnorz.showcasefx.layers.ShowcaseLayer;
import com.dropsnorz.showcasefx.layers.ShowcaseLayerShape;
import com.dropsnorz.showcasefx.layouts.AutoShowcaseLayout;
import com.dropsnorz.showcasefx.layouts.ShowcaseLayout;
import com.dropsnorz.showcasefx.views.SimpleStepView;
import java.util.ArrayList;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class Showcase
extends StackPane {
    protected StackPane showcaseContainer;
    protected Pane layerPane;
    protected ShowcaseLayout defaultLayout;
    protected ShowcaseLayer defaultLayer;
    protected ArrayList<ShowcaseStep> steps;
    protected int currentStep;
    protected ChangeListener<Bounds> boundsListener;
    protected EventHandler<MouseEvent> clickHandler;
    protected Node currentLayoutNode;
    private Node mountedTarget;
    private ShowcaseLayer mountedLayer;
    private ShowcaseLayout mountedLayout;
    protected ShowcaseBehaviour onClickBehaviour = ShowcaseBehaviour.NEXT;
    protected boolean updateOnTargetBoundsChange = true;
    private FadeTransition fadeIn;
    private FadeTransition fadeOut;
    private static final String DEFAULT_STYLE_CLASS = "showcase";
    private static final String CONTENT_STYLE_CLASS = "showcase-step-content";
    private ObjectProperty<EventHandler<? super ShowcaseEvent>> onShowcaseStartedProperty;
    private ObjectProperty<EventHandler<? super ShowcaseEvent>> onShowcaseStoppedProperty;
    private ObjectProperty<EventHandler<? super ShowcaseEvent>> onShowcaseStepDisplayProperty;

    public Showcase() {
        this.onShowcaseStartedProperty = new SimpleObjectProperty(started -> {});
        this.onShowcaseStoppedProperty = new SimpleObjectProperty(stopped -> {});
        this.onShowcaseStepDisplayProperty = new SimpleObjectProperty(stopped -> {});
        this.initialize();
    }

    public Showcase(StackPane showCaseContainer) {
        this.onShowcaseStartedProperty = new SimpleObjectProperty(started -> {});
        this.onShowcaseStoppedProperty = new SimpleObjectProperty(stopped -> {});
        this.onShowcaseStepDisplayProperty = new SimpleObjectProperty(stopped -> {});
        this.initialize();
        this.setShowcaseContainer(showCaseContainer);
    }

    private void initialize() {
        this.setVisible(false);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.defaultLayout = new AutoShowcaseLayout();
        this.layerPane = new StackPane();
        this.getChildren().add((Object)this.layerPane);
        this.defaultLayer = ShowcaseLayerShape.CIRCLE_FLAT;
        this.currentStep = -1;
        this.steps = new ArrayList();
        this.boundsListener = new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> observableValue, Bounds oldBounds, Bounds newBounds) {
                Showcase.this.updateShowcaseLayer();
            }
        };
        this.clickHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                if (Showcase.this.fadeIn.getStatus() == Animation.Status.RUNNING || Showcase.this.fadeOut.getStatus() == Animation.Status.RUNNING) {
                    Showcase.this.fadeIn.jumpTo("end");
                    Showcase.this.fadeOut.jumpTo("end");
                } else {
                    Showcase.this.processBehaviour(Showcase.this.onClickBehaviour);
                }
            }
        };
        this.layerPane.addEventHandler(MouseEvent.MOUSE_CLICKED, this.clickHandler);
        this.fadeIn = new FadeTransition(Duration.millis((double)500.0), (Node)this);
        this.fadeIn.setFromValue(0.0);
        this.fadeIn.setToValue(1.0);
        this.fadeIn.setCycleCount(1);
        this.fadeOut = new FadeTransition(Duration.millis((double)500.0), (Node)this);
        this.fadeOut.setFromValue(1.0);
        this.fadeOut.setToValue(0.0);
        this.fadeOut.setCycleCount(1);
        this.setPickOnBounds(false);
    }

    public void start() {
        this.setVisible(true);
        this.layoutBoundsProperty().addListener(this.boundsListener);
        this.currentStep = 0;
        if (this.currentStep < this.steps.size()) {
            this.mountStep();
            this.updateShowcaseLayer();
            this.fadeIn.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    ((EventHandler)Showcase.this.onShowcaseStartedProperty.get()).handle((Event)new ShowcaseEvent(ShowcaseEvent.STARTED));
                    ((EventHandler)Showcase.this.onShowcaseStepDisplayProperty.get()).handle((Event)new ShowcaseEvent(ShowcaseEvent.STEP_DISPLAY));
                }
            });
            this.fadeIn.playFromStart();
        }
    }

    public void next() {
        if (this.isStarted()) {
            ++this.currentStep;
            if (this.currentStep < this.steps.size()) {
                this.switchStep();
            } else {
                this.stop();
            }
        } else {
            throw new IllegalStateException("Showcase component must be started");
        }
    }

    public void jumpTo(int stepIndex) {
        if (!this.isStarted() || stepIndex >= this.steps.size() || stepIndex < 0) {
            if (!this.isStarted()) {
                throw new IllegalStateException("Showcase component must be started");
            }
            throw new IndexOutOfBoundsException("Index " + stepIndex + " is out of bounds!");
        }
        this.currentStep = stepIndex;
        this.switchStep();
    }

    public void stop() {
        if (!this.isStarted()) {
            throw new IllegalStateException("Showcase component must be started");
        }
        this.fadeIn.stop();
        this.fadeOut.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Showcase.this.unmountStep();
                Showcase.this.setVisible(false);
                ((EventHandler)Showcase.this.onShowcaseStoppedProperty.get()).handle((Event)new ShowcaseEvent(ShowcaseEvent.STOPPED));
                Showcase.this.layoutBoundsProperty().removeListener(Showcase.this.boundsListener);
                Showcase.this.currentStep = -1;
            }
        });
        this.fadeOut.playFromStart();
    }

    private void switchStep() {
        this.fadeOut.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Showcase.this.showStep();
            }
        });
        this.fadeOut.playFromStart();
    }

    private void showStep() {
        this.mountStep();
        this.updateShowcaseLayer();
        this.fadeIn.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ((EventHandler)Showcase.this.onShowcaseStepDisplayProperty.get()).handle((Event)new ShowcaseEvent(ShowcaseEvent.STEP_DISPLAY));
            }
        });
        this.fadeIn.playFromStart();
    }

    private void mountStep() {
        this.unmountStep();
        ShowcaseStep showcaseStep = this.steps.get(this.currentStep);
        this.mountedTarget = showcaseStep.getTargetNode();
        this.mountedLayer = showcaseStep.getLayer() != null ? showcaseStep.getLayer() : this.defaultLayer;
        this.mountedLayout = showcaseStep.getLayout() != null ? showcaseStep.getLayout() : this.defaultLayout;
        if (this.updateOnTargetBoundsChange) {
            this.mountedTarget.boundsInParentProperty().addListener(this.boundsListener);
        }
    }

    private void unmountStep() {
        if (this.mountedTarget != null) {
            this.mountedTarget.boundsInParentProperty().removeListener(this.boundsListener);
        }
    }

    private synchronized void updateShowcaseLayer() {
        if (this.currentStep < this.steps.size()) {
            this.applyCss();
            this.layout();
            double width = this.getWidth();
            double height = this.getHeight();
            ShowcaseStep showcaseStep = this.steps.get(this.currentStep);
            Bounds targetBounds = this.showcaseContainer.sceneToLocal(this.mountedTarget.localToScene(this.mountedTarget.getBoundsInLocal()));
            this.layerPane.getChildren().clear();
            if (this.mountedLayer != null) {
                Node layerNode = this.mountedLayer.getNode(targetBounds, width, height);
                this.layerPane.getChildren().add((Object)layerNode);
            }
            Node contentNode = showcaseStep.getContent();
            contentNode.getStyleClass().add((Object)CONTENT_STYLE_CLASS);
            if (this.currentLayoutNode != null) {
                this.getChildren().remove((Object)this.currentLayoutNode);
                this.currentLayoutNode.setOnMouseClicked(null);
            }
            this.currentLayoutNode = this.mountedLayout.getNode();
            this.getChildren().add((Object)this.currentLayoutNode);
            this.currentLayoutNode.setOnMouseClicked(this.clickHandler);
            this.mountedLayout.addContentNode(contentNode, targetBounds, width, height);
        }
    }

    private void processBehaviour(ShowcaseBehaviour behaviour) {
        switch (behaviour) {
            case NEXT: {
                this.next();
                break;
            }
            case CLOSE: {
                this.stop();
                break;
            }
        }
    }

    public void setShowcaseContainer(StackPane showcaseContainer) {
        if (showcaseContainer != null) {
            this.showcaseContainer = showcaseContainer;
            if (this.showcaseContainer.getChildren().indexOf((Object)this) == -1 || this.showcaseContainer.getChildren().indexOf((Object)this) != this.showcaseContainer.getChildren().size() - 1) {
                this.showcaseContainer.getChildren().remove((Object)this);
                this.showcaseContainer.getChildren().add((Object)this);
            }
        }
    }

    public void setDefaultLayer(ShowcaseLayer layer) {
        this.defaultLayer = layer;
    }

    public ShowcaseLayer getDefaultLayer() {
        return this.defaultLayer;
    }

    public void setDefaultLayout(ShowcaseLayout layout) {
        this.defaultLayout = layout;
    }

    public ShowcaseLayout getDefaultLayout() {
        return this.defaultLayout;
    }

    public void addStep(ShowcaseStep step) {
        this.steps.add(step);
    }

    public StepBuilder createStep(Node targetNode, Node content) {
        StepBuilder builder = new StepBuilder(targetNode, content);
        this.steps.add(builder.getStep());
        return builder;
    }

    public StepBuilder createStep(Node targetNode, String title, String body) {
        return this.createStep(targetNode, (Node)new SimpleStepView(title, body));
    }

    public StepBuilder createStep(Node targetNode, String body) {
        return this.createStep(targetNode, (Node)new SimpleStepView("", body));
    }

    public int getCurrentPosition() {
        return this.currentStep;
    }

    public ShowcaseStep getCurrentStep() {
        if (this.currentStep > 0 && this.currentStep < this.steps.size()) {
            return this.steps.get(this.currentStep);
        }
        return null;
    }

    public boolean isStarted() {
        return this.currentStep >= 0;
    }

    public boolean isUpdateOnTargetBoundsChange() {
        return this.updateOnTargetBoundsChange;
    }

    public void setOnClickBehaviour(ShowcaseBehaviour onClickBehaviour) {
        this.onClickBehaviour = onClickBehaviour;
    }

    public void setUpdateOnTargetBoundsChange(boolean updateOnTargetBoundsChange) {
        this.updateOnTargetBoundsChange = updateOnTargetBoundsChange;
    }

    public void setTransitionDelay(int delay) {
        this.fadeIn.setDelay(Duration.millis((double)delay));
        this.fadeOut.setDelay(Duration.millis((double)delay));
    }

    public void setOnShowcaseStarted(EventHandler<? super ShowcaseEvent> handler) {
        this.onShowcaseStartedProperty.set(handler);
    }

    public EventHandler<? super ShowcaseEvent> getOnShowcaseStarted() {
        return (EventHandler)this.onShowcaseStartedProperty.get();
    }

    public void setOnShowcaseStopped(EventHandler<? super ShowcaseEvent> handler) {
        this.onShowcaseStoppedProperty.set(handler);
    }

    public EventHandler<? super ShowcaseEvent> getOnShowcaseStopped() {
        return (EventHandler)this.onShowcaseStoppedProperty.get();
    }

    public void setOnShowcaseStepDisplay(EventHandler<? super ShowcaseEvent> handler) {
        this.onShowcaseStepDisplayProperty.set(handler);
    }

    public EventHandler<? super ShowcaseEvent> getOnShowcaseStepDisplay() {
        return (EventHandler)this.onShowcaseStepDisplayProperty.get();
    }

    public static enum ShowcaseBehaviour {
        NEXT,
        CLOSE,
        NONE;

    }
}

