/*
 * Decompiled with CFR 0.152.
 */
package com.dropsnorz.showcasefx.layers;

import com.dropsnorz.showcasefx.layers.ShowcaseLayer;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;

public abstract class ShowcaseLayerFill
implements ShowcaseLayer {
    private static final String LAYER_FILL_STYLE_CLASS = "showcase-layer-fill";
    public static ShowcaseLayerFill CIRCLE_GRADIENT = new ShowcaseLayerFill(){

        @Override
        public Background generate(Bounds targetBounds, double parentWidth, double parentHeight) {
            double centerX = targetBounds.getMinX() + targetBounds.getWidth() / 2.0;
            double centerY = targetBounds.getMinY() + targetBounds.getHeight() / 2.0;
            double x_relative = centerX / parentWidth;
            double y_relative = centerY / parentHeight;
            double focus = Math.max(x_relative, y_relative);
            int radiusOffset = 30;
            double radius = Math.max((centerX + (double)radiusOffset) / parentWidth, (centerY + (double)radiusOffset) / parentHeight);
            RadialGradient shadePaint = new RadialGradient(0.0, focus, x_relative, y_relative, radius, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(1.0, Color.rgb((int)0, (int)0, (int)0, (double)0.6)), new Stop(0.0, Color.TRANSPARENT)});
            return new Background(new BackgroundFill[]{new BackgroundFill((Paint)shadePaint, null, Insets.EMPTY)});
        }
    };
    public static ShowcaseLayerFill CIRCLE_FLAT = new ShowcaseLayerFill(){

        @Override
        public Background generate(Bounds targetBounds, double parentWidth, double parentHeight) {
            double centerX = targetBounds.getMinX() + targetBounds.getWidth() / 2.0;
            double centerY = targetBounds.getMinY() + targetBounds.getHeight() / 2.0;
            double size = Math.max(targetBounds.getWidth() + 20.0, targetBounds.getHeight() + 20.0);
            RadialGradient shadePaint = new RadialGradient(0.0, 0.0, centerX, centerY, size / 2.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.98, Color.TRANSPARENT), new Stop(1.0, Color.rgb((int)0, (int)0, (int)0, (double)0.7))});
            return new Background(new BackgroundFill[]{new BackgroundFill((Paint)shadePaint, null, Insets.EMPTY)});
        }
    };

    public abstract Background generate(Bounds var1, double var2, double var4);

    @Override
    public Node getNode(Bounds targetBounds, double parentWidth, double parentHeight) {
        Background background = this.generate(targetBounds, parentWidth, parentHeight);
        Pane pane = new Pane();
        pane.setBackground(background);
        pane.getStyleClass().add((Object)LAYER_FILL_STYLE_CLASS);
        return pane;
    }
}

