/*
 * Decompiled with CFR 0.152.
 */
package com.dropsnorz.showcasefx.layers;

import com.dropsnorz.showcasefx.layers.ShowcaseLayer;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;

public abstract class ShowcaseLayerShape
implements ShowcaseLayer {
    private static final String LAYER_STYLE_CLASS = "showcase-layer";
    private static final String SHAPE_STYLE_CLASS = "showcase-layer-shape";
    public static ShowcaseLayerShape CIRCLE_FLAT = new ShowcaseLayerShape(){

        @Override
        public Shape generate(Bounds targetBounds, double parentWidth, double parentHeight) {
            double centerX = targetBounds.getMinX() + targetBounds.getWidth() / 2.0;
            double centerY = targetBounds.getMinY() + targetBounds.getHeight() / 2.0;
            int radiusOffset = 8;
            double radius = Math.max(targetBounds.getWidth() / 2.0 + (double)radiusOffset, targetBounds.getHeight() / 2.0 + (double)radiusOffset);
            Circle circle = new Circle(centerX, centerY, radius);
            return circle;
        }
    };
    public static ShowcaseLayerShape RECTANGLE_FLAT = new ShowcaseLayerShape(){

        @Override
        public Shape generate(Bounds targetBounds, double parentWidth, double parentHeight) {
            int offset = 10;
            Rectangle rectangle = new Rectangle(targetBounds.getMinX() - (double)offset, targetBounds.getMinY() - (double)offset, targetBounds.getWidth() + (double)(2 * offset), targetBounds.getHeight() + (double)(2 * offset));
            return rectangle;
        }
    };

    public abstract Shape generate(Bounds var1, double var2, double var4);

    @Override
    public Node getNode(Bounds targetBounds, double parentWidth, double parentHeight) {
        Shape clip = this.generate(targetBounds, parentWidth, parentHeight);
        clip.setFill((Paint)Color.rgb((int)0, (int)0, (int)0, (double)0.7));
        Pane pane = new Pane();
        Rectangle inverse = new Rectangle();
        inverse.setWidth(parentWidth);
        inverse.setHeight(parentHeight);
        Shape shape = Shape.subtract((Shape)inverse, (Shape)clip);
        shape.getStyleClass().add((Object)SHAPE_STYLE_CLASS);
        shape.setFill((Paint)Color.rgb((int)0, (int)0, (int)0, (double)0.7));
        shape.getStyleClass().add((Object)LAYER_STYLE_CLASS);
        pane.getChildren().add((Object)shape);
        return pane;
    }
}

