/*
 * Decompiled with CFR 0.152.
 */
package com.dropsnorz.showcasefx.layouts;

import com.dropsnorz.showcasefx.layouts.ShowcaseLayout;
import com.dropsnorz.showcasefx.utils.BoundsUtils;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;

public class AutoShowcaseLayout
extends ShowcaseLayout {
    protected GridPane mainPane = new GridPane();

    public AutoShowcaseLayout() {
        this.mainPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
    }

    @Override
    public void addContentNode(Node content, Bounds targetBoundsInParent, double parentWidth, double parentHeight) {
        double midX = parentWidth / 2.0;
        double midY = parentHeight / 2.0;
        int rowIndex = 0;
        int columnIndex = 0;
        int rowSpan = 1;
        int colSpan = 1;
        HPos HAlignement = HPos.CENTER;
        VPos VAlignment = VPos.CENTER;
        Point2D targetCenter = BoundsUtils.getCenter(targetBoundsInParent);
        ColumnConstraints col0 = new ColumnConstraints();
        ColumnConstraints col1 = new ColumnConstraints();
        RowConstraints row0 = new RowConstraints();
        RowConstraints row1 = new RowConstraints();
        if (targetCenter.getY() > midY) {
            rowIndex = 0;
            VAlignment = VPos.BOTTOM;
            row1.setPrefHeight(parentHeight - targetBoundsInParent.getMinY() + 20.0);
            row0.setVgrow(Priority.ALWAYS);
        } else {
            rowIndex = 1;
            VAlignment = VPos.TOP;
            row0.setPrefHeight(targetBoundsInParent.getMaxY() + 20.0);
            row1.setVgrow(Priority.ALWAYS);
        }
        if (targetCenter.getX() > midX) {
            columnIndex = 0;
            HAlignement = HPos.RIGHT;
            col1.setPrefWidth(parentWidth - targetBoundsInParent.getMinX() + 20.0);
            col0.setHgrow(Priority.ALWAYS);
        } else {
            columnIndex = 1;
            HAlignement = HPos.LEFT;
            col0.setPrefWidth(targetBoundsInParent.getMaxX() + 20.0);
            col1.setHgrow(Priority.ALWAYS);
        }
        Group contentGroup = new Group(new Node[]{content});
        GridPane.setConstraints((Node)contentGroup, (int)columnIndex, (int)rowIndex, (int)colSpan, (int)rowSpan, (HPos)HAlignement, (VPos)VAlignment);
        this.mainPane.setMaxSize(parentWidth, parentHeight);
        this.mainPane.getColumnConstraints().clear();
        this.mainPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col0, col1});
        this.mainPane.getRowConstraints().clear();
        this.mainPane.getRowConstraints().addAll((Object[])new RowConstraints[]{row0, row1});
        this.mainPane.getChildren().clear();
        this.mainPane.getChildren().add((Object)contentGroup);
    }

    public void setDebug(boolean debug) {
        if (debug) {
            this.mainPane.setGridLinesVisible(false);
            this.mainPane.setGridLinesVisible(true);
        } else {
            this.mainPane.setGridLinesVisible(false);
        }
    }

    @Override
    public Node getNode() {
        return this.mainPane;
    }
}

