/*
 * Decompiled with CFR 0.152.
 */
package com.dropsnorz.showcasefx.layouts;

import com.dropsnorz.showcasefx.layouts.ShowcaseLayout;
import com.dropsnorz.showcasefx.utils.BoundsUtils;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.layout.Pane;

public class RelativeShowcaseLayout
extends ShowcaseLayout {
    protected Pane mainPane = new Pane();
    protected double offsetX = 0.0;
    protected double offsetY = 0.0;
    protected boolean computeFromTargetCenter = false;

    public RelativeShowcaseLayout() {
    }

    public RelativeShowcaseLayout(double offsetX, double offsetY) {
        this();
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public RelativeShowcaseLayout(double offsetX, double offsetY, boolean computeFromTargetCenter) {
        this(offsetX, offsetY);
        this.computeFromTargetCenter = computeFromTargetCenter;
    }

    @Override
    public void addContentNode(Node content, Bounds targetBoundsInParent, double parentWidth, double parentHeight) {
        this.mainPane.getChildren().clear();
        this.mainPane.getChildren().add((Object)content);
        double x = 0.0;
        double y = 0.0;
        if (this.computeFromTargetCenter) {
            Point2D targetCenter = BoundsUtils.getCenter(targetBoundsInParent);
            x = targetCenter.getX() + this.offsetX;
            y = targetCenter.getY() + this.offsetY;
        } else {
            x = targetBoundsInParent.getMinX() + this.offsetX;
            y = targetBoundsInParent.getMinY() + this.offsetY;
        }
        content.relocate(x, y);
    }

    @Override
    public Node getNode() {
        return this.mainPane;
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(double offsetX) {
        this.offsetX = offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(double offsetY) {
        this.offsetY = offsetY;
    }
}

