/*
 * Decompiled with CFR 0.152.
 */
package com.dropsnorz.showcasefx.layouts;

import com.dropsnorz.showcasefx.layouts.ShowcaseLayout;
import com.dropsnorz.showcasefx.utils.BoundsUtils;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;

public class TooltipShowcaseLayout
extends ShowcaseLayout {
    protected Pane mainPane = new Pane();
    protected StackPane contentPane = new StackPane();
    protected DropShadow dropShadow;
    Polygon triangle = new Polygon();
    private static final String TOOLTIP_CONTENT_STYLE_CLASS = "showcase-tooltip-content";
    private static final String TOOLTIP_POINTER_STYLE_CLASS = "showcase-tooltip-pointer";

    public TooltipShowcaseLayout() {
        this.contentPane.getStyleClass().add((Object)TOOLTIP_CONTENT_STYLE_CLASS);
        this.triangle.getStyleClass().add((Object)TOOLTIP_POINTER_STYLE_CLASS);
        this.contentPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.contentPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.contentPane.setEffect((Effect)this.dropShadow);
        this.mainPane.getChildren().add((Object)this.triangle);
        this.mainPane.getChildren().add((Object)this.contentPane);
        this.dropShadow = new DropShadow();
        this.dropShadow.setRadius(5.0);
        this.dropShadow.setOffsetX(3.0);
        this.dropShadow.setOffsetY(3.0);
        this.dropShadow.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.5));
        this.triangle.setEffect((Effect)this.dropShadow);
        this.triangle.setFill((Paint)Color.WHITE);
        this.contentPane.setEffect((Effect)this.dropShadow);
    }

    @Override
    public void addContentNode(Node content, Bounds targetBoundsInParent, double parentWidth, double parentHeight) {
        this.mainPane.setMaxWidth(parentWidth);
        this.mainPane.setMaxHeight(parentHeight);
        this.contentPane.getChildren().clear();
        this.contentPane.getChildren().add((Object)content);
        this.mainPane.applyCss();
        this.mainPane.layout();
        int contentOffset = 10;
        int margin = 15;
        Point2D targetCenter = BoundsUtils.getCenter(targetBoundsInParent);
        double x = targetCenter.getX() - this.contentPane.getWidth() / 2.0;
        double y = targetCenter.getY() + (double)contentOffset;
        if (targetCenter.getX() > parentWidth - this.contentPane.getWidth()) {
            x = parentWidth - this.contentPane.getWidth() - (double)margin;
        } else if (targetCenter.getX() < this.contentPane.getWidth()) {
            x = margin;
        }
        if (targetCenter.getY() > parentHeight - this.contentPane.getHeight()) {
            y = targetCenter.getY() - this.contentPane.getHeight() - (double)(2 * contentOffset);
            this.triangle.getPoints().clear();
            this.triangle.getPoints().addAll((Object[])new Double[]{10.0, 10.0, 0.0, 0.0, 20.0, 0.0});
            this.triangle.relocate(targetCenter.getX() - 10.0, targetCenter.getY() - (double)(2 * contentOffset));
            this.triangle.toFront();
        } else {
            this.triangle.getPoints().clear();
            this.triangle.getPoints().addAll((Object[])new Double[]{10.0, 0.0, 0.0, 10.0, 20.0, 10.0});
            this.triangle.relocate(targetCenter.getX() - 10.0, targetCenter.getY());
            this.triangle.toBack();
        }
        this.contentPane.relocate(x, y);
    }

    @Override
    public Node getNode() {
        return this.mainPane;
    }

    public void setTooltipPadding(Insets insets) {
        this.contentPane.setPadding(insets);
    }
}

