/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client;

import com.dslplatform.compiler.client.CompileParameter;
import com.dslplatform.compiler.client.ExitException;
import com.dslplatform.compiler.client.parameters.DisableColors;
import com.dslplatform.compiler.client.parameters.DisablePrompt;
import com.dslplatform.compiler.client.parameters.LogOutput;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

public class Context
implements Closeable {
    private final Map<String, String> parameters = new HashMap<String, String>();
    private final Map<String, Object> cache = new HashMap<String, Object>();
    private PrintStream console;
    private boolean withLog;
    private boolean noPrompt;
    private boolean withColor = true;

    public Context() {
        this(AnsiConsole.out());
    }

    protected Context(PrintStream console) {
        this.console = console;
    }

    public void put(CompileParameter parameter, String value) {
        if (parameter instanceof DisablePrompt) {
            this.noPrompt = true;
        } else if (parameter instanceof LogOutput) {
            this.withLog = true;
        } else if (parameter instanceof DisableColors) {
            this.withColor = false;
            this.console = System.out;
        }
        this.parameters.put(parameter.getAlias(), value);
    }

    public void put(String parameter, String value) {
        this.parameters.put(parameter.toLowerCase(), value);
    }

    public boolean contains(CompileParameter parameter) {
        return this.parameters.containsKey(parameter.getAlias());
    }

    public boolean contains(String parameter) {
        return this.parameters.containsKey(parameter);
    }

    public String get(CompileParameter parameter) {
        return this.parameters.get(parameter.getAlias());
    }

    public String get(String parameter) {
        return this.parameters.get(parameter.toLowerCase());
    }

    public void cache(String name, Object value) {
        this.cache.put(name, value);
    }

    public <T> T notify(String action, T target) {
        this.log("Notify: " + action + " for " + target);
        return target;
    }

    public <T> T load(String name) {
        return (T)this.cache.get(name);
    }

    private static synchronized void write(PrintStream console, boolean newLine, String ... values) {
        if (values.length == 0) {
            console.println();
        } else if (newLine) {
            for (String v : values) {
                console.println(v);
            }
        } else {
            for (String v : values) {
                console.print(v);
            }
        }
        console.flush();
    }

    public void show(String ... values) {
        Context.write(this.console, true, values);
    }

    public static String inColor(Ansi.Color color, String message) {
        return Ansi.ansi().fg(color).a(message).reset().toString();
    }

    public void log(String value) {
        if (this.withLog) {
            Context.write(this.console, true, this.withColor ? Context.inColor(Ansi.Color.YELLOW, value) : value);
        }
    }

    public void log(char[] value, int len) {
        if (this.withLog) {
            String msg = new String(value, 0, len);
            Context.write(this.console, false, this.withColor ? Context.inColor(Ansi.Color.YELLOW, msg) : msg);
        }
    }

    public void warning(String value) {
        Context.write(this.console, true, this.withColor ? Context.inColor(Ansi.Color.MAGENTA, value) : value);
    }

    public void warning(Exception ex) {
        this.warning(ex.getMessage());
        if (this.withLog) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            this.warning(sw.toString());
        }
    }

    public void error(String value) {
        Context.write(this.console, true, this.withColor ? Context.inColor(Ansi.Color.RED, value) : value);
    }

    public void error(Exception ex) {
        if (ex instanceof ExitException) {
            return;
        }
        String description = ex.getMessage();
        if (description == null) {
            this.error(ex.getClass().getName() + " error without description");
        } else {
            this.error(description);
        }
        if (this.withLog) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            this.error(sw.toString());
        }
    }

    public boolean canInteract() {
        return !this.noPrompt && System.console() != null;
    }

    private void askSafe(String question, Ansi.Color color) {
        if (this.withColor) {
            try {
                Context.write(this.console, false, Ansi.ansi().fgBright(color).bold().a(question + " ").boldOff().reset().toString());
                return;
            }
            catch (NoSuchMethodError ignore) {
                this.warning("Incompatible jansi found on classpath. Reverting to no-color");
                this.withColor = false;
            }
        }
        Context.write(this.console, false, question + " ");
    }

    public String ask(String question) {
        this.askSafe(question, Ansi.Color.DEFAULT);
        return System.console().readLine();
    }

    public char[] askSecret(String question) {
        this.askSafe(question, Ansi.Color.CYAN);
        return System.console().readPassword();
    }

    @Override
    public void close() {
        for (Object it : this.cache.values()) {
            if (!(it instanceof Closeable)) continue;
            try {
                ((Closeable)it).close();
            }
            catch (IOException e) {
                this.error(e);
            }
        }
    }
}

