/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client;

public final class Either<T> {
    private final T value;
    private final Exception error;

    private Either(T value, Exception error) {
        this.value = value;
        this.error = error;
    }

    public boolean isSuccess() {
        return this.error == null;
    }

    public T get() {
        return this.value;
    }

    public Exception whyNot() {
        return this.error;
    }

    public String explainError() {
        return this.error.getMessage();
    }

    public static <S> Either<S> success(S value) {
        return new Either<S>(value, null);
    }

    public static <F> Either<F> fail(String error) {
        return new Either<Object>(null, new Exception(error));
    }

    public static <F> Either<F> fail(Exception error) {
        return new Either<Object>(null, error);
    }

    public static <F> Either<F> fail(String description, Exception error) {
        return new Either<Object>(null, new Exception(description, error));
    }
}

