/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client;

import com.dslplatform.compiler.client.CompileParameter;
import com.dslplatform.compiler.client.Context;
import com.dslplatform.compiler.client.Either;
import com.dslplatform.compiler.client.ExitException;
import com.dslplatform.compiler.client.ParameterParser;
import com.dslplatform.compiler.client.Utils;
import com.dslplatform.compiler.client.parameters.ApplyMigration;
import com.dslplatform.compiler.client.parameters.Dependencies;
import com.dslplatform.compiler.client.parameters.Diff;
import com.dslplatform.compiler.client.parameters.DisableColors;
import com.dslplatform.compiler.client.parameters.DisablePrompt;
import com.dslplatform.compiler.client.parameters.DotNet;
import com.dslplatform.compiler.client.parameters.Download;
import com.dslplatform.compiler.client.parameters.DslCompiler;
import com.dslplatform.compiler.client.parameters.DslPath;
import com.dslplatform.compiler.client.parameters.Force;
import com.dslplatform.compiler.client.parameters.GrantRole;
import com.dslplatform.compiler.client.parameters.Help;
import com.dslplatform.compiler.client.parameters.JavaPath;
import com.dslplatform.compiler.client.parameters.LogOutput;
import com.dslplatform.compiler.client.parameters.Maven;
import com.dslplatform.compiler.client.parameters.Migration;
import com.dslplatform.compiler.client.parameters.Mono;
import com.dslplatform.compiler.client.parameters.Namespace;
import com.dslplatform.compiler.client.parameters.Nuget;
import com.dslplatform.compiler.client.parameters.OracleConnection;
import com.dslplatform.compiler.client.parameters.Parse;
import com.dslplatform.compiler.client.parameters.PostgresConnection;
import com.dslplatform.compiler.client.parameters.PropertiesFile;
import com.dslplatform.compiler.client.parameters.ScalaPath;
import com.dslplatform.compiler.client.parameters.Settings;
import com.dslplatform.compiler.client.parameters.SqlPath;
import com.dslplatform.compiler.client.parameters.Targets;
import com.dslplatform.compiler.client.parameters.TempPath;
import com.dslplatform.compiler.client.parameters.VarraySize;
import com.dslplatform.compiler.client.parameters.Version;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ServiceLoader;
import java.util.jar.Manifest;

public class Main {
    private static CompileParameter[] DEFAULT_PARAMETERS = new CompileParameter[]{DslPath.INSTANCE, SqlPath.INSTANCE, Download.INSTANCE, Dependencies.INSTANCE, Nuget.INSTANCE, DotNet.INSTANCE, Mono.INSTANCE, TempPath.INSTANCE, DslCompiler.INSTANCE, Maven.INSTANCE, JavaPath.INSTANCE, ScalaPath.INSTANCE, Namespace.INSTANCE, Version.INSTANCE, Settings.INSTANCE, PostgresConnection.INSTANCE, OracleConnection.INSTANCE, DisablePrompt.INSTANCE, Parse.INSTANCE, Diff.INSTANCE, Targets.INSTANCE, Force.INSTANCE, Migration.INSTANCE, ApplyMigration.INSTANCE, DisableColors.INSTANCE, LogOutput.INSTANCE, VarraySize.INSTANCE, GrantRole.INSTANCE};

    public static void main(String[] args) {
        Context context = new Context();
        List<CompileParameter> parameters = Main.initializeParameters(context, ".");
        int returnCode = Main.parse(args, context, parameters) ? (Main.processContext(context, parameters) ? 0 : 1) : 2;
        context.close();
        System.exit(returnCode);
    }

    public static List<CompileParameter> initializeParameters(Context context, String path) {
        ArrayList<CompileParameter> parameters = new ArrayList<CompileParameter>(DEFAULT_PARAMETERS.length + 2);
        parameters.add(new Help(parameters));
        parameters.add(new PropertiesFile(parameters));
        Collections.addAll(parameters, DEFAULT_PARAMETERS);
        File loc = new File(path);
        File[] jars = loc.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getPath().toLowerCase().endsWith(".jar");
            }
        });
        ArrayList<URL> urls = new ArrayList<URL>(jars != null ? jars.length : 0);
        if (jars != null) {
            for (File j : jars) {
                try {
                    urls.add(j.toURI().toURL());
                }
                catch (MalformedURLException ex) {
                    context.error(ex);
                }
            }
        }
        URLClassLoader ucl = new URLClassLoader(urls.toArray(new URL[urls.size()]));
        ServiceLoader<CompileParameter> plugins = ServiceLoader.load(CompileParameter.class, ucl);
        for (CompileParameter cp : plugins) {
            parameters.add(cp);
        }
        if (Utils.isWindows()) {
            try {
                Method close = ucl.getClass().getMethod("close", new Class[0]);
                if (close != null) {
                    close.invoke((Object)ucl, new Object[0]);
                }
            }
            catch (NoSuchMethodError ignore) {
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return parameters;
    }

    public static boolean processContext(Context context, List<CompileParameter> parameters) {
        try {
            context.notify("PROCESS", parameters);
            for (CompileParameter cp : parameters) {
                if (cp.check(context)) continue;
                if (cp.getDetailedDescription() != null) {
                    context.show(new String[0]);
                    context.show(new String[0]);
                    context.show(cp.getDetailedDescription());
                }
                return false;
            }
            for (CompileParameter cp : parameters) {
                cp.run(context);
            }
            return true;
        }
        catch (ExitException ex) {
            return false;
        }
    }

    private static CompileParameter from(String value, List<CompileParameter> parameters) {
        for (CompileParameter cp : parameters) {
            if (!cp.getAlias().equalsIgnoreCase(value)) continue;
            return cp;
        }
        return null;
    }

    private static boolean parse(String[] args, Context context, List<CompileParameter> parameters) {
        if (args.length == 1 && ("/?".equals(args[0]) || "-?".equals(args[0]) || "?".equals(args[0]))) {
            Main.showHelpAndExit(context, true, parameters);
            return false;
        }
        ArrayList<ParameterParser> customParsers = new ArrayList<ParameterParser>();
        for (CompileParameter cp : parameters) {
            if (!(cp instanceof ParameterParser)) continue;
            customParsers.add((ParameterParser)((Object)cp));
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (String a : args) {
            int eq;
            if (a.startsWith("-") || a.startsWith("/")) {
                a = a.substring(1);
            }
            String name = a.substring(0, (eq = a.indexOf(61)) != -1 ? eq : a.length());
            String value = eq == -1 ? null : a.substring(eq + 1);
            CompileParameter cp = Main.from(name, parameters);
            if (cp == null) {
                boolean matched = false;
                for (ParameterParser parser : customParsers) {
                    Either<Boolean> tryParse = parser.tryParse(name, value, context);
                    if (!tryParse.isSuccess()) {
                        errors.add(tryParse.explainError());
                        matched = true;
                        break;
                    }
                    if (!tryParse.get().booleanValue()) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                errors.add("Unknown parameter: " + name);
                continue;
            }
            if (eq == -1 && cp.getUsage() != null) {
                if (cp instanceof ParameterParser) {
                    Either<Boolean> tryParse = ((ParameterParser)((Object)cp)).tryParse(name, null, context);
                    if (tryParse.isSuccess() && tryParse.get().booleanValue()) {
                        context.put(cp, null);
                        continue;
                    }
                    errors.add("Expecting " + cp.getUsage() + " after = for " + a);
                    continue;
                }
                errors.add("Expecting " + cp.getUsage() + " after = for " + a);
                continue;
            }
            context.put(cp, value);
        }
        if (args.length == 0 || errors.size() > 0) {
            for (String err : errors) {
                context.error(err);
            }
            Main.showHelpAndExit(context, args.length == errors.size(), parameters);
            return false;
        }
        return true;
    }

    private static void showHelpAndExit(Context context, boolean headers, List<CompileParameter> parameters) {
        if (headers) {
            context.show("DSL Platform - Command-Line Client (" + Main.getVersion() + ")");
            context.show("This tool allows you to compile provided DSL to various languages such as Java, Scala, PHP, C#, etc... or create an SQL migration between two DSL models.");
        }
        context.show(new String[0]);
        context.show(new String[0]);
        context.show("Command parameters:");
        int max = 0;
        for (CompileParameter cp : parameters) {
            if (cp.getShortDescription() == null) continue;
            int width = cp.getAlias().length();
            if (cp.getUsage() != null) {
                width += 1 + cp.getUsage().length();
            }
            if (max >= width) continue;
            max = width;
        }
        max += 2;
        for (CompileParameter cp : parameters) {
            if (cp.getShortDescription() == null) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(" -").append(cp.getAlias());
            int len = max - cp.getAlias().length();
            if (cp.getUsage() != null) {
                sb.append("=").append(cp.getUsage());
                len -= cp.getUsage().length() + 1;
            }
            while (len >= 0) {
                sb.append(' ');
                --len;
            }
            sb.append(cp.getShortDescription());
            context.show(sb.toString());
        }
        context.show(new String[0]);
        context.show("Example usages:");
        context.show("\ttarget=java_client,revenj.java postgres=localhost/Database?user=postgres");
        context.show("\tjava_client=model.jar revenj.net=Model.dll postgres=localhost/Database?user=postgres");
        context.show("\tproperties=development.props download");
    }

    private static String getVersionInfo(String section) {
        try {
            Enumeration<URL> resources = Main.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                Manifest manifest = new Manifest(resources.nextElement().openStream());
                if (!"DSL Platform - Compiler Command-Line Client".equals(manifest.getMainAttributes().getValue("Specification-Title"))) continue;
                return manifest.getMainAttributes().getValue(section);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "unknown";
    }

    public static String getVersion() {
        return Main.getVersionInfo("Specification-Version");
    }

    public static String getReleaseDate() {
        return Main.getVersionInfo("Build-Time");
    }
}

