/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client;

import com.dslplatform.compiler.client.Context;
import com.dslplatform.compiler.client.Either;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public abstract class Utils {
    public static String read(InputStream stream) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((len = stream.read(buffer)) != -1) {
            baos.write(buffer, 0, len);
        }
        return baos.toString("UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Either<String> readFile(File file) {
        Either<String> either;
        FileInputStream stream = new FileInputStream(file);
        try {
            String content = Utils.read(stream);
            either = Either.success(content);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException ex) {
                return Either.fail(ex);
            }
        }
        stream.close();
        return either;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(Context context, File file, String content) throws IOException {
        context.log("Saving file: " + file.getAbsolutePath());
        FileOutputStream fos = new FileOutputStream(file);
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            writer.write(content);
            ((Writer)writer).close();
        }
        finally {
            fos.close();
        }
    }

    public static List<File> findFiles(Context context, File path, List<String> extensions) {
        context.log("Searching for files...");
        for (String ext : extensions) {
            context.log("Matching: " + ext);
        }
        LinkedList<File> foundFiles = new LinkedList<File>();
        Utils.findFiles(context, path, foundFiles, extensions);
        return foundFiles;
    }

    private static void findFiles(Context context, File path, List<File> foundFiles, List<String> extensions) {
        String[] files = path.list();
        if (files == null) {
            return;
        }
        block0: for (String fn : files) {
            File f = new File(path, fn);
            if (f.isDirectory()) {
                Utils.findFiles(context, f, foundFiles, extensions);
                continue;
            }
            for (String e : extensions) {
                if (!f.getName().endsWith(e)) continue;
                context.log("Found: " + f.getAbsolutePath());
                foundFiles.add(f);
                continue block0;
            }
        }
    }

    public static long unpackZip(Context context, File path, URL remoteUrl) throws IOException {
        return Utils.unpackZip(context, path, remoteUrl, new ArrayList<File>(), 3);
    }

    private static long unpackZip(Context context, File path, URL remoteUrl, ArrayList<File> unpackedFiles, int retry) throws IOException {
        try {
            ZipEntry entry;
            URLConnection connection = remoteUrl.openConnection();
            connection.setConnectTimeout(60000);
            long lastModified = connection.getLastModified();
            InputStream response = connection.getInputStream();
            ZipInputStream zip = new ZipInputStream(new BufferedInputStream(response));
            byte[] buffer = new byte[8192];
            while ((entry = zip.getNextEntry()) != null) {
                int len;
                long size = 0L;
                File file = new File(path, entry.getName());
                unpackedFiles.add(file);
                FileOutputStream fos = new FileOutputStream(file);
                while ((len = zip.read(buffer)) != -1) {
                    fos.write(buffer, 0, len);
                    size += (long)len;
                }
                fos.close();
                context.log("Unpacked: " + entry.getName() + ". Size: " + size / 1024L + "kB");
                zip.closeEntry();
            }
            zip.close();
            return lastModified;
        }
        catch (IOException io) {
            context.error(io);
            for (File f : unpackedFiles) {
                if (f.delete()) {
                    context.log("Cleaned up: " + f);
                    continue;
                }
                context.log("Failed to clean up: " + f);
            }
            if (retry > 0) {
                context.warning("Retrying download... from " + remoteUrl);
                return Utils.unpackZip(context, path, remoteUrl, new ArrayList<File>(), retry - 1);
            }
            throw io;
        }
    }

    public static void downloadFile(File file, URL url) throws IOException {
        Utils.downloadFileAndRetry(file, url, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadFileAndRetry(File file, URL url, int retry) throws IOException {
        block10: {
            FileOutputStream fos = new FileOutputStream(file);
            try {
                byte[] buffer = new byte[8192];
                BufferedInputStream stream = new BufferedInputStream(url.openConnection().getInputStream());
                try {
                    int len;
                    while ((len = ((InputStream)stream).read(buffer)) != -1) {
                        fos.write(buffer, 0, len);
                    }
                }
                finally {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException io) {
                if (retry > 0) {
                    Utils.downloadFileAndRetry(file, url, retry - 1);
                    break block10;
                }
                throw io;
            }
            finally {
                fos.close();
            }
        }
    }

    public static synchronized Either<Document> readXml(InputStream stream) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            return Either.success(dBuilder.parse(stream));
        }
        catch (Exception ex) {
            return Either.fail(ex);
        }
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    private static void logCommand(Context context, ProcessBuilder builder) {
        StringBuilder description = new StringBuilder("Running: ");
        for (String arg : builder.command()) {
            description.append(arg).append(" ");
        }
        context.log(description.toString());
        context.notify("EXEC", builder);
    }

    public static Either<String> findCommand(Context context, String path, String name, String contains) {
        String simple;
        String string = simple = path != null ? new File(path, name).getAbsolutePath() : name;
        if (Utils.testCommand(context, simple, contains, new ArrayList<String>())) {
            context.log("Found " + name + " in " + simple);
            return Either.success(simple);
        }
        if (Utils.isWindows()) {
            String cmd;
            String bat;
            String string2 = bat = path != null ? new File(path, name + ".bat").getAbsolutePath() : name + ".bat";
            if (Utils.testCommand(context, bat, contains, new ArrayList<String>())) {
                context.log("Found " + name + " in " + bat);
                return Either.success(bat);
            }
            String string3 = cmd = path != null ? new File(path, name + ".cmd").getAbsolutePath() : name + ".cmd";
            if (Utils.testCommand(context, cmd, contains, new ArrayList<String>())) {
                context.log("Found " + name + " in " + cmd);
                return Either.success(cmd);
            }
        }
        return Either.fail("File not found: " + name);
    }

    public static boolean testCommand(Context context, String command, String contains) {
        return Utils.testCommand(context, command, contains, new ArrayList<String>());
    }

    public static boolean testCommand(Context context, String command, String contains, List<String> arguments) {
        try {
            ArrayList<String> commandAndArgs = new ArrayList<String>();
            commandAndArgs.add(command);
            commandAndArgs.addAll(arguments);
            ProcessBuilder pb = new ProcessBuilder(commandAndArgs);
            pb.environment().put("DOTNET_CLI_TELEMETRY_OPTOUT", "1");
            Utils.logCommand(context, pb);
            Process compilation = pb.start();
            ConsumeStream result = ConsumeStream.start(compilation.getInputStream(), null);
            ConsumeStream error = ConsumeStream.start(compilation.getErrorStream(), null);
            compilation.waitFor();
            result.join();
            error.join();
            return error.output.toString().contains(contains) || result.output.toString().contains(contains);
        }
        catch (IOException ex) {
            context.log(ex.getMessage());
            return false;
        }
        catch (InterruptedException ex) {
            context.log(ex.getMessage());
            return false;
        }
    }

    public static Either<CommandResult> runCommand(Context context, String command, File path, List<String> arguments) {
        try {
            ArrayList<String> commandAndArgs = new ArrayList<String>();
            commandAndArgs.add(command);
            commandAndArgs.addAll(arguments);
            ProcessBuilder pb = new ProcessBuilder(commandAndArgs);
            pb.environment().put("DOTNET_CLI_TELEMETRY_OPTOUT", "1");
            if (path != null) {
                pb.directory(path);
            }
            Utils.logCommand(context, pb);
            Process compilation = pb.start();
            ConsumeStream result = ConsumeStream.start(compilation.getInputStream(), context);
            ConsumeStream error = ConsumeStream.start(compilation.getErrorStream(), context);
            int exitCode = compilation.waitFor();
            result.join();
            error.join();
            if (result.exception != null) {
                return Either.fail(result.exception);
            }
            if (error.exception != null) {
                return Either.fail(error.exception);
            }
            return Either.success(new CommandResult(result.output.toString(), error.output.toString(), exitCode));
        }
        catch (IOException ex) {
            return Either.fail(ex);
        }
        catch (InterruptedException ex) {
            return Either.fail(ex);
        }
    }

    public static void deletePath(File path) throws IOException {
        Utils.deletePathAndRetry(path, 3);
    }

    private static void deletePathAndRetry(File path, int retry) throws IOException {
        try {
            String[] files = path.list();
            if (files == null) {
                return;
            }
            for (String fn : files) {
                File f = new File(path, fn);
                if (f.isDirectory()) {
                    Utils.deletePath(f);
                }
                if (f.delete()) continue;
                throw new IOException("Error cleaning up temporary resource. Failed to delete: " + f.getAbsolutePath());
            }
        }
        catch (IOException io) {
            if (retry > 0) {
                Utils.deletePathAndRetry(path, retry - 1);
            }
            throw io;
        }
    }

    public static List<File> findNonEmptyDirs(File path, String extension) {
        LinkedList<File> foundDirs = new LinkedList<File>();
        Utils.findNonEmptyDirs(path, foundDirs, extension);
        return foundDirs;
    }

    private static void findNonEmptyDirs(File path, List<File> foundFiles, final String extension) {
        String[] content;
        File[] files = path.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(extension);
            }
        });
        if (files != null && files.length > 0) {
            foundFiles.add(path);
        }
        if ((content = path.list()) == null) {
            return;
        }
        for (String fn : content) {
            File f = new File(path, fn);
            if (!f.isDirectory()) continue;
            Utils.findNonEmptyDirs(f, foundFiles, extension);
        }
    }

    public static List<String> listSources(File source, Context context, String extension) {
        int len = source.getAbsolutePath().length() + 1;
        ArrayList<String> list = new ArrayList<String>();
        if (Utils.isWindows()) {
            List<File> dirs = Utils.findNonEmptyDirs(source, extension);
            for (File f : dirs) {
                if (f.equals(source)) {
                    list.add("*" + extension);
                    continue;
                }
                list.add(f.getAbsolutePath().substring(len) + File.separator + "*" + extension);
            }
        } else {
            List<File> files = Utils.findFiles(context, source, Collections.singletonList(extension));
            for (File f : files) {
                list.add(f.getAbsolutePath().substring(len));
            }
        }
        return list;
    }

    private static class ConsumeStream
    extends Thread {
        private final BufferedReader reader;
        private final Context context;
        private final StringBuilder output = new StringBuilder();
        private IOException exception;

        private ConsumeStream(InputStream stream, Context context) {
            this.reader = new BufferedReader(new InputStreamReader(stream));
            this.context = context;
        }

        private ConsumeStream() {
            this.reader = null;
            this.context = null;
        }

        static ConsumeStream start(InputStream stream, Context context) {
            if (stream == null) {
                return new ConsumeStream();
            }
            ConsumeStream cs = new ConsumeStream(stream, context);
            cs.start();
            return cs;
        }

        @Override
        public void run() {
            if (this.reader == null) {
                return;
            }
            char[] buffer = new char[8192];
            try {
                int len;
                while ((len = this.reader.read(buffer)) != -1) {
                    this.output.append(buffer, 0, len);
                    if (this.context == null) continue;
                    this.context.log(buffer, len);
                }
                this.reader.close();
            }
            catch (IOException ex) {
                this.exception = ex;
            }
        }
    }

    public static class CommandResult {
        public final String output;
        public final String error;
        public final int exitCode;

        public CommandResult(String output, String error, int exitCode) {
            this.output = output;
            this.error = error;
            this.exitCode = exitCode;
        }
    }
}

