/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client.json;

import java.io.IOException;
import java.nio.charset.Charset;

final class JsonReader {
    private static final boolean[] WHITESPACE = new boolean[256];
    private int tokenStart;
    private int currentIndex = 0;
    private byte last = (byte)32;
    protected int length;
    private final char[] tmp;
    private final byte[] buffer;
    private static final Charset UTF_8;

    private JsonReader(char[] tmp, byte[] buffer, int length) {
        this.tmp = tmp;
        this.buffer = buffer;
        this.length = length;
    }

    public JsonReader(byte[] buffer, int length) throws IOException {
        this(buffer, length, new char[64]);
    }

    public JsonReader(byte[] buffer, int length, char[] tmp) throws IOException {
        this(tmp, buffer, length);
        if (tmp == null) {
            throw new NullPointerException("tmp buffer provided as null.");
        }
        if (length > buffer.length) {
            throw new IOException("length can't be longer than buffer.length");
        }
        if (length < buffer.length) {
            buffer[length] = 0;
        }
    }

    public int length() {
        return this.length;
    }

    public String toString() {
        return new String(this.buffer, 0, this.length, UTF_8);
    }

    public byte read() throws IOException {
        if (this.currentIndex >= this.length) {
            throw new IOException("Unexpected end of JSON input");
        }
        this.last = this.buffer[this.currentIndex++];
        return this.last;
    }

    boolean isEndOfStream() throws IOException {
        return this.length == this.currentIndex;
    }

    public final byte last() {
        return this.last;
    }

    public final int getTokenStart() {
        return this.tokenStart;
    }

    public final int getCurrentIndex() {
        return this.currentIndex;
    }

    public final char[] readNumber() {
        this.tokenStart = this.currentIndex - 1;
        this.tmp[0] = (char)this.last;
        int i = 1;
        int ci = this.currentIndex;
        byte bb = this.last;
        while (i < this.tmp.length && ci < this.length && (bb = this.buffer[ci++]) != 44 && bb != 125 && bb != 93) {
            this.tmp[i++] = (char)bb;
        }
        this.currentIndex += i - 1;
        this.last = bb;
        return this.tmp;
    }

    public final String readString() throws IOException {
        int startIndex = this.currentIndex;
        if (this.last != 34) {
            throw new IOException("JSON string must start with a double quote at: " + this.positionInStream());
        }
        byte bb = 0;
        int ci = this.currentIndex;
        try {
            for (int i = 0; i < this.tmp.length; ++i) {
                if ((bb = this.buffer[ci++]) == 34) {
                    this.currentIndex = ci;
                    return new String(this.tmp, 0, i);
                }
                if ((bb ^ 0x5C) >= 1) {
                    this.tmp[i] = (char)bb;
                    continue;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            throw new IOException("JSON string was not closed with a double quote at: " + this.positionInStream());
        }
        if (ci >= this.length) {
            throw new IOException("JSON string was not closed with a double quote at: " + ci);
        }
        while (ci < this.buffer.length && (bb ^ 0x5C) >= 1) {
            if ((bb = this.buffer[ci++]) != 34) continue;
            this.currentIndex = ci;
            return new String(this.buffer, startIndex, this.currentIndex - startIndex - 1, "ISO-8859-1");
        }
        this.currentIndex = ci;
        if (this.currentIndex >= this.length) {
            throw new IOException("JSON string was not closed with a double quote at: " + this.currentIndex);
        }
        int soFar = --this.currentIndex - startIndex;
        char[] chars = new char[soFar + 256];
        for (int i = soFar - 1; i >= 0; --i) {
            chars[i] = (char)this.buffer[startIndex + i];
        }
        while (this.currentIndex < this.length) {
            int bc;
            block32: {
                block31: {
                    if ((bc = this.buffer[this.currentIndex++]) == 34) {
                        return new String(chars, 0, soFar);
                    }
                    if (soFar >= chars.length - 3) {
                        char[] newChars = new char[chars.length << 1];
                        System.arraycopy(chars, 0, newChars, 0, soFar);
                        chars = newChars;
                    }
                    if (bc != 92) break block31;
                    bc = this.buffer[this.currentIndex++];
                    switch (bc) {
                        case 98: {
                            bc = 8;
                            break block32;
                        }
                        case 116: {
                            bc = 9;
                            break block32;
                        }
                        case 110: {
                            bc = 10;
                            break block32;
                        }
                        case 102: {
                            bc = 12;
                            break block32;
                        }
                        case 114: {
                            bc = 13;
                            break block32;
                        }
                        case 34: 
                        case 47: 
                        case 92: {
                            break block32;
                        }
                        case 117: {
                            bc = (JsonReader.hexToInt(this.buffer[this.currentIndex++]) << 12) + (JsonReader.hexToInt(this.buffer[this.currentIndex++]) << 8) + (JsonReader.hexToInt(this.buffer[this.currentIndex++]) << 4) + JsonReader.hexToInt(this.buffer[this.currentIndex++]);
                            break block32;
                        }
                        default: {
                            throw new IOException("Could not parse String, got invalid escape combination '\\" + bc + "'");
                        }
                    }
                }
                if ((bc & 0x80) != 0) {
                    byte u2 = this.buffer[this.currentIndex++];
                    if ((bc & 0xE0) == 192) {
                        bc = ((bc & 0x1F) << 6) + (u2 & 0x3F);
                    } else {
                        byte u3 = this.buffer[this.currentIndex++];
                        if ((bc & 0xF0) == 224) {
                            bc = ((bc & 0xF) << 12) + ((u2 & 0x3F) << 6) + (u3 & 0x3F);
                        } else {
                            byte u4 = this.buffer[this.currentIndex++];
                            if ((bc & 0xF8) != 240) {
                                throw new IOException();
                            }
                            bc = ((bc & 7) << 18) + ((u2 & 0x3F) << 12) + ((u3 & 0x3F) << 6) + (u4 & 0x3F);
                            if (bc >= 65536) {
                                if (bc >= 0x110000) {
                                    throw new IOException();
                                }
                                int sup = bc - 65536;
                                chars[soFar++] = (char)((sup >>> 10) + 55296);
                                chars[soFar++] = (char)((sup & 0x3FF) + 56320);
                            }
                        }
                    }
                }
            }
            chars[soFar++] = (char)bc;
        }
        throw new IOException("JSON string was not closed with a double quote!");
    }

    private static int hexToInt(byte value) throws IOException {
        if (value >= 48 && value <= 57) {
            return value - 48;
        }
        if (value >= 65 && value <= 70) {
            return value - 55;
        }
        if (value >= 97 && value <= 102) {
            return value - 87;
        }
        throw new IOException("Could not parse unicode escape, expected a hexadecimal digit, got '" + value + "'");
    }

    private boolean wasWhiteSpace() {
        switch (this.last) {
            case -96: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 32: {
                return true;
            }
            case -31: {
                if (this.currentIndex + 1 < this.length && this.buffer[this.currentIndex] == -102 && this.buffer[this.currentIndex + 1] == -128) {
                    this.currentIndex += 2;
                    this.last = (byte)32;
                    return true;
                }
                return false;
            }
            case -30: {
                if (this.currentIndex + 1 < this.length) {
                    byte b1 = this.buffer[this.currentIndex];
                    byte b2 = this.buffer[this.currentIndex + 1];
                    if (b1 == -127 && b2 == -97) {
                        this.currentIndex += 2;
                        this.last = (byte)32;
                        return true;
                    }
                    if (b1 != -128) {
                        return false;
                    }
                    switch (b2) {
                        case -128: 
                        case -127: 
                        case -126: 
                        case -125: 
                        case -124: 
                        case -123: 
                        case -122: 
                        case -121: 
                        case -120: 
                        case -119: 
                        case -118: 
                        case -88: 
                        case -87: 
                        case -81: {
                            this.currentIndex += 2;
                            this.last = (byte)32;
                            return true;
                        }
                    }
                    return false;
                }
                return false;
            }
            case -29: {
                if (this.currentIndex + 1 < this.length && this.buffer[this.currentIndex] == -128 && this.buffer[this.currentIndex + 1] == -128) {
                    this.currentIndex += 2;
                    this.last = (byte)32;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public final byte getNextToken() throws IOException {
        this.read();
        if (WHITESPACE[this.last + 128]) {
            while (this.wasWhiteSpace()) {
                this.read();
            }
        }
        return this.last;
    }

    public final long positionInStream() {
        return this.currentIndex;
    }

    public final boolean wasNull() throws IOException {
        if (this.last == 110) {
            if (this.currentIndex + 2 < this.length && this.buffer[this.currentIndex] == 117 && this.buffer[this.currentIndex + 1] == 108 && this.buffer[this.currentIndex + 2] == 108) {
                this.currentIndex += 3;
                this.last = (byte)108;
                return true;
            }
            throw new IOException("Invalid null value found at: " + this.currentIndex);
        }
        return false;
    }

    public final boolean wasTrue() throws IOException {
        if (this.last == 116) {
            if (this.currentIndex + 2 < this.length && this.buffer[this.currentIndex] == 114 && this.buffer[this.currentIndex + 1] == 117 && this.buffer[this.currentIndex + 2] == 101) {
                this.currentIndex += 3;
                this.last = (byte)101;
                return true;
            }
            throw new IOException("Invalid boolean value found at: " + this.currentIndex);
        }
        return false;
    }

    public final boolean wasFalse() throws IOException {
        if (this.last == 102) {
            if (this.currentIndex + 3 < this.length && this.buffer[this.currentIndex] == 97 && this.buffer[this.currentIndex + 1] == 108 && this.buffer[this.currentIndex + 2] == 115 && this.buffer[this.currentIndex + 3] == 101) {
                this.currentIndex += 4;
                this.last = (byte)101;
                return true;
            }
            throw new IOException("Invalid boolean value found at: " + this.currentIndex);
        }
        return false;
    }

    static {
        JsonReader.WHITESPACE[137] = true;
        JsonReader.WHITESPACE[138] = true;
        JsonReader.WHITESPACE[139] = true;
        JsonReader.WHITESPACE[140] = true;
        JsonReader.WHITESPACE[141] = true;
        JsonReader.WHITESPACE[160] = true;
        JsonReader.WHITESPACE[32] = true;
        JsonReader.WHITESPACE[97] = true;
        JsonReader.WHITESPACE[98] = true;
        JsonReader.WHITESPACE[99] = true;
        UTF_8 = Charset.forName("UTF-8");
    }
}

