/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client.json;

import com.dslplatform.compiler.client.json.JsonReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;

abstract class NumberConverter {
    private static final double[] POW_10 = new double[18];

    NumberConverter() {
    }

    private static BigDecimal parseNumberGeneric(char[] buf, int len, int position) throws IOException {
        int end;
        for (end = len; end > 0 && Character.isWhitespace(buf[end - 1]); --end) {
        }
        try {
            return new BigDecimal(buf, 0, end);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Error parsing number at position: " + (position - len), nfe);
        }
    }

    private static NumberInfo readLongNumber(JsonReader reader, char[] buf) throws IOException {
        int i = buf.length;
        char[] tmp = Arrays.copyOf(buf, buf.length * 2);
        while (!reader.isEndOfStream()) {
            do {
                char ch = (char)reader.read();
                tmp[i++] = ch;
                if (!reader.isEndOfStream() && (ch >= '0' && ch < '9' || ch == '-' || ch == '+' || ch == '.' || ch == 'e' || ch == 'E')) continue;
                return new NumberInfo(tmp, reader.isEndOfStream() ? i : i - 1);
            } while (i < tmp.length);
            tmp = Arrays.copyOf(tmp, tmp.length * 2);
        }
        return new NumberInfo(tmp, i);
    }

    private static int parsePositiveInt(char[] buf, int position, int len, int i) throws IOException {
        int value = 0;
        while (i < len) {
            int ind = buf[i] - 48;
            value = (value << 3) + (value << 1) + ind;
            if (ind < 0 || ind > 9) {
                BigDecimal v = NumberConverter.parseNumberGeneric(buf, len, position);
                if (v.scale() <= 0) {
                    return v.intValue();
                }
                throw new IOException("Error parsing int number at position: " + (position - len) + ". Found decimal value: " + v);
            }
            ++i;
        }
        return value;
    }

    private static int parseNegativeInt(char[] buf, int position, int len, int i) throws IOException {
        int value = 0;
        while (i < len) {
            int ind = buf[i] - 48;
            value = (value << 3) + (value << 1) - ind;
            if (ind < 0 || ind > 9) {
                BigDecimal v = NumberConverter.parseNumberGeneric(buf, len, position);
                if (v.scale() <= 0) {
                    return v.intValue();
                }
                throw new IOException("Error parsing int number at position: " + (position - len) + ". Found decimal value: " + v);
            }
            ++i;
        }
        return value;
    }

    public static Number deserializeNumber(JsonReader reader) throws IOException {
        char[] buf = reader.readNumber();
        int position = reader.getCurrentIndex();
        int len = position - reader.getTokenStart();
        if (len > 18) {
            if (len == buf.length) {
                NumberInfo tmp = NumberConverter.readLongNumber(reader, buf);
                return NumberConverter.parseNumberGeneric(tmp.buffer, tmp.length, position);
            }
            return NumberConverter.parseNumberGeneric(buf, len, position);
        }
        char ch = buf[0];
        if (ch == '-') {
            return NumberConverter.parseNegativeNumber(buf, position, len);
        }
        if (ch == '+') {
            return NumberConverter.parsePositiveNumber(buf, position, len, 1);
        }
        return NumberConverter.parsePositiveNumber(buf, position, len, 0);
    }

    private static Number parsePositiveNumber(char[] buf, int position, int len, int i) throws IOException {
        long value = 0L;
        int ch = 32;
        while (i < len && (ch = buf[i]) != 46 && ch != 101 && ch != 69) {
            int ind = ch - 48;
            value = (value << 3) + (value << 1) + (long)ind;
            if (ind < 0 || ind > 9) {
                return NumberConverter.parseNumberGeneric(buf, len, position);
            }
            ++i;
        }
        if (i == len) {
            return value;
        }
        if (ch == 46) {
            int dp = ++i;
            while (i < len && (ch = buf[i]) != 101 && ch != 69) {
                int ind = ch - 48;
                value = (value << 3) + (value << 1) + (long)ind;
                if (ind < 0 || ind > 9) {
                    return NumberConverter.parseNumberGeneric(buf, len, position);
                }
                ++i;
            }
            if (i == len) {
                return (double)value / POW_10[len - dp];
            }
            if (ch == 101 || ch == 69) {
                int ep = i++;
                ch = buf[i];
                int exp = ch == 45 ? NumberConverter.parseNegativeInt(buf, position, len, i + 1) : (ch == 43 ? NumberConverter.parsePositiveInt(buf, position, len, i + 1) : NumberConverter.parsePositiveInt(buf, position, len, i));
                return BigDecimal.valueOf(value, ep - dp - exp);
            }
            return BigDecimal.valueOf(value, len - dp);
        }
        if (ch == 101 || ch == 69) {
            int exp = (ch = buf[++i]) == 45 ? NumberConverter.parseNegativeInt(buf, position, len, i + 1) : (ch == 43 ? NumberConverter.parsePositiveInt(buf, position, len, i + 1) : NumberConverter.parsePositiveInt(buf, position, len, i));
            return BigDecimal.valueOf(value, -exp);
        }
        return BigDecimal.valueOf(value);
    }

    private static Number parseNegativeNumber(char[] buf, int position, int len) throws IOException {
        int i;
        long value = 0L;
        int ch = 32;
        for (i = 1; i < len && (ch = buf[i]) != 46 && ch != 101 && ch != 69; ++i) {
            int ind = ch - 48;
            value = (value << 3) + (value << 1) - (long)ind;
            if (ind >= 0 && ind <= 9) continue;
            return NumberConverter.parseNumberGeneric(buf, len, position);
        }
        if (i == len) {
            return value;
        }
        if (ch == 46) {
            int dp = ++i;
            while (i < len && (ch = buf[i]) != 101 && ch != 69) {
                int ind = ch - 48;
                value = (value << 3) + (value << 1) - (long)ind;
                if (ind < 0 || ind > 9) {
                    return NumberConverter.parseNumberGeneric(buf, len, position);
                }
                ++i;
            }
            if (i == len) {
                return (double)value / POW_10[len - dp];
            }
            if (ch == 101 || ch == 69) {
                int ep = i++;
                ch = buf[i];
                int exp = ch == 45 ? NumberConverter.parseNegativeInt(buf, position, len, i + 1) : (ch == 43 ? NumberConverter.parsePositiveInt(buf, position, len, i + 1) : NumberConverter.parsePositiveInt(buf, position, len, i));
                return BigDecimal.valueOf(value, ep - dp - exp);
            }
            return BigDecimal.valueOf(value, len - dp);
        }
        if (ch == 101 || ch == 69) {
            int exp = (ch = buf[++i]) == 45 ? NumberConverter.parseNegativeInt(buf, position, len, i + 1) : (ch == 43 ? NumberConverter.parsePositiveInt(buf, position, len, i + 1) : NumberConverter.parsePositiveInt(buf, position, len, i));
            return BigDecimal.valueOf(value, -exp);
        }
        return BigDecimal.valueOf(value);
    }

    static {
        long tenPow = 1L;
        for (int i = 0; i < POW_10.length; ++i) {
            NumberConverter.POW_10[i] = tenPow;
            tenPow *= 10L;
        }
    }

    private static class NumberInfo {
        public final char[] buffer;
        public final int length;

        public NumberInfo(char[] buffer, int length) {
            this.buffer = buffer;
            this.length = length;
        }
    }
}

