/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client.parameters;

import com.dslplatform.compiler.client.CompileParameter;
import com.dslplatform.compiler.client.Context;
import com.dslplatform.compiler.client.ExitException;
import com.dslplatform.compiler.client.diff.diff_match_patch;
import com.dslplatform.compiler.client.parameters.DisableColors;
import com.dslplatform.compiler.client.parameters.DslPath;
import com.dslplatform.compiler.client.parameters.OracleConnection;
import com.dslplatform.compiler.client.parameters.PostgresConnection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.fusesource.jansi.Ansi;

public enum Diff implements CompileParameter
{
    INSTANCE;


    @Override
    public String getAlias() {
        return "diff";
    }

    @Override
    public String getUsage() {
        return null;
    }

    private static void compareDsls(Context context, Map<String, String> previousDsl) throws ExitException {
        Map<String, String> currentDsl = DslPath.getCurrentDsl(context);
        HashSet<String> currentFiles = new HashSet<String>(currentDsl.keySet());
        currentFiles.removeAll(previousDsl.keySet());
        for (String name : currentFiles) {
            context.show("New DSL file: " + name + ". Total lines: " + currentDsl.get(name).split("\n").length);
            context.log("----------------------------------------------");
            context.log(currentDsl.get(name));
        }
        HashSet<String> previousFiles = new HashSet<String>(previousDsl.keySet());
        previousFiles.removeAll(currentDsl.keySet());
        for (String name : previousFiles) {
            context.show("Removed DSL file: " + name + ". Total lines: " + previousDsl.get(name).split("\n").length);
            context.log("----------------------------------------------");
            context.log(previousDsl.get(name));
        }
        HashSet<String> sharedFiles = new HashSet<String>(currentDsl.keySet());
        sharedFiles.retainAll(previousDsl.keySet());
        diff_match_patch diff = new diff_match_patch();
        boolean hasChanges = false;
        for (String name : sharedFiles) {
            String previous;
            String current = currentDsl.get(name);
            if (current.equals(previous = previousDsl.get(name))) continue;
            LinkedList<diff_match_patch.Diff> changes = diff.diff_main(previous, current);
            context.show("Changed DSL file: " + name);
            context.show("----------------------------------------------");
            int totalDiffs = changes.size();
            int cur = 0;
            hasChanges = hasChanges || totalDiffs > 0;
            StringBuilder sb = new StringBuilder();
            boolean inColor = !context.contains(DisableColors.INSTANCE);
            for (diff_match_patch.Diff aDiff : changes) {
                ++cur;
                String text = aDiff.text;
                switch (aDiff.operation) {
                    case INSERT: {
                        if (inColor) {
                            sb.append(Context.inColor(Ansi.Color.GREEN, text));
                            break;
                        }
                        sb.append("[+ ").append(text).append(']');
                        break;
                    }
                    case DELETE: {
                        if (inColor) {
                            sb.append(Context.inColor(Ansi.Color.RED, text));
                            break;
                        }
                        sb.append("[- ").append(text).append(']');
                        break;
                    }
                    case EQUAL: {
                        int i;
                        int width;
                        String[] lines = text.split("\n");
                        if (cur < totalDiffs) {
                            if (lines.length <= 10) {
                                sb.append(text);
                                break;
                            }
                            width = 0;
                            if (cur > 1) {
                                for (i = 0; i < 5; ++i) {
                                    width += lines[i].length() + 1;
                                }
                                sb.append(text.substring(0, width));
                                width = 0;
                            }
                            for (i = Math.max(5, lines.length - 5); i < lines.length; ++i) {
                                width += lines[i].length() + 1;
                            }
                            sb.append("\n").append("...").append("\n");
                            sb.append(text.substring(text.length() - width));
                            break;
                        }
                        if (lines.length <= 5) {
                            sb.append(text);
                        }
                        width = 0;
                        for (i = 0; i < 5; ++i) {
                            width += lines[i].length() + 1;
                        }
                        sb.append(text.substring(0, width));
                    }
                }
            }
            context.show(sb.toString());
            context.show(new String[0]);
        }
        if (currentFiles.size() == 0 && previousFiles.size() == 0 && !hasChanges) {
            context.show("No changes found in DSL");
        }
    }

    @Override
    public boolean check(Context context) throws ExitException {
        if (context.contains(INSTANCE) && !context.contains(PostgresConnection.INSTANCE) && !context.contains(OracleConnection.INSTANCE)) {
            context.error("Connection string is required to perform a diff operation.\nNeither Oracle or Postgres connection string detected");
            throw new ExitException();
        }
        return true;
    }

    @Override
    public void run(Context context) throws ExitException {
        if (context.contains(INSTANCE)) {
            Map<String, String> previousDsl;
            if (context.contains(PostgresConnection.INSTANCE)) {
                previousDsl = PostgresConnection.getDatabaseDsl(context);
                context.show("Comparing Postgres DSL diff...");
                context.show(new String[0]);
                Diff.compareDsls(context, previousDsl);
            }
            if (context.contains(OracleConnection.INSTANCE)) {
                previousDsl = OracleConnection.getDatabaseDsl(context);
                context.show("Comparing Oracle DSL diff...");
                context.show(new String[0]);
                Diff.compareDsls(context, previousDsl);
            }
        }
    }

    @Override
    public String getShortDescription() {
        return "Diff current DSL files to previous DSL files";
    }

    @Override
    public String getDetailedDescription() {
        return "Provide diff on changed DSL files. For fast confirmation of changes done before creating new library models or SQL migrations.\nDiff requires read-only access to -DSL- schema in Postgres/Oracle database where previously applied DSL is stored.\nTo disable diff confirmation, use no prompt parameter.";
    }
}

