/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client.parameters;

import com.dslplatform.compiler.client.CompileParameter;
import com.dslplatform.compiler.client.Context;
import com.dslplatform.compiler.client.Either;
import com.dslplatform.compiler.client.ParameterParser;
import com.dslplatform.compiler.client.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PropertiesFile
implements CompileParameter {
    private final List<CompileParameter> parameters;

    public PropertiesFile(List<CompileParameter> parameters) {
        this.parameters = parameters;
    }

    @Override
    public String getAlias() {
        return "properties";
    }

    @Override
    public String getUsage() {
        return "file";
    }

    @Override
    public boolean check(Context context) {
        if (context.contains(this)) {
            String properties = context.get(this);
            if (properties == null || properties.length() == 0) {
                context.error("Incorrectly defined .properties file");
                return false;
            }
            File file = new File(properties);
            if (!file.exists()) {
                context.error("Can't find specified properties file: " + file.getAbsolutePath());
                return false;
            }
            Either<String> content = Utils.readFile(file);
            if (!content.isSuccess()) {
                context.error("Error reading specified properties file: " + file.getAbsolutePath());
                return false;
            }
            ArrayList<ParameterParser> customParsers = new ArrayList<ParameterParser>();
            for (CompileParameter cp : this.parameters) {
                if (!(cp instanceof ParameterParser)) continue;
                customParsers.add((ParameterParser)((Object)cp));
            }
            ArrayList<String> errors = new ArrayList<String>();
            for (String row : content.get().split("\n")) {
                String line = row.trim();
                if (line.length() == 0 || line.startsWith("#") || line.startsWith("//")) continue;
                int eq = line.indexOf(61);
                String name = line.substring(0, eq != -1 ? eq : line.length());
                String value = eq == -1 ? null : line.substring(eq + 1);
                CompileParameter cp = this.from(name);
                if (cp == null) {
                    boolean matched = false;
                    for (ParameterParser parser : customParsers) {
                        Either<Boolean> tryParse = parser.tryParse(name, value, context);
                        if (!tryParse.isSuccess()) {
                            errors.add(tryParse.explainError());
                            matched = true;
                            break;
                        }
                        if (!tryParse.get().booleanValue()) continue;
                        matched = true;
                        break;
                    }
                    if (matched) continue;
                    errors.add("Unknown parameter: " + name);
                    continue;
                }
                if (eq == -1 && cp.getUsage() != null) {
                    if (cp instanceof ParameterParser) {
                        Either<Boolean> tryParse = ((ParameterParser)((Object)cp)).tryParse(name, null, context);
                        if (tryParse.isSuccess() && tryParse.get().booleanValue()) {
                            context.put(cp, null);
                            continue;
                        }
                        errors.add("Expecting " + cp.getUsage() + " after = for " + line);
                        continue;
                    }
                    errors.add("Expecting " + cp.getUsage() + " after = for " + line);
                    continue;
                }
                context.put(cp, value);
            }
            if (errors.size() > 0) {
                context.error("Errors found in properties file: " + file.getAbsolutePath());
                for (String err : errors) {
                    context.error(err);
                }
                return false;
            }
        }
        return true;
    }

    private CompileParameter from(String value) {
        for (CompileParameter cp : this.parameters) {
            if (!cp.getAlias().equalsIgnoreCase(value)) continue;
            return cp;
        }
        return null;
    }

    @Override
    public void run(Context context) {
    }

    @Override
    public String getShortDescription() {
        return "Use file with predefined arguments";
    }

    @Override
    public String getDetailedDescription() {
        return "Instead of passing arguments special file can be used instead.\nA simple properties file with the same exact names for properties.\n\nExample compile_java.properties:\n\ttarget=java_client\n\tpostgres=localhost/Database?user=user&password=password\n\tdownload\n\tmigration\n\tapply\n";
    }
}

