/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client.parameters;

import com.dslplatform.compiler.client.CompileParameter;
import com.dslplatform.compiler.client.Context;
import com.dslplatform.compiler.client.ExitException;
import com.dslplatform.compiler.client.parameters.Force;
import java.io.File;

public enum SqlPath implements CompileParameter
{
    INSTANCE;


    @Override
    public String getAlias() {
        return "sql";
    }

    @Override
    public String getUsage() {
        return "path";
    }

    @Override
    public boolean check(Context context) throws ExitException {
        String value;
        if (context.contains(INSTANCE) && (value = context.get(INSTANCE)) != null && value.length() > 0) {
            File sqlPath = new File(value);
            if (!sqlPath.exists()) {
                if (!context.contains(Force.INSTANCE)) {
                    context.warning("SQL path provided (" + sqlPath.getAbsolutePath() + ") but doesn't exist.");
                    if (!context.canInteract()) {
                        context.error("Specify existing path or remove parameter to use temporary folder.");
                        return false;
                    }
                    String answer = context.ask("Create directory for SQL scripts (" + sqlPath.getAbsolutePath() + ") (y/N):");
                    if (!"y".equalsIgnoreCase(answer)) {
                        throw new ExitException();
                    }
                } else {
                    context.log("Creating SQL folder due to force option");
                }
                if (!sqlPath.mkdirs()) {
                    context.error("Failed to create SQL folder.");
                    throw new ExitException();
                }
            } else if (!sqlPath.isDirectory()) {
                context.error("SQL path provided (" + sqlPath.getAbsolutePath() + ") but it's not a directory.");
                return false;
            }
        }
        return true;
    }

    @Override
    public void run(Context context) {
    }

    @Override
    public String getShortDescription() {
        return "Where to save SQL migration";
    }

    @Override
    public String getDetailedDescription() {
        return "SQL migration script which contains DDL changes..\nWhen deploying changes to the production, previously created SQL script should be applied.\nSQL path can be specified so created/applied SQL scripts can be stored and used later.";
    }
}

