/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client.parameters;

import com.dslplatform.compiler.client.CompileParameter;
import com.dslplatform.compiler.client.Context;
import com.dslplatform.compiler.client.ExitException;
import com.dslplatform.compiler.client.Utils;
import com.dslplatform.compiler.client.parameters.Download;
import com.dslplatform.compiler.client.parameters.Force;
import java.io.File;
import java.io.IOException;
import java.util.UUID;

public enum TempPath implements CompileParameter
{
    INSTANCE;

    private static final String CACHE_NAME = "temp_path_cache";

    @Override
    public String getAlias() {
        return "temp";
    }

    @Override
    public String getUsage() {
        return "path";
    }

    public static File getTempProjectPath(Context context) {
        return (File)context.load(CACHE_NAME);
    }

    public static File getTempRootPath(Context context) throws ExitException {
        File temp = (File)context.load(CACHE_NAME);
        if (temp == null) {
            if (TempPath.prepareSystemTempPath(context)) {
                temp = (File)context.load(CACHE_NAME);
            }
            if (temp == null) {
                context.error("Unable to setup temporary path");
                throw new ExitException();
            }
        }
        return context.contains(INSTANCE) ? temp : temp.getParentFile();
    }

    private static boolean prepareSystemTempPath(Context context) {
        try {
            String projectLocation = System.getProperty("user.dir");
            File parentFolder = new File(projectLocation).getParentFile();
            String projectName = parentFolder == null || parentFolder.getName().isEmpty() ? "root" : parentFolder.getName();
            String rnd = UUID.randomUUID().toString();
            File temp = File.createTempFile(rnd, ".dsl-test");
            String dslName = Download.isDefaultUrl(context) ? "DSL-Platform" : "DSL-Custom";
            File dslPlatformPath = new File(temp.getParentFile().getAbsolutePath(), dslName);
            File path = new File(dslPlatformPath, projectName);
            if (!temp.delete()) {
                context.error("Unable to remove temporary created file: " + temp.getAbsolutePath());
                return false;
            }
            if (path.exists()) {
                Utils.deletePath(path);
            } else if (!path.mkdirs()) {
                context.error("Error creating temporary path in: " + path.getAbsolutePath());
                return false;
            }
            context.cache(CACHE_NAME, path);
            return true;
        }
        catch (IOException e) {
            context.error("Error preparing system temporary path.");
            context.error(e);
            return false;
        }
    }

    private static boolean prepareCustomPath(Context context, File path) {
        try {
            Utils.deletePath(path);
            context.cache(CACHE_NAME, path);
            return true;
        }
        catch (IOException e) {
            context.error("Error preparing custom temporary path.");
            context.error(e);
            return false;
        }
    }

    @Override
    public boolean check(Context context) {
        String value;
        if (context.contains(INSTANCE) && (value = context.get(INSTANCE)) != null && value.length() > 0) {
            File path = new File(value);
            if (!path.exists()) {
                if (!context.contains(Force.INSTANCE)) {
                    context.error("Temporary path provided (" + value + "), but doesn't exist. Please create it or use system path.");
                    return false;
                }
                context.show("Due to force option enabled, creating temp folder in: " + path.getAbsolutePath());
                if (!path.mkdirs()) {
                    context.error("Failed to create temporary path.");
                    return false;
                }
            }
            if (!path.isDirectory()) {
                context.error("Temporary path provided, but it's not a directory: " + value);
                return false;
            }
            File[] tempFiles = path.listFiles();
            if (tempFiles != null && tempFiles.length > 0) {
                if (!context.contains(Force.INSTANCE)) {
                    context.warning("Temporary path contains files: " + path.getAbsolutePath());
                    if (!context.canInteract()) {
                        context.error("Please manage the path you have assigned as temporary or use force option for automatic cleanup.");
                        return false;
                    }
                    String delete = context.ask("Delete files in temporary path? (y/N):");
                    if (!"y".equalsIgnoreCase(delete)) {
                        return false;
                    }
                } else {
                    context.log("Cleaning up TEMP folder due to force option");
                }
                return TempPath.prepareCustomPath(context, path);
            }
            context.cache(CACHE_NAME, path);
            return true;
        }
        return TempPath.prepareSystemTempPath(context);
    }

    @Override
    public void run(Context context) {
    }

    @Override
    public String getShortDescription() {
        return "Use custom temporary path instead of system default";
    }

    @Override
    public String getDetailedDescription() {
        return "Files downloaded from DSL Platform will be stored to temporary path.\nWhen unspecified /DSL-Platform folder in system default temporary path will be used.";
    }
}

