/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client.parameters.build;

import com.dslplatform.compiler.client.Context;
import com.dslplatform.compiler.client.Either;
import com.dslplatform.compiler.client.ExitException;
import com.dslplatform.compiler.client.parameters.Dependencies;
import com.dslplatform.compiler.client.parameters.Download;
import com.dslplatform.compiler.client.parameters.Namespace;
import com.dslplatform.compiler.client.parameters.build.BuildAction;
import com.dslplatform.compiler.client.parameters.build.ScalaCompilation;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class CompileRevenjScala
implements BuildAction {
    private final String id;
    private final String zip;
    private final String[] maven;

    public CompileRevenjScala(String id, String zip, String ... maven) {
        this.id = id;
        this.zip = zip;
        this.maven = maven;
    }

    @Override
    public boolean check(Context context) throws ExitException {
        return Download.checkJars(context, "Revenj Scala server", this.zip, this.id, "net/revenj", this.maven);
    }

    @Override
    public void build(File sources, Context context) throws ExitException {
        File libDeps = Dependencies.getDependencies(context, "Revenj.Scala", this.id);
        String customJar = context.get(this.id);
        File model = new File(customJar != null ? customJar : "./generated-server-model-scala.jar");
        String namespace = context.get(Namespace.INSTANCE);
        String bootClass = namespace != null && namespace.length() > 0 ? namespace + ".Boot" : "Boot";
        HashMap<String, List<String>> services = new HashMap<String, List<String>>();
        services.put("net.revenj.extensibility.SystemAspect", Collections.singletonList(bootClass));
        Either<String> compilation = ScalaCompilation.compile("revenj", libDeps, sources, model, services, context);
        if (!compilation.isSuccess()) {
            context.error("Error during Revenj.Scala library compilation.");
            context.error(compilation.whyNot());
            throw new ExitException();
        }
        if (!model.exists()) {
            context.error("Can't seem to find compiled Revenj.Scala library: " + model.getAbsolutePath());
            context.log(compilation.get());
            throw new ExitException();
        }
        context.show("Compiled Revenj.Scala library to: " + model.getAbsolutePath());
    }
}

