/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client.parameters.build;

import com.dslplatform.compiler.client.Context;
import com.dslplatform.compiler.client.ExitException;
import com.dslplatform.compiler.client.parameters.build.PrepareSources;
import java.io.File;

public class PreparePhpUI
extends PrepareSources {
    public PreparePhpUI(String targetName, String targetId, String targetFolder) {
        super(targetName, targetId, targetFolder);
    }

    private void fixMissingExtensions(File sources, Context context) {
        String[] children = sources.list();
        if (children == null) {
            return;
        }
        for (String fn : children) {
            File sf = new File(sources, fn);
            if (sf.isFile() && sf.getName().endsWith(".twig.php")) {
                String twigOnly = sf.getName().substring(0, sf.getName().length() - 4);
                if (sf.renameTo(new File(sf.getParentFile(), twigOnly))) continue;
                context.error("Error renaming file " + sf.getAbsolutePath() + " to : " + twigOnly);
                continue;
            }
            if (!sf.isDirectory()) continue;
            this.fixMissingExtensions(sf, context);
        }
    }

    @Override
    public void build(File sources, Context context) throws ExitException {
        this.fixMissingExtensions(sources, context);
        super.build(sources, context);
    }
}

